---
name: Audience Segmenter
slug: audience-segmenter
description: Segment audiences for targeted marketing and personalized messaging
category: marketing
complexity: intermediate
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "audience segmentation"
  - "customer segments"
  - "target audience"
  - "buyer personas"
  - "market segmentation"
tags:
  - segmentation
  - targeting
  - personalization
  - audience-strategy
  - customer-data
---

# Audience Segmenter

Divide your audience into meaningful segments that enable targeted, personalized marketing at scale. This skill helps you identify distinct customer groups based on behavior, demographics, psychographics, and value, then tailor your messaging and offers accordingly.

One-size-fits-all marketing underperforms. This skill provides frameworks for discovering natural audience clusters, defining segment criteria, and developing differentiated strategies for each group. The result: higher relevance, better engagement, and improved conversion across all marketing channels.

Essential for marketers, product managers, and growth teams who want to move beyond generic messaging to true personalization.

## Core Workflows

### Workflow 1: Behavioral Segmentation
1. **Usage Pattern Analysis** - How customers interact with product
2. **Purchase Behavior** - Frequency, recency, monetary value (RFM)
3. **Engagement Levels** - Email opens, site visits, feature usage
4. **Lifecycle Stage** - New, active, at-risk, churned
5. **Feature Adoption** - Which capabilities they use
6. **Channel Preference** - Where they engage most
7. **Segment Definition** - Actionable behavioral groups

### Workflow 2: Persona Development
1. **Research Foundation** - Interviews, surveys, data analysis
2. **Demographic Profiles** - Role, company size, industry
3. **Psychographic Insights** - Goals, challenges, motivations
4. **Decision-Making Process** - How they evaluate and buy
5. **Information Sources** - Where they learn and research
6. **Objection Mapping** - Common hesitations and concerns
7. **Persona Documentation** - Shareable persona cards

### Workflow 3: Value-Based Segmentation
1. **Customer Lifetime Value Calculation** - LTV by customer
2. **Profitability Analysis** - Revenue minus cost to serve
3. **Growth Potential** - Expansion opportunity scoring
4. **Churn Risk Assessment** - Likelihood of leaving
5. **Tier Definition** - VIP, standard, low-value segments
6. **Resource Allocation** - Investment by segment value
7. **Retention Strategy** - Differentiated approaches

### Workflow 4: Segment Activation
1. **Segment Criteria** - Clear, measurable definitions
2. **Data Requirements** - What's needed to identify segments
3. **Platform Setup** - Configure segmentation in tools
4. **Content Mapping** - Match content to segment needs
5. **Channel Strategy** - Right channel for each segment
6. **Personalization Rules** - Dynamic content and offers
7. **Measurement Framework** - Track segment performance

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| RFM segmentation | "Segment customers by RFM analysis" |
| Persona creation | "Create buyer persona for [audience]" |
| Behavioral segments | "Identify behavioral segments in [data]" |
| Value tiers | "Create customer value tiers" |
| Segment messaging | "Develop messaging for [segment]" |
| Lifecycle stages | "Define customer lifecycle stages" |
| Lookalike criteria | "Identify traits of best customers" |
| Segment strategy | "Create strategy for [segment]" |

## Best Practices

- **Start with data** - Segments should emerge from reality, not assumptions
- **Actionable segments** - If you can't reach them differently, why segment?
- **Mutual exclusivity** - Clear boundaries between segments
- **Meaningful size** - Segments must be large enough to matter
- **Stability over time** - Segments shouldn't shift constantly
- **Accessibility** - Can you actually identify and reach them?
- **Profitability focus** - Understand segment economics
- **Document criteria** - Clear definitions everyone understands
- **Validate with research** - Quantitative and qualitative
- **Avoid over-segmentation** - More isn't always better
- **Update regularly** - Segments evolve as markets change
- **Test segment strategies** - Measure differential response
- **Share across teams** - Sales, product, support benefit from segments
- **Consider journey stage** - Segment by where they are
- **Balance precision and scale** - Too precise = too small
