---
name: authentic-voice
description: Transform AI-sounding writing into natural, human prose. Use when creating or editing any written content—articles, essays, reports, emails, social posts, scripts, or marketing copy—to avoid patterns that signal AI authorship. Triggers on requests to "make it sound human," "less AI," "more natural," improve voice/tone, or any writing task where authentic style matters.
---

# Authentic Voice

Write like a human, not a language model. This skill eliminates the telltale patterns that make AI writing detectable.

## Core Principle

LLMs regress to the mean—replacing specific, unusual facts (statistically rare) with generic, positive descriptions (statistically common). The result: shouting louder that something matters while the actual content fades from sharp photograph to blurry sketch. Human writing does the opposite.

## Before Writing

1. Read `references/ai-tells.md` for the complete catalog of patterns to avoid
2. Choose a specific angle rather than comprehensive coverage
3. Identify concrete details, not abstract claims

## The Five Deadly Patterns

### 1. Puffing Importance

LLMs insert claims about significance, legacy, and symbolism constantly. Delete these unless you can show evidence.

**Words to watch:** stands/serves as, is a testament/reminder, plays a vital/significant/crucial/pivotal role, underscores/highlights its importance, reflects broader, symbolizing its ongoing/enduring impact, key turning point, indelible mark, profound heritage

**AI:** "The founding represented a significant shift toward regional independence, enabling Catalonia to develop a system tailored to its unique socio-economic context. This initiative was part of a broader movement across Spain to decentralize administrative functions."

**Human:** "The 1989 law gave Catalonia its own census bureau."

### 2. Tailing Participles

Sentences that end with "-ing" phrases claiming what something means. Cut these entirely.

**Words to watch:** ensuring..., highlighting..., emphasizing..., reflecting..., underscoring..., showcasing..., contributing to..., cultivating...

**AI:** "The civil rights movement emerged as a powerful continuation of this struggle, emphasizing the importance of solidarity and collective action in the fight for justice."

**Human:** "The civil rights movement continued that fight."

### 3. Negative Parallelism

"Not X, but Y" constructions that try to sound balanced. Just say Y.

**Patterns:** "It's not just about X, it's about Y" / "Not only does it X, but it also Y" / "This is not merely X—it's Y"

**AI:** "The 'Black Hole Edition' is not just a meme—it's a celebration of grassroots car culture."

**Human:** "The 'Black Hole Edition' became a running joke in car forums."

### 4. Ghost Language

AI is obsessed with the spectral. Everything is quiet, soft, a whisper, a shadow, a memory. Sensory language gets attached to abstract concepts.

**AI:** "Thursday is a liminal day that tastes of almost-Friday. Grief has a color. Sorrow tastes of metal."

**Human:** (Just don't write like this)

### 5. Promotional Puffery

LLMs write like TV commercials, especially about places and cultural heritage.

**Words to watch:** continues to captivate, stunning natural beauty, enduring/lasting legacy, nestled, in the heart of, boasts a..., breathtaking, vibrant, diverse tapestry

**AI:** "Nestled within the breathtaking region of Gonder in Ethiopia, Alamata Raya Kobo stands as a vibrant town with a rich cultural heritage."

**Human:** "Alamata Raya Kobo is a market town in Gonder, about three hours from the regional capital."

## Quick Reference Table

| Pattern | Example | Fix |
|---------|---------|-----|
| Tailing participles | "...highlighting the significance of..." | Delete |
| Negative parallelism | "It's not just X, it's Y" | Say Y directly |
| Em dash overuse | "The policy—which changed everything—was controversial" | Use commas or periods |
| Hedged importance | "It's important to note that..." | Just state it |
| Rule of three | "fast, efficient, and reliable" | Pick one or two |
| Weasel attribution | "Many experts believe..." | Name sources or own the claim |
| Media listing | "Featured in Wired, Vogue, and CNN" | Only if genuinely relevant |
| Social media mention | "maintains an active social media presence" | Delete (obvious for anyone alive) |

## Vocabulary Swaps

See `references/ai-tells.md` for the complete list. Quick substitutions:

- delve → look at, examine, dig into
- leverage/utilize → use
- landscape → field, area, market
- tapestry → mix, blend
- pivotal/crucial → (show why it matters instead)
- comprehensive → thorough, full
- nuanced → subtle, detailed
- foster → build, encourage
- navigate → handle, work through
- showcase → show, display
- underscore → (delete—facts don't underscore things)

## Voice Checklist

Before finalizing:

- [ ] No sentence claims importance without evidence
- [ ] Specific details outnumber abstract descriptions
- [ ] Sentence lengths vary dramatically
- [ ] No more than one em dash per paragraph
- [ ] Opening doesn't start with "In today's..." or "In the realm of..."
- [ ] No sycophantic openers ("Certainly!", "Great question!")
- [ ] Lists avoid exactly three items
- [ ] No "-ing" phrases at the end claiming significance
- [ ] Nothing "stands as a testament" to anything

## What's NOT an AI Tell

Don't overcorrect. These are NOT reliable indicators:

- Sophisticated vocabulary (AI actually avoids rare words)
- Starting sentences with conjunctions
- Mixed formal/casual registers
- "Bland" prose (AI tends toward effusive, not robotic)
- Perfect grammar (many humans write correctly too)

## Format Notes

**Short-form:** Personality first. Contractions. Start mid-thought. End without wrapping up.

**Long-form:** Lead with your sharpest specific insight. Broad context can wait—or be cut.

**Professional:** "Use" not "utilize." "Help" not "facilitate." Fewest words possible.
