# Auto Issue Fixer - Completion Report

---

## Issue

| Field | Value |
|-------|-------|
| **Number** | #[issue_number] |
| **Title** | [issue_title] |
| **URL** | [issue_url] |
| **Priority Score** | [priority_score]/100 |
| **Labels** | [labels] |

---

## Pull Request

| Field | Value |
|-------|-------|
| **Number** | #[pr_number] |
| **Title** | [pr_title] |
| **URL** | [pr_url] |
| **Status** | Ready for review |
| **Branch** | `[branch_name]` |

---

## TDD Summary

| Phase | Status | Details |
|-------|--------|---------|
| RED | Complete | [test_count] test cases written |
| GREEN | Complete | [files_modified] files modified |
| REFACTOR | Complete | [cleanup_count] improvements applied |

### Tests Added

| Test | File | Purpose |
|------|------|---------|
| `[test_name]` | `[file]` | [What it tests] |
| `[test_name]` | `[file]` | [What it tests] |

### Files Modified

| File | Change Type |
|------|-------------|
| `[file_path]` | [Modified/Created] |
| `[file_path]` | [Modified/Created] |

---

## CI Status

| Check | Status |
|-------|--------|
| Tests | PASS |
| Lint | PASS |
| Type Check | PASS |
| Build | PASS |

---

## Feedback Handling

| Metric | Value |
|--------|-------|
| **Feedback Iterations** | [iterations]/[max_iterations] |
| **Code Changes Applied** | [code_changes] |
| **Responses Provided** | [responses] |
| **Declined Suggestions** | [declined] |
| **New Issues Created** | [new_issues] |

### Feedback Summary

#### Applied Changes
- [Change 1 description]
- [Change 2 description]

#### Responses Given
- Re: [topic] - [response summary]

#### Declined (with reason)
- Re: [suggestion] - [reason for declining]

---

## Timeline

| Event | Timestamp |
|-------|-----------|
| Started | [start_time] |
| Issue Selected | [selection_time] |
| Tests Written | [red_time] |
| Implementation Complete | [green_time] |
| PR Created | [pr_created_time] |
| CI First Pass | [ci_time] |
| Marked Ready | [ready_time] |
| **Total Duration** | [duration] |

---

## Commits

| SHA | Message |
|-----|---------|
| `[sha_short]` | [commit_message] |
| `[sha_short]` | [commit_message] |

---

## Next Steps

**For Human Reviewer**:
1. Review the implementation at [pr_url]
2. Verify the fix addresses the original issue
3. Check test coverage is adequate
4. Approve and merge when satisfied

**Post-Merge**:
- Issue #[issue_number] will auto-close on merge
- Run `/cleanup-issue [issue_number]` to clean up worktree

---

## Escalation Notes

[If any escalations occurred, document them here]

- None - completed autonomously

---

*Generated by auto-issue-fixer skill at [timestamp]*
