# TDD Implementation Plan

**Issue**: #[number] - [title]
**URL**: [issue_url]
**Priority Score**: [score]/100

---

## Summary

[One-sentence description of what needs to be done]

## Root Cause Analysis

[For bugs: explain why this is happening]
[For features: explain what's missing]

---

## Phase 1: RED - Write Failing Tests

### Test Cases

#### Test 1: [test_name]
- **File**: `[test_file_path]`
- **Function**: `[test_function_name]`
- **Verifies**: [What behavior this test checks]
- **Expected failure**: [Why it will fail before implementation]

```[language]
[test_code_skeleton]
```

#### Test 2: [test_name]
- **File**: `[test_file_path]`
- **Function**: `[test_function_name]`
- **Verifies**: [What behavior this test checks]

```[language]
[test_code_skeleton]
```

#### Test 3: [test_name] (Edge Case)
- **File**: `[test_file_path]`
- **Function**: `[test_function_name]`
- **Verifies**: [Edge case handling]

```[language]
[test_code_skeleton]
```

### Verify RED

```bash
[TEST_COMMAND]
# Expected output: FAIL
# Expected failures:
# - [test_1]: [expected_error]
# - [test_2]: [expected_error]
```

---

## Phase 2: GREEN - Minimal Implementation

### Files to Modify

| File | Change Type | Description |
|------|-------------|-------------|
| `[file_path]` | Modify | [What to change] |
| `[file_path]` | Create | [New file purpose] |

### Implementation Steps

1. **[Step 1 title]**
   - File: `[file_path]`
   - Change: [Specific change description]
   ```[language]
   [code_snippet]
   ```

2. **[Step 2 title]**
   - File: `[file_path]`
   - Change: [Specific change description]
   ```[language]
   [code_snippet]
   ```

3. **[Step 3 title]**
   - File: `[file_path]`
   - Change: [Specific change description]

### Verify GREEN

```bash
[TEST_COMMAND]
# Expected output: PASS
# All tests should now pass
```

---

## Phase 3: REFACTOR - Cleanup

### Refactoring Opportunities

1. **[Refactor 1]**: [Description]
   - Current: [Current state]
   - Improved: [After refactoring]

2. **[Refactor 2]**: [Description]
   - DRY violation in [location]
   - Extract to [new location]

### Code Quality Checks

- [ ] No duplicate code introduced
- [ ] Naming follows project conventions
- [ ] Comments added where logic is complex
- [ ] No unused imports/variables

### Final Verification

```bash
[TEST_COMMAND] && [LINT_COMMAND] && [BUILD_COMMAND]
# All must pass
```

---

## Existing Tests to Preserve

These tests must continue passing:

| Test File | Test Name | Purpose |
|-----------|-----------|---------|
| `[file]` | `[test_name]` | [What it tests] |
| `[file]` | `[test_name]` | [What it tests] |

---

## Verification Commands

| Command | Purpose |
|---------|---------|
| `[test_command]` | Run tests |
| `[lint_command]` | Check linting |
| `[typecheck_command]` | Type checking |
| `[build_command]` | Build project |

---

## Risks and Edge Cases

| Risk | Mitigation |
|------|------------|
| [Risk 1] | [How to handle] |
| [Risk 2] | [How to handle] |

### Edge Cases to Test

- [ ] [Edge case 1]
- [ ] [Edge case 2]
- [ ] [Edge case 3]

---

## Complexity Assessment

**Estimated Complexity**: [Low/Medium/High]

| Factor | Assessment |
|--------|------------|
| Files affected | [count] |
| Lines of code | ~[estimate] |
| Test coverage | [Good/Needs work] |
| Dependencies | [None/Some/Many] |

---

*Generated by auto-issue-fixer skill*
