---
name: azure-ad
description: Azure AD/Entra ID operations including user queries, group management, and guest invitation. Use for listing users, searching groups, checking memberships, inviting external guests, or troubleshooting Azure AD.
---

# Azure AD/Entra ID Operations

## IMPORTANT: Intent Detection

Parse user input to determine intent:

| User Input | Intent | Action |
|------------|--------|--------|
| `help`, `how to invite`, `usage`, `format` | Help | Respond with usage info below |
| Contains email + invite intent | Execute | Run invite script |
| Query about users/groups | Query | Use az CLI commands |

## Guest User Invitation (`/invite`)

Invite external users to Azure AD tenant with optional group membership and OSDU preshipping access.

### Usage

```
/invite user@company.com
/invite user@company.com --groups "Group1,Group2"
/invite user@company.com --groups "Group1" --preshipping
/invite user@company.com --like existing@company.com
```

### Examples

| Command | What It Does |
|---------|--------------|
| `/invite john.doen@email.com` | Invite to tenant only |
| `/invite johh.doe@email.com --groups "AzOSDUPreshipReaders"` | Invite and add to AD group |
| `/invite john.doe@email.com --groups "AzOSDUPreshipReaders,ExternalUsers" --preshipping` | Full setup: tenant + groups + OSDU |
| `/invite new@email.com --like existing@email.com` | Copy AD groups from existing user |
| `/invite user@company.com --dry-run` | Preview without making changes |

### Options

| Option | Description |
|--------|-------------|
| `--groups "G1,G2"` | Add to these AD groups (comma-separated) |
| `--preshipping` | Also provision OSDU preshipping access |
| `--like EMAIL` | Copy AD groups from an existing user |
| `--dry-run` | Preview without making changes |

### Workflow

1. Run `/audit <company>` to see how existing users are set up
2. Note their AD groups and whether they have preshipping access
3. Run `/invite` with the same setup for new users

### Common AD Groups

| Group | Purpose |
|-------|---------|
| AzOSDUPreshipReaders | OSDU preshipping read access |
| AzOSDUPreshipEditors | OSDU preshipping edit access |
| ExternalUsers | Standard external user group |

---

## AI Execution (Internal)

When user requests an invite (not help), run:

```bash
uv run .claude/skills/azure-ad/scripts/invite.py invite \
  --email "EMAIL" \
  [--groups "GROUP1,GROUP2"] \
  [--preshipping] \
  [--like "EXISTING_EMAIL"] \
  [--dry-run]
```

### Output Presentation

**Present the script output directly to the user.** Do NOT summarize.

---

## Azure AD Queries

### Prerequisites

Verify Azure CLI authentication:

```bash
az account show --query "{name:name, user:user.name, tenantId:tenantId}" -o table
```

### User Queries

```bash
# List all users
az ad user list --query "[].{name:displayName, mail:mail, type:userType}" -o table

# Find specific user
az ad user show --id "user@example.com" -o table

# Filter guest users
az ad user list --filter "userType eq 'Guest'" -o table

# Search by name prefix
az ad user list --filter "startswith(displayName,'John')" -o table
```

### Group Queries

```bash
# List all groups
az ad group list --query "[].{name:displayName, type:securityEnabled}" -o table

# Get group members
az ad group member list --group "GroupName" --query "[].{name:displayName, mail:mail}" -o table

# Get user's groups
az ad user get-member-groups --id "user@example.com" -o table
```

### Group Management

```bash
# Add user to group
USER_ID=$(az ad user show --id "user@example.com" --query "id" -o tsv)
GROUP_ID=$(az ad group show --group "GroupName" --query "id" -o tsv)
az ad group member add --group "$GROUP_ID" --member-id "$USER_ID"
```

## Required Permissions

| Operation | Minimum Role |
|-----------|-------------|
| List users/groups | Directory Readers |
| Add to group | Groups Administrator |
| Invite guests | Guest Inviter |

## Error Handling

| Error | Cause | Solution |
|-------|-------|----------|
| `Authorization_RequestDenied` | Insufficient permissions | Request Directory Readers role |
| `Request_ResourceNotFound` | User/group not found | Verify spelling, use object ID |
| `Request_BadRequest` | Invalid filter | Check OData syntax |

## Reference Files

- [reference/commands.md](reference/commands.md) - Full CLI command reference
- [reference/troubleshooting.md](reference/troubleshooting.md) - Detailed error solutions
- [scripts/invite.py](scripts/invite.py) - Guest invitation script
