@description('Deployment location.')
param location string = resourceGroup().location

@minLength(3)
@maxLength(24)
@description('Storage account name. Must be globally unique, lowercase letters and numbers only.')
param storageAccountName string

@description('Resource tags.')
param tags object = {}

@allowed([
  'Standard_LRS'
  'Standard_GRS'
  'Standard_ZRS'
])
@description('Storage SKU.')
param skuName string = 'Standard_LRS'

@allowed([
  'Enabled'
  'Disabled'
])
@description('Public network access for storage account.')
param publicNetworkAccess string = 'Disabled'

resource stg 'Microsoft.Storage/storageAccounts@2023-01-01' = {
  name: storageAccountName
  location: location
  tags: tags
  sku: { name: skuName }
  kind: 'StorageV2'
  properties: {
    // 보안 요구사항
    publicNetworkAccess: publicNetworkAccess
    allowBlobPublicAccess: false
    minimumTlsVersion: 'TLS1_2'
  }
}

output storageId string = stg.id
output storageName string = stg.name
