---
name: azure-ops-triage
description: |
  Azure 구독/리소스 운영 점검을 수행할 때 사용한다.
  목표는 
  (1) 인증/구독 컨텍스트 확인 
  (2) 실행 중 리소스/비정상 리소스 탐색
  (3) 비용/스파이크 가능성 힌트 도출 
  (4) 조치 권고안
  을 체크리스트로 정리하는 것이다.
---

# Azure 운영 점검(Ops Triage) 스킬

## 언제 사용하는가
- "현재 구독에서 무엇이 돌아가는지", "문제 가능성이 있는 리소스가 무엇인지" 빠르게 파악해야 할 때 사용한다.
- 실무에서는 장애 초기 대응(상황파악) 또는 일일 점검에 사용한다.

## 수행 절차(반드시 순서대로)
1) **인증/테넌트/구독 컨텍스트 확인**
- Copilot for Azure 도구로 현재 auth context를 확인한다.
- 필요 시 테넌트/구독 변경 방법을 제안한다.

2) **실행 중이거나 비용 영향을 주는 리소스 후보를 찾는다**
- Azure Resource Graph(가능 시)로 VM, AKS, App Service, DB 등 비용 유발 리소스를 우선 탐색한다.
- 결과는 "리소스 유형 / 이름 / RG / 위치 / 상태(가능 시)" 형태로 요약한다.

3) **이상 징후(초보 기준) 체크**
- 최근 생성/변경이 많은 RG 또는 리소스 유형이 있는지 확인한다.
- 네트워크 보안(NSG/공개 노출) 힌트를 한 줄로 표시한다(확정 진단이 아니라 '점검 포인트'로만).

4) **조치 권고안 작성**
- (A) 지금 당장 확인할 것 (B) 30분 내 조치 후보 (C) 이후 개선 과제 형태로 체크리스트를 제시한다.

## 출력 형식
- 1페이지 요약(헤더: Tenant/Subscription)
- Top 10 리소스 리스트(표 형태가 아닌 목록)
- "점검 포인트" 5개
- "다음 액션" 체크리스트