---
name: Backend API
description: Design and implement RESTful API endpoints following REST principles with proper HTTP methods, status codes, and resource-based URL patterns. Use this skill when creating or modifying API route handlers, controllers, or endpoint definitions in backend frameworks (Express, NestJS, FastAPI, Django REST Framework, etc.). Use when working with API versioning strategies, implementing rate limiting, designing nested resource endpoints, or defining query parameter filtering and pagination. Use when writing files like routes.ts, controllers.ts, api.py, views.py, or any backend files that define HTTP endpoints and handle API requests/responses.
---

# Backend API

This Skill provides Claude Code with specific guidance on how to adhere to coding standards for backend API design and implementation.

## When to use this skill

- When creating or modifying API route definitions and endpoint handlers
- When working with backend controllers or route files (routes.ts, controllers.ts, api.py, views.py, handlers.go, etc.)
- When implementing RESTful API endpoints with proper HTTP methods (GET, POST, PUT, PATCH, DELETE)
- When designing API versioning strategies (URL path or header-based versioning)
- When setting up rate limiting and API usage quotas
- When creating nested resource endpoints or collection routes
- When implementing query parameter filtering, sorting, or pagination
- When defining HTTP status code responses for different scenarios
- When working with API middleware or request/response interceptors
- When structuring resource-based URLs following REST conventions

## Instructions

For details, refer to the information provided in this file:
[backend API](../../../agent-os/standards/backend/api.md)
