---
name: Backend Models
description: Define and structure database models and entities with proper naming conventions, timestamps, data integrity constraints, relationships, and validation layers. Use this skill when creating or modifying ORM model definitions, database entity classes, schema definitions, or data access layer objects. Use when working with TypeORM entities, Sequelize models, SQLAlchemy models, Mongoose schemas, Django models, Prisma schema files, or any framework-specific model files (models.ts, entities.py, schema.prisma, models.py). Use when defining table structures, foreign key relationships, database constraints (NOT NULL, UNIQUE), indexes, or multi-layer validation rules. Use when implementing repository patterns or designing data models that balance normalization with query performance.
---

# Backend Models

This Skill provides Claude Code with specific guidance on how to adhere to coding standards for database models and entity design.

## When to use this skill

- When creating or modifying ORM model/entity definition files
- When working with model files (models.ts, entities.py, schema.prisma, models.py, models.rb, etc.)
- When defining database table structures and column properties
- When setting up relationships between models (one-to-many, many-to-many, etc.)
- When implementing database constraints (NOT NULL, UNIQUE, foreign keys)
- When adding timestamps (createdAt, updatedAt) to models
- When choosing appropriate data types for model fields
- When creating indexes on frequently queried columns
- When implementing validation at the model layer
- When designing repository patterns for data access
- When balancing database normalization with query performance needs
- When defining cascade behaviors for related entities

## Instructions

For details, refer to the information provided in this file:
[backend models](../../../agent-os/standards/backend/models.md)
