---
name: battle-plan
description: Creates a comprehensive action plan that addresses both substance (strengthening your proposal, filling evidence gaps, doing research) and politics (winning over key people, sequencing conversations, handling objections). Use after /clarify or when you need to turn a goal into concrete actions that make your case stronger AND navigate the people involved.
---

# Battle Plan

Transforms a clarified goal into a comprehensive action plan that strengthens your case AND navigates the people who need to approve it.

## Core Principle

**Substance and politics are intertwined.** A brilliant proposal fails without political navigation. Political skill fails without a defensible proposal. This skill addresses both.

## Before Starting

### First Question: Document Depth

```
Do you want fast or thorough document review?
A) Fast - use doc-summary/ (smaller files, quicker responses)
B) Thorough - use docs/ (full documents, more context)
C) Skip documents - just work from what I tell you
```

### Then:

1. **Read project docs** - Check chosen folder for clarify-*.md files and other context
2. **If no clarification exists**, ask: "I don't see a clarification document. Want to run /clarify first, or should I work with what you tell me now?"
3. **Summarize understanding** before generating plan: "Based on what I've read, here's what I understand..." and confirm with user

## The Battle Plan Structure

### 1. ASSESS - Where do you stand?

#### Substance Assessment
- What's the core proposal?
- What evidence exists today?
- What are the gaps and weaknesses?
- What questions can't be answered yet?
- What would a skeptic attack?

#### Political Assessment
- Who decides?
- Who influences the decision?
- Where does each person stand today?
- What are the key relationships and dynamics?

#### Gap Analysis
- Substance gaps: What's missing from the proposal itself?
- Evidence gaps: What proof points are needed?
- Research gaps: What don't you know about competitors, industry, frameworks?
- Political gaps: Which relationships need work?

### 2. STRENGTHEN - Build a defensible case

#### Research Tasks
Not just "gather info" but specific research with clear purpose:
- **Competitive intel**: What are competitors doing? How behind/ahead are we?
- **Industry precedents**: Who's done this well? What can we learn?
- **Frameworks and experts**: What do credible external sources say?
- **Internal evidence**: What data exists internally that supports the case?
- **Failure analysis**: What's failed before and why? How is this different?

#### Proposal Improvements
Based on gaps and weaknesses identified:
- Success metrics that are specific and measurable
- ROI framework or value articulation
- Risk mitigation that addresses real concerns
- Implementation clarity - how this actually works
- Answers to the questions opponents will ask

#### Documents to Create (Substance)
- Strengthened proposal/plan
- Evidence summary or proof points document
- Research findings synthesis
- FAQ or objection responses

### 3. BUILD SUPPORT - Navigate the people

#### Political Groundwork
For each key person:
- Current stance assessment
- What they need to see/hear/believe
- Who influences them
- Best approach (1:1, group, formal, informal)
- Specific messaging for their concerns
- What would make them a champion vs. just not blocking

#### Relationship Moves
- Pre-conversations before formal asks
- Coalition building with supporters
- Neutralizing blockers
- Finding unexpected allies

#### Documents to Create (Politics)
- Tailored summaries for different audiences
- Talking points for champions to use
- Materials that let supporters advocate for you

### 4. EXECUTE - Sequenced actions

#### Sequence Logic
The order matters. Consider:
- What research must complete before certain conversations?
- Which people need to be won over before approaching others?
- What documents need to exist before key meetings?
- Where are the dependencies?

#### Interleaved Actions
Don't separate "do all research, then do all politics." Interleave:
- Research finding → informs → conversation with skeptic
- Conversation with ally → reveals → new research need
- Proposal revision → enables → executive meeting

### 5. CHECKPOINTS - How you know it's working

- Evidence that substance is getting stronger
- Evidence that political support is building
- Warning signs that require course correction
- Decision points where you might pivot

## Output Format

Save to `docs/battle-plan-[topic]-[YYYY-MM-DD].md`

```markdown
# Battle Plan: [Goal]
Generated: [date]
Based on: [link to clarify doc if exists]

---

## Situation Summary

[3-4 paragraph summary covering:
- The goal and why it matters
- Current strength of the case (substance)
- Current political landscape
- What needs to happen]

---

## Assessment

### Substance: Current State
- **Core proposal**: [what you're actually proposing]
- **Evidence you have**: [what supports the case today]
- **Key weaknesses**: [what opponents will attack]
- **Unanswered questions**: [what you can't defend yet]

### Politics: Current State
- **Decision maker(s)**: [who approves]
- **Current alignment**: [who's supportive, skeptical, blocking]
- **Key dynamics**: [relationships, tensions, opportunities]

### Gap Analysis
| Gap Type | What's Missing | Why It Matters |
|----------|---------------|----------------|
| Evidence | [specific gap] | [consequence if not filled] |
| Research | [specific gap] | [consequence if not filled] |
| Proposal | [specific gap] | [consequence if not filled] |
| Political | [specific gap] | [consequence if not filled] |

---

## The Plan

> **Note:** This document serves as your action checklist. Leave it in project docs to help the LLM track progress and assist with execution.

### Phase 1: Strengthen the Case

**Research to Conduct:**
- [ ] [Specific research task]
  - Purpose: [why this matters]
  - Source: [where to look]
  - Output: [what you'll have when done]

- [ ] [Specific research task]
  - Purpose: [why this matters]
  - Source: [where to look]
  - Output: [what you'll have when done]

**Proposal Improvements:**
- [ ] [Specific improvement to make]
  - Addresses: [which weakness or gap]
  - Deliverable: [what this produces]

- [ ] [Specific improvement to make]
  - Addresses: [which weakness or gap]
  - Deliverable: [what this produces]

**Documents to Create:**
- [ ] [Document name/type]
  - Purpose: [what it accomplishes]
  - Audience: [who it's for]
  - Key content: [what it must include]

### Phase 2: Build Political Support

**Pre-Conversations:**
Before any formal ask, prepare the ground:

#### [Person 1] - [Current stance]
- [ ] **Approach**: [how to engage - 1:1, setting, framing]
- [ ] **Key message**: [what they need to hear]
- [ ] **Evidence to share**: [which proof points matter to them]
- [ ] **Ask**: [what you want from this conversation]
- [ ] **Success looks like**: [how you'll know it worked]

#### [Person 2] - [Current stance]
[Same structure]

**Coalition Building:**
- [ ] [Action to build support network]
- [ ] [Action to arm champions with materials]

### Phase 3: Execute

**Sequenced Actions:**

| Order | Action | Depends On | Enables |
|-------|--------|------------|---------|
| 1 | [Action] | - | [what this unlocks] |
| 2 | [Action] | Step 1 | [what this unlocks] |
| 3 | [Action] | Steps 1-2 | [what this unlocks] |
| ... | ... | ... | ... |

**Detailed Sequence:**

1. [ ] **[Action]**
   - Why now: [reasoning]
   - Deliverable: [what this produces]
   - Next step it enables: [what follows]

2. [ ] **[Action]**
   - Depends on: [previous step]
   - Deliverable: [what this produces]
   - Next step it enables: [what follows]

[Continue as needed]

### Objections & Responses

| Likely Objection | From Whom | Underlying Concern | Evidence/Response |
|------------------|-----------|-------------------|-------------------|
| [What they'll say] | [Name] | [Real issue] | [How to address - include specific evidence] |
| [What they'll say] | [Name] | [Real issue] | [How to address - include specific evidence] |

### Checkpoints

**Substance Checkpoints:**
- [ ] [Evidence that case is getting stronger]
- [ ] [Research completed that fills key gap]
- [ ] [Proposal improvement that addresses weakness]

**Political Checkpoints:**
- [ ] [Signal that key person is moving toward support]
- [ ] [Coalition milestone]
- [ ] [Blocker neutralized or converted]

**Warning Signs:**
- [Sign that something is going wrong]
- [Sign that approach needs to change]

### Risks & Contingencies

| Risk | Likelihood | Impact | Mitigation |
|------|------------|--------|------------|
| [What could go wrong] | H/M/L | H/M/L | [What to do] |

---

## Immediate Next Actions

Do these first:

1. [ ] [Specific action with clear output] - [why first]
2. [ ] [Specific action with clear output] - [why second]
3. [ ] [Specific action with clear output] - [why third]
```

## After Completion

Ask: "Want me to help execute any of these items? I can help with:
- Research (competitive intel, industry precedents, frameworks)
- Drafting documents (proposals, summaries, talking points)
- Preparing for specific conversations
- Strengthening specific parts of the case"
