# BlackBelt Meeting Summary - How It Works

## The One-Sentence Version

It's like having a diligent assistant who watches your coaching calls, takes structured notes, and hands you a Basecamp update ready to paste.

## Why This Exists

Every BlackBelt coaching call needs a summary. The clients need visibility. The ops team needs to track follow-ups. You need a record of what was discussed.

Writing these manually after every call is grunt work. You've got the transcript - the information is all there. You just need it reorganized into the standard format.

This skill does the reorganization. It reads the transcript, pulls out the key pieces, structures them into the template you've been using for years, and hands you something ready to paste into Basecamp.

## The Mental Model: The Post-Call Debrief

Think of it like having a coach shadowing you on every call. As soon as the call ends, they hand you a one-page debrief:

- Here's what we covered
- Here's what the client said (direct quotes)
- Here's what they need to do next
- Here's what the team needs to follow up on
- Here's how they seemed - energy, confidence, any concerns

That's exactly what this skill produces. A structured debrief from the raw transcript.

## How You Actually Use It

1. Record your coaching call (Zoom, MacWhisper, whatever)
2. Drop the transcript file into your Transcripts folder
3. Say "process meeting transcripts"

The skill scans for new transcripts, shows you what it found, and asks you to confirm the client name and session type. Then it processes, cleans up the AI patterns, saves to your Zettelkasten, and gives you the Basecamp-ready text in a code block.

Copy. Paste. Done.

## The Dry-Run Pattern

Notice the preview step? That's deliberate. The skill doesn't just barrel ahead and process everything. It shows you what it found first:

| File | Detected Client | Type |
|------|-----------------|------|
| GamePlan-Bren.md | Bren | Game Plan |
| Velocity-Jan5.md | ? | Velocity |

You confirm or correct before anything gets processed. This prevents wrong client names from ending up in Basecamp, and lets you skip transcripts that aren't ready yet.

## What Goes In The Summary

The template has six sections, each serving a purpose:

**Summary** - The narrative. What happened on this call? Include direct quotes - they make summaries feel real and give clients their own words back.

**Key Focus Areas** - Bullet list of topics. Quick scan for "what did we talk about?"

**Trainings Highlighted** - What resources were pointed to. No links (they break) - just labels.

**Requests for BlackBelt Team** - Explicit asks for ops. This is visibility for the team - "send recording," "add training to portal," etc.

**Momentum & Culture** - The vibe check. How are they feeling? Any warning signs? This section catches things the ops team should watch.

**Next Steps** - Concrete actions. Who does what by when.

## What It's NOT

This isn't a transcription service. You still need to record and transcribe the call.

This isn't a publishing tool. It generates the summary, but you paste it into Basecamp yourself.

This isn't a replacement for actually paying attention on calls. The skill summarizes what's there - it can't add insights you didn't capture.

## The Coaching Business Analogy

Think of this like the "notes section" of a client file. After every session, a good coach records what happened. The patterns. The progress. The concerns.

This skill systematizes that. Instead of hoping you'll write notes, it produces them automatically from the transcript. Same discipline, zero willpower required.

The 250-400 word limit keeps it tight. Enough detail to be useful, not so much that nobody reads it.
