---
name: blog-article-generator
description: ブログ記事を体系的に生成します。テーマ分析、アウトライン作成、本文執筆、参考文献追加を含む完全なブログ記事作成プロセスを実行します。ブログ記事、技術記事、コラムを書く場合に使用します。
allowed-tools: WebSearch, Read, Write
---

# Blog Article Generator

このSkillは、高品質なブログ記事を体系的に生成するための包括的なワークフローを提供します。

## Instructions

### ステップ1: テーマ分析とリサーチ

1. ユーザーから記事テーマを受け取る
2. WebSearchを使用して最新のトレンドと関連情報を調査
3. 競合記事を分析（存在する場合）
4. 読者ペルソナを設定（職種、知識レベル、関心事）

### ステップ2: 詳細アウトライン作成

以下の構成で記事の設計図を作成：

```markdown
1. イントロダクション（300-500字）
   - 問題提起
   - 記事の価値提案

2. メインセクション1（800-1200字）
   - 主要トピック
   - サブポイント
   - 具体例

3. メインセクション2-N（各800-1200字）
   - （繰り返し）

4. まとめ（300-500字）
   - 主要ポイントの再確認
   - 行動喚起（CTA）
```

### ステップ3: 本文執筆

1. アウトラインに従って本文を執筆
2. わかりやすい言葉で専門的な内容を説明
3. コード例や図表を適切に配置
4. 読みやすい段落構成（1段落3-5文）

### ステップ4: 信頼性の強化

1. 参考文献を整理（最低5件）
2. データソースを明示
3. 用語集を追加（必要に応じて）
4. 著者プロフィールを記載

### ステップ5: 最終確認

- [ ] 誤字脱字チェック
- [ ] 論理の一貫性確認
- [ ] 見出し構造の適切性
- [ ] コード例の動作確認

## Output Format

完成した記事はMarkdown形式で出力し、以下のファイル名規則に従います：

```
[テーマ]_[YYYY-MM-DD].md
```

例: `AI_MultiAgent_Systems_2025-01-26.md`

## Examples

### 使用例1: 技術記事

```
User: "AIマルチエージェントシステムについてブログ記事を書いてください"

Skill実行:
1. WebSearchで最新トレンド調査
2. 詳細アウトライン作成（6章構成）
3. 本文執筆（約5,000字）
4. 参考文献9件追加
5. 用語集作成
```

### 使用例2: ハウツー記事

```
User: "Vercel Serverless Functionsの実践ガイドを書いてください"

Skill実行:
1. テーマ分析（初心者向けガイド）
2. ステップバイステップのアウトライン
3. コード例を多用した本文
4. トラブルシューティングセクション追加
5. デプロイチェックリスト作成
```

## Best Practices

1. **読者中心**: 常に読者の知識レベルに合わせた表現
2. **具体性**: 抽象論ではなく、実例と具体例を豊富に
3. **視覚化**: 図表、コードブロック、箇条書きを効果的に使用
4. **信頼性**: データと事実に基づいた論述
5. **SEO意識**: 自然にキーワードを配置（過剰な詰め込みは避ける）

## Tips

- **専門用語**: 初出時には必ず説明を付ける
- **コード例**: 実行可能で、コメント付き
- **セクション長**: 1セクションは800-1500字が読みやすい
- **CTA**: 記事の最後に明確な次のアクションを提示

## Version History

- v1.0.0 (2025-01-26): 初期リリース
