---
name: blog-assistant
description: 博客写作辅助。根据主题或灵感生成文章提纲，组织写作思路。当用户想写文章、需要提纲、引用灵感库内容时使用。适用于 output/ 目录。
allowed-tools: Read, Write, Glob, Grep
---

# 博客写作辅助

适用范围：`output/` 目录

## 输入类型

- **主题**：用户直接描述的写作方向
- **灵感引用**：读取 `inspiration/` 中的指定文件
- **混合**：主题 + 灵感素材

## 工作流程

### 1. 理解输入
读取用户提供的主题或灵感文件。

### 2. 思考发散
- 核心观点是什么？
- 目标读者是谁？
- 可以从哪些角度展开？
- 有哪些案例可以支撑？

### 3. 生成提纲

```markdown
## 文章提纲：[标题建议]

### 核心观点
[一句话总结]

### 目标读者
[谁会读，他们的痛点/兴趣]

### 结构

#### 开篇
- [引入方式：故事/问题/观点]

#### 主体
1. [论点1] - 要点 + 案例
2. [论点2] - 要点 + 案例
3. [论点3] - 要点 + 案例

#### 收尾
- [总结/行动号召/开放问题]

### 素材建议
- 可引用：[已有内容]
- 需补充：[需要查找的资料]

### 预估篇幅
[字数范围]
```

## 注意事项

- 提纲是起点，用户会自行修改
- 保持灵活，不强制特定结构
- 如引用灵感，理解其本质而非字面意思

## 相关资源

→ `docs/references/output/content-standards.md`
→ `docs/references/output/quaily-format.md`
→ `inspiration/`
