# Bob Moesta's Core Frameworks

## Jobs to Be Done (JTBD)

The foundational theory: **People don't buy products—they hire them to make progress in their lives.**

### Key Principles

- A "job" is the progress a person is trying to make in a particular circumstance
- Jobs are not the same as needs, features, or benefits
- Jobs have functional, emotional, and social dimensions
- The same person might hire different products for different jobs at different times
- Understanding the job reveals the true competitive set

### Job Statement Format

"When I [situation/context], I want to [motivation], so I can [desired outcome]."

Example: "When I'm commuting alone in my car in the morning, I want something that keeps me engaged, so I can feel like my time isn't wasted."

### Competition Through the Job Lens

Traditional view: Milkshake competes with smoothies, juice, breakfast drinks
Job view: Milkshake competes with bagels, bananas, donuts, boredom, coffee—anything hired for the "make my commute interesting" job

---

## Forces of Progress

Four forces determine whether someone will switch from current behavior to a new solution:

```
FORCES PUSHING TOWARD CHANGE          FORCES HOLDING BACK
┌─────────────────────────────┐       ┌─────────────────────────────┐
│ 1. PUSH OF THE SITUATION    │       │ 3. ANXIETY OF NEW SOLUTION  │
│    The struggling moment    │       │    Fear of the unknown      │
│    "This isn't working"     │       │    "What if it doesn't work"│
├─────────────────────────────┤       ├─────────────────────────────┤
│ 2. PULL OF NEW SOLUTION     │       │ 4. HABIT OF THE PRESENT     │
│    Magnetism of the new     │       │    Comfort with current     │
│    "I can imagine better"   │       │    "It's good enough"       │
└─────────────────────────────┘       └─────────────────────────────┘
```

### Critical Insight

Push + Pull must be greater than Anxiety + Habit for change to occur.

- **No push = no demand** - Without a struggling moment, people won't look for alternatives
- **Anxiety stops progress** - Even with push and pull, anxiety can freeze decisions
- **Habit is powerful** - "Good enough" keeps people stuck in suboptimal solutions

### Reducing Friction

To help customers make progress:
- **Reduce anxiety**: Trials, guarantees, testimonials, simplicity
- **Reduce habit**: Make switching easy, remove setup friction
- **Amplify push**: Help them articulate their struggle
- **Amplify pull**: Paint a picture of their life after progress

---

## Five Skills of Innovators

From "Learning to Build" - the core capabilities that separate successful innovators:

### 1. Empathetic Perspective

The ability to see through others' eyes without judgment.

- **720-degree view**: See from all angles—customer, supplier, partner, competitor
- **See through time and space**: Anticipate how events will unfold
- **Not sympathy**: You're not relating to feelings, you're inhabiting perspectives
- **Demand-side AND supply-side**: Understand both customer world and operations

Key technique: "Become the molecule" - trace the complete journey of your product from raw material through customer use.

### 2. Uncovering Demand

Finding where genuine demand exists before building solutions.

- **Struggling moments**: The seed of all innovation
- **Not what people say, but what they do**: Behavior reveals truth
- **Context is everything**: Same person, different situations = different jobs
- **Pattern recognition**: Group struggles into finite categories (usually 4-5 core jobs)

Key insight: There are NOT infinite reasons people buy—there are patterns if you look for causation.

### 3. Causal Structures

Understanding the "why" behind behavior through mechanisms, not correlation.

- **Correlation ≠ Causation**: Ice cream sales and drowning correlate, but don't cause each other
- **Dominoes, not snapshots**: See the chain of events that leads to decisions
- **Functions, not features**: Focus on what it needs to DO, not what it IS
- **Variation of function**: Problems arise when function varies outside acceptable range

Key question: "What caused them to say 'today is the day'?"

### 4. Prototyping to Learn

Using prototypes to generate insight, not validate assumptions.

- **Fail fast, learn faster**: Every prototype teaches something
- **Low-fidelity first**: Start rough, add fidelity as understanding increases
- **Test the job, not the product**: Does this solve their actual struggling moment?
- **Iterate on understanding**: Each round should reveal new questions

Key principle: "You're never more than one prototype away from the answer—but you need many prototypes to get there."

### 5. Making Tradeoffs

Accepting that every choice eliminates alternatives.

- **No "best"—only tradeoffs**: Every design decision gives something up
- **Constraint enables creativity**: Limitations force innovation
- **Make tradeoffs explicit**: Don't pretend you can have everything
- **Know what NOT to do**: Deciding what to exclude is as important as what to include

Key insight: If you try to be good at everything, you'll be great at nothing.

---

## Supply-Side vs. Demand-Side Thinking

### Supply-Side (Traditional)

- Focus: Product features and benefits
- Customer definition: Demographics, personas, averages
- Question: "What's the demand for our product?"
- Metric: Market share, revenue, units sold
- Method: Push the product to customers
- Competition: Other products in the category

### Demand-Side (JTBD)

- Focus: Customer's struggling moment and desired progress
- Customer definition: Context, circumstances, struggling moments
- Question: "What progress are people trying to make?"
- Metric: How well we help customers make progress
- Method: Create pull by understanding and solving the job
- Competition: Anything else hired to make the same progress

### Key Insight

"Demographics don't cause people to buy. Your age and zip code don't cause you to buy the New York Times. A struggling moment in a specific context causes you to buy."

---

## Timeline and Causation

### The Buying Timeline

Every purchase has a timeline that started long before the transaction:

1. **First Thought** - When did the idea first enter their mind?
2. **Passive Looking** - When did they start noticing alternatives?
3. **Active Looking** - When did they start deliberately searching?
4. **Deciding** - What tipped them to commit?
5. **Purchasing** - The actual transaction
6. **Consuming** - First use experience
7. **Satisfaction** - Does it deliver the progress they hired it for?

### Building the Timeline in Interviews

- "When did you first think about this?"
- "What was going on in your life at that time?"
- "What happened next? And then?"
- "How long between X and Y?"
- "What almost stopped you?"
- "Why today and not yesterday?"

### The "Documentary" Approach

Interview as if filming a documentary. You want:
- Specific dates and times
- Who was there
- What was said
- What they were feeling
- What else was happening in their life

The goal is to reconstruct the chain of events that led to the decision, revealing the true causal mechanisms.
