# Bob Moesta's Interview Method

## The "Empty Vessel" Approach

Enter every interview as if you know nothing. Leave your assumptions, hypotheses, and agenda at the door.

**Mindset:**
- You are not there to validate your ideas
- You are there to discover their story
- You are not the expert—they are the expert on their own life
- Curiosity, not judgment

---

## Five Techniques for Extracting Perspective

### 1. Context

"When the answer feels irrational, it's because you don't know the whole story."

- Dig for the full picture
- What else was happening in their life?
- What were the circumstances?
- The irrational becomes rational with context

**Example prompts:**
- "What was going on at that time?"
- "What else was happening in your life?"
- "Help me understand the situation..."
- "Walk me through that day..."

### 2. Contrast

"There's no fast, only faster than... There's no easy, only easier than..."

People can't articulate abstracts but can identify boundaries through comparison.

**Bracketing technique:**
- "Why X and not Y?"
- "What was different about this time?"
- "You said it was expensive—compared to what?"
- "What made you choose this over the alternatives?"

**Key insight:** It's easier for people to tell you what's hard than what's easy. The boundaries of "hard" reveal the definition of "easy."

### 3. Unpacking

Everything is relative. Words mean different things to different people.

- "Fast" to one person might mean 5 minutes, to another 5 hours
- "Healthy" is healthier than... what?
- "Quality" means... specifically what?

**Example prompts:**
- "When you say 'easy,' what does that look like?"
- "Help me understand what you mean by 'better'..."
- "What's your reference point for 'affordable'?"
- "Unpack that for me..."

### 4. Energy

It's not just what people say—it's how they say it.

**Listen for:**
- Word emphasis (you can hear the "caps lock")
- Intonation going up or down
- Pauses and sighs
- Speed changes (faster = excited, slower = processing)
- Emotional words vs. neutral words

**When you detect energy:**
- Stop immediately
- "Wait, tell me more about that"
- "Why is that important?"
- "I heard something in your voice—what's behind that?"

### 5. Analogies

When people hit a wall and can't articulate something, give them another frame.

**Example prompts:**
- "How is getting a new boss like starting over?"
- "Is it more like X or Y?"
- "If you had to compare this to something else in your life..."
- "What's the closest thing to this experience you've had before?"

---

## Building the Timeline

The goal is to reconstruct the complete story of how they arrived at a decision.

### Key Moments to Capture

1. **First thought** - "When did you first think about this?"
2. **What triggered it** - "What was going on that made you think about it?"
3. **Passive looking** - "When did you start noticing alternatives?"
4. **Active searching** - "When did you start actually looking?"
5. **The moment of decision** - "What made you decide?"
6. **Almost stopped** - "What almost held you back?"
7. **First use** - "What was the first experience like?"

### Timeline Questions

- "When did you buy it?"
- "What day of the week was it?"
- "Who was with you?"
- "What else did you buy that day?"
- "What were you doing before that?"
- "How long had you been thinking about it?"
- "What almost stopped you?"
- "Why that day and not the day before?"

### The Documentary Method

Interview as if filming a documentary. You want:
- Specific dates and times (Saturday vs. Sunday matters)
- Physical details (what store, what aisle, what they were wearing)
- Who was there and what they said
- What else was happening in their life
- Emotional state at each point

---

## Finding the Struggling Moment

The struggling moment is the seed of all innovation. Without struggle, there's no demand.

### What You're Looking For

- The moment when they thought "This isn't working"
- The trigger that made them consider alternatives
- The gap between where they are and where they want to be
- The context that created the struggle

### Questions to Uncover Struggle

- "What wasn't working?"
- "What were you trying to do that you couldn't?"
- "What was the moment you realized something had to change?"
- "What were you putting up with before?"
- "What workaround were you using?"
- "What finally pushed you over the edge?"

### Workarounds and Hacks

Pay special attention to compensating behaviors—the things people do to work around a problem:

- "What were you doing before?"
- "How were you solving this problem?"
- "What hack did you create?"

Workarounds reveal unmet jobs. If people are going to elaborate lengths to solve a problem, that's a signal of strong demand.

---

## Forces of Progress Questions

### Push Questions (Why leave current solution?)

- "What wasn't working about the old way?"
- "What frustrated you?"
- "What were you putting up with?"
- "What made you finally decide to change?"

### Pull Questions (Why this new solution?)

- "What attracted you to this?"
- "What did you imagine your life would be like after?"
- "What was the promise?"
- "What got you excited?"

### Anxiety Questions (What almost stopped you?)

- "What concerns did you have?"
- "What made you nervous?"
- "What questions did you have?"
- "What almost made you not do it?"

### Habit Questions (What kept you with the old way?)

- "What was working about the old way?"
- "What will you miss?"
- "What was comfortable about it?"
- "Why did you wait so long?"

---

## Common Mistakes to Avoid

1. **Asking "why" directly** - People often don't know or will rationalize. Instead, ask "what happened" and "what did you do next."

2. **Accepting the first answer** - The first answer is rarely the real answer. Dig deeper.

3. **Leading the witness** - Don't suggest answers or validate their statements. Stay neutral and curious.

4. **Talking too much** - Your job is to listen. If you're talking more than 20% of the time, you're doing it wrong.

5. **Following a script** - "The best question will always come from the last answer." Let the conversation flow naturally.

6. **Focusing on the product** - Focus on their life, their struggle, their progress. The product is just a small part of the story.

7. **Jumping to solutions** - You're there to understand, not to solve (yet).

---

## Interview Best Practices

- Interview recent purchasers (within 90 days) while memory is fresh
- Interview people who switched TO your product AND people who switched AWAY
- Interview people who almost bought but didn't
- Minimum 10-12 interviews to see patterns, often need 30+
- Record everything (with permission)
- Look for the 4-5 patterns that explain most purchases
- Group by job/struggling moment, not demographics

---

## The Famous Mattress Interview

See [mattress-interview.md](mattress-interview.md) for a complete transcript of Bob and Chris Spiek interviewing a Switch workshop attendee about his Costco mattress purchase.

### Key Lessons from This Interview

1. **"Impulse" purchases aren't impulsive** - He'd been thinking about it for a year
2. **Details matter** - Asking about milk and baby wipes reconstructs the moment
3. **Anxiety reduction beats features** - Costco's return policy mattered more than the mattress specs
4. **He never laid on the mattress** - Defies industry assumptions about how people buy
5. **Wife's buy-in reduced anxiety** - "You can't blame me completely"
6. **He paid MORE for less anxiety** - Chose Costco over cheaper Groupon option
7. **Research happened at 2-3am** - When he couldn't sleep (context!)

### "Game On/Game Off" Technique

Bob uses an iPhone on the table:
- **Screen up** = "Game on" - actively interviewing
- **Screen down** = "Game off" - pause for instruction/commentary

Only used in workshop settings, never with actual consumers.

---

## Complementary: Chris Voss Negotiation Techniques

From "Never Split the Difference" - these FBI techniques enhance JTBD interviews:

### Calibrated Questions
Open-ended questions starting with "How" or "What" that:
- Give the subject the illusion of control
- Avoid triggering defensive reactions
- Force them to think deeply about their answers

Examples:
- "How am I supposed to do that?"
- "What's the biggest challenge you face?"
- "How did that make you feel?"

### Mirroring
Repeat the last 1-3 critical words of what they just said. Creates:
- Connection and rapport
- Encouragement to elaborate
- Time to think

### Labeling
Name the emotion you observe:
- "It seems like you were frustrated..."
- "It sounds like that was overwhelming..."
- "It looks like the timing was important..."

This validates their experience and encourages deeper sharing.

### Tactical Empathy
Understanding the feelings AND the mindset behind them, then verbalizing that understanding. Different from sympathy—you're not agreeing, you're demonstrating you understand.

### The Late-Night FM DJ Voice
Calm, slow, downward-inflecting tone that:
- Creates trust and openness
- Signals you're not a threat
- Slows down the conversation for deeper thinking
