# The Jobs-to-be-Done Mattress Interview Transcript
## (As seen in Competing Against Luck)

**Source:** https://jobstobedone.org/radio/the-mattress-interview-part-one/
**Hosts:** Bob Moesta & Chris Spiek (Founders of The Rewired Group)
**Guest Interviewer:** Jason Fried (37signals/Basecamp)
**Duration:** ~48 minutes

---

## Episode Transcript

**Chris:** Welcome to the latest edition of Jobs-to-be-Done Radio. As always, I'm here with my partner Bob Moesta.

**Bob:** Hi, Chris.

**Chris:** How you doing, Bob?

**Bob:** Good.

**Chris:** Good. We've been gone for a while. Not a planned thing, but had the holidays go by, and schedules just got crazy. This is the first time we've had a chance to be together and record a radio episode. This is exciting.

**Bob:** Yeah, I think we've been to Europe, we've been to California a couple times, we've been all over. With the holidays, I hate to have an excuse, but it was a good holiday for both of us. I think we're ready to hit the road and make Jobs even better this year.

**Chris:** Yeah, so the good thing is between both of us we've been doing a lot of interviews, a lot analysis, so it's been good exposure to different markets and that sort of thing. We're hoping to bring that back to all of you who are listening in the form of some good content. Just to cover a few administrative things, I think the biggest news is we have a Switch workshop coming up on January 29th at the W Hotel in San Francisco. Phil from Precision Nutrition, the CEO over at Precision Nutrition, has been nice enough to sponsor this event for us and help us organize it and get it together. There are still seats available, so you can go to jobstobedone.org to find out how to register. The last few sold out in five or six days, and this one seems to be tracking along that same pace. If you want a seat, try to snag one.

**Bob:** Yeah. The important thing for us is to keep it down to 24 people or so, and make it intimate and really make sure that everybody gets it. It's not trying to be a big event. The other thing is to say that we're going to Asymconf on the next day to see Horace, which I think we're both pretty excited about.

**Chris:** Yeah, absolutely. Big fans of his podcast and everything that he's doing over there, and it'll be good to see him face to face and see what he has going on.

**Bob:** Yeah, yeah. We've had lots of requests for, 'can you share interviews with us? Help us listen to what an interview sounds like.' That's what we're going to do today. We're not going to talk much from this side of the mic, but we recorded some information at the last Switch conference.

**Chris:** Yeah, we actually reached out to one of the attendees from the last Switch workshop. We had done a live interview with him about his recent purchase of a new mattress. Neither Bob nor I have any experience selling furniture or doing product development in mattresses. We plucked him out of the audience, had him come up front, and literally did an impromptu interview for around 45 minutes around the progress that he was trying to make through the purchase of this new mattress. We want to play that for you today. We use a method during the interview called 'game on, game off,' in which we'll actually have an iPhone sitting on the table. If it's screen up, that means game on, so we're in the interview, we're conducting the interview, we're asking questions. If you flip it over so it's screen down, we call that game off. We're talking about interview techniques, we're talking about the Jobs-to-be-Done method. It's something that you'll hear us do through the course of the audio. Just know that we're coming in and out of the interview. It's only an instructional tool. We would never do it with an actual consumer who we were interviewing, but it allows us to interject our commentary as we're interviewing.

**Bob:** Right. The other thing is that I think we're going to attach both the capture grid, which is the timeline, and the forces diagram. Those of you who are listening not in the car can actually listen along and fill in the timeline and draw out the forces and see exactly what pushed and what pulled and what was his anxiety, what was his allegiance to the past, etc. You can use the capture methods that we use real time to go through that. Love to hear feedback from you all on what you thought of the interview, what was interesting, what was different. Love to hear some information about that. It's a typical interview, but again, it's how we usually go in cold and we just start probing.

**Chris:** Yeah, so I guess a couple things I'll say is one, we're extremely grateful to this attendee for allowing us to do this. Because I think at the time he was opening himself up to 23 other people and us, and we approached him afterwards and said, 'This is really valuable.' We know that everyone, I'd say most of the people who've been listening to this show, that's the number one request that we've gotten. You talk about your methods and you talk about how you do analysis, but we've never actually heard how you gather these insights. It's not a black box. We want to share it as much as we can, and Bob and I are always on the look out for interviews that we can publish and share. They're just really, really hard to come by because of confidentiality. Once again, we're very thankful to be able to put this out there and start to get reactions from all of you that listen.

**Bob:** Yeah. It's also sparked us to add some functionality to jobstobedone.org around the notion of being able to create a practice space for people, for people who want to be interviewed and people who can be interviewed, so they can practice their interviewing techniques. We're in the early stages of exploring how to do that, so people can practice and get better at it.

**Chris:** Absolutely. We'll leave you with that. We're going to follow this episode of Jobs-to-be-Done Radio up with another one soon, where we can actually get into some detail about this mattress interview, and talk about the important points and when you want to really dig in and that sort of thing. We'll follow that up during the next episode. For now I think we're going to leave you with this audio.

**Bob:** Yeah, enjoy the interview.

**Chris:** Talk to you soon. Thanks everyone.

---

## [Workshop Recording Starts - 06:23]

**Chris:** The best way to think about this is we're literally filming a documentary. We want all the details around when you first started thinking about buying the mattress, when you made the decision, and then using it and experiencing it for the first time. We'll ask really broad questions, and there'll be some situations where we'll slow down time and ask who were you with, what time of day it was, and get really really deep into details. It's a goofy method, but you'll have to bear with us and you'll see it all come together.

**Bob:** If the people in back can't hear for any reason, you guys can move up or just tell us that you can't hear.

**Chris:** Tell us, just yell. Let's just start with when did you buy the mattress pad?

**Interviewee:** About 45 days ago.

**Chris:** When was that? Mid-September?

**Interviewee:** Yeah, mid-September.

**Chris:** OK, did you order online, or did you order it . . .

**Interviewee:** I bought it at Costco.

**Chris:** At Costco, OK. It was mid-September. Game off for a second. The thing is, think about this as almost investigation. We're building a timeline, and we're going to piece it together. He's going to start saying things, and all of a sudden it's going to be like, 'Wait a second, it doesn't jive. I'm confused.' Part of this it is being able to make sure that we get the timeline right.

**Bob:** Let's try to stay on for as long as we . . . let's [inaudible 07:35], sorry.

**Chris:** OK, good. Go.

**Interviewee:** Can I have my attorney here?

**Chris:** No.

**Bob:** Yeah.

**Chris:** It feels like that, but what you'll see is at the end the customers that you interview love the fact that you care about hearing their story. You bought it at Costco, was it weekend, weekday?

**Interviewee:** It was a weekend.

**Chris:** Weekend. Saturday or Sunday?

**Interviewee:** I believe it was a Saturday.

**Bob:** Did you buy anything else with it, or was it just . . .

**Interviewee:** You can never go in Costco and buy just one thing, so yes, I did buy other things.

**Chris:** Did you go with 'OK, I'm going to buy this thing today, and oh, I need this and this and this'?

**Interviewee:** No.

**Chris:** You didn't go with the intent to buy it?

**Interviewee:** I did not.

**Chris:** Wow, OK.

**Bob:** What else did you leave with? Do you remember what else you bought in that trip?

**Interviewee:** Well, I have kids, so baby wipes. A lot of milk.

**Chris:** How much milk?

**Interviewee:** You get the thing with the three almond milk thing, and then a couple gallons of something else.

**Chris:** What was the something else?

**Interviewee:** Just the organic, my son has the 2% and my daughter has the non-fat.

**Chris:** Got it, OK. Game off for a second, [inaudible 08:47].

**Interviewee:** Yeah.

**Chris:** OK. Two things. The whole thing is getting him back to the moment. We're asking ridiculous amounts of detail, like what did he buy. What you'll find is the brain actually has a lot of this stuff stored in it, and the fact is when we interview Jason on something, it was like Jason, 'I can't remember,' and then two seconds later, 'Yeah, I did this and this and this.' Part of it is setting it up. It's unpacking that moment and getting to the detail, so then all of a sudden he'll have the resolution. Say he can't remember, we typically dive into, 'so tell me what else was in the cart.' That's why we both asked that same question, setting the scene kind of thing.

**Bob:** This was one of the most interesting things for me when I learned how to do this. Why in the hell do you care about the milk that he bought? We're talking about a mattress. But you can't look at things in isolation, it's not just a mattress. He went to go shopping, he didn't even think about the mattress in the first place. Where was his head, what he thinking about, what else was in his heart? In some cases you might go to the store with a cart, or not even with a cart, you might just go with your two hands. Then you fill up your two hands and you can't carry anything else. He had a cart, so does that mean he's going to fill the cart up because he had more room? You just keep thinking about stuff like that.

**Interviewee:** I had to get one of those . . .

**Chris:** Game on?

**Bob:** Game on.

**Interviewee:** . . . the flat bed. I had to go back outside to get the flat bed.

**Bob:** Did you start, so you didn't start with anything.

**Chris:** Did you have a push cart that you started with?

**Interviewee:** Yeah, started with a push cart to get the weekly, the monthly supplies. Paper towels, the milk. The baby wipes.

**Chris:** Anybody with you, or by yourself?

**Interviewee:** We had the whole crew there. [inaudible 10:24] wife and two kids.

**Chris:** Oh my God, so this is like a cruise . . .

**Interviewee:** Family man. This is like 'Family Man' inside the Costco.

**Chris:** It's Saturday, or is it Sunday?

**Interviewee:** It's Saturday.

**Chris:** Remember early on he said 'I'm not sure if it was Saturday or Sunday' and boom, it's Saturday.

**Bob:** What are your kids' names?

**Interviewee:** Annette and Edmond.

**Bob:** How old are they?

**Interviewee:** Four and a half and two.

**Chris:** Oh my gosh. Wait a second, you're talking into Costco, get the cart out, walking through, they're running, they see that first part of the aisle thing. Do you have a list?

**Interviewee:** Small list, but they're not running because when you go in Costco they'll get run over.

**Chris:** Especially on Saturday.

**Interviewee:** You lock them in because you say, 'If you're not in the cart, you don't get the samples.' Because those are like drug dealers with kids at Costco.

**Chris:** This is a family experience. I'm sorry, game off for a second. This is the empathy part. You need to empathize with them. You need to be able to say, 'Wait a second, I've got two kids, I'm with my wife, I've got a list. Literally I'm trying to keep my kids close. I've got drug dealers pushing these samples for my kids, I'm trying to watch everybody.' In the midst of this, he buys a mattress. Right? You're like, OK. Game back on. Where did you come across the mattress? Early on or later?

**Interviewee:** Towards the end of the 45 minutes we were in Costco.

**Chris:** 45 minutes in Costco.

**Bob:** Was your cart full at that point?

**Interviewee:** Pretty full.

**Bob:** With what else?

**Interviewee:** The milk and the boxes and the paper towels and all that will fill up a cart pretty quick, so I think I went through everything. There was some produce and that was about it.

**Bob:** Was the list done? Did you guys check everything off?

**Interviewee:** Yeah, and like any Costco trip, there were some things we bought that weren't on that list too.

**Chris:** Give me an example of that.

**Bob:** Mattress. Sorry.

**Interviewee:** Yeah, the mattress was not on the list.

**Chris:** No, no, I understand that, but was there anything else there?

**Interviewee:** I think some salad and some meat for dinner.

**Chris:** OK, nothing else?

**Interviewee:** Surprisingly no. Maybe a box of . . . actually no, there was. There was that box that I insisted on getting because I took something from the drug dealer, which was the 48 packages of instant, in the back Eggo mini-pancakes, that now have maple syrup infused in them. Again to the liquid cigarette guy, this guy . . .

**Chris:** OK. You're getting to the end of this trip.

**Interviewee:** And it's getting stressful. It always gets stressful at the end of Costco, because it's like trying to merge into the Kennedy in rush hour traffic. They've got 1,000 products in the store, but they've got four lanes open. It's getting stressful, we're getting near the end. I actually go down an aisle unexpectedly, and the lightbulb goes off, and there's the mattress.

**Chris:** OK, so I've got to stop for a second.

**Bob:** Game off. No, no, you.

**Chris:** No, no, game off for a second. When in the world did you think you needed a new mattress?

**Interviewee:** That's something you guys haven't asked me about, which is the background.

**Chris:** I know. That's right. Game off on that. The thing is, you're trying to set the scene, and you want to get to the scene of the crime as fast as possible. Because as much of it is if you start at the beginning, 'give me the first thought,' they're going to give you all this back filled, logical stuff. It's like, 'Well, we thought about it . . .' The thing is, all of a sudden it doesn't fit. Part of it is you want to make sure you set that scene hard, because that's like the foundation of the story. First of all, who had the first thought? You? Your wife? Who thought . . .

**Interviewee:** About a new mattress?

**Chris:** Yeah, about a new mattress.

**Interviewee:** Definitely me first, because about four years prior, did a lot of research and bought an overpriced Sterns & Foster that was guaranteed to give me a great night's sleep, and you're going to have a mattress for at least ten years, so it's worth the bigger investment, and we got the cushy pillow top. I would say for about a year I kept waking up every morning when I was saying, 'This bed is awful, I wake up with a headache, a neckache and a backache. It's starting to sink, this was a waste of $2,000, I need to find something different.'

**Bob:** How long did you enjoy the mattress? Was it the first year right when you bought it?

**Interviewee:** Yeah.

**Bob:** Right when you got it . . .

**Interviewee:** Yeah, right when I got it, it was something that I enjoyed four about two years. Year three kind of 'eh,' year four, couldn't stand it. Had total buyer's remorse.

**Chris:** When did you start to say it was the mattress?

**Interviewee:** Because the backaches and the shoulder and neck aches were always waking up that next morning. I tried sleeping without pillows, I tried adjusting my position, all this stuff. At the same time slowly I started to see also, and as you guys can see I'm not a big, big guy, but I started to notice in the mattress the sinkage. It felt like I was constantly in this arch, and I woke up every morning thinking, 'I don't just need Red Bull, I need three Advil or something else.'

**Chris:** You made the comment 'when you're home,' so you travel a lot?

**Interviewee:** Last year I did.

**Chris:** OK, and did you not have these problems when you were on the road?

**Interviewee:** I did not. Last year was the first year of my business, and I was gone 37 weeks. As I told you at breakfast, I was held up in the Marriot Renaissance Center three days a week. I would assure you at least that that mattress I'm sure was not the one that I had at home, but I didn't have those problems.

**Bob:** What else did you do? Did you change anything about the mattress at home? You said you tried no pillows.

**Interviewee:** Yeah, I flipped it, I rotated it, I turned it upside down, I took it off the frame, took it off the box springs.

**Bob:** You actually removed the box spring, tried the mattress on its own?

**Interviewee:** Yeah.

**Chris:** What'd you do with the box spring?

**Interviewee:** They're in my garage.

**Chris:** Did your wife help you do all that?

**Interviewee:** No.

**Chris:** Was your wife having a problem sleeping?

**Interviewee:** It's funny, because she started, I would say the last six months, to realize too, whether it was guilt by association or legitimate, she would say, 'I'm starting to have problems too. It's uncomfortable,' and believe me, as I said, I'm not a big buy and she's probably half of me. She was saying, 'I'm having the same problems, and you can see it's starting to sink, and this pillow top isn't what I thought it was going to be. PS, your uncle's an a**hole because he sold it to us.'

**Bob:** Were you complaining to your wife about this? Were you complaining about the condition you were in, or was this something you felt internally?

**Interviewee:** Initially I felt, and then I started voicing it. Then she started saying, 'Why are you so cranky?' As you wrote in your book chapter and you nicely illustrated, you've got to get sleep, or your irritability level . . .

**Bob:** Do you remember when she actually first told you that she was being affected by it? Do you remember that conversation, or when it was approximately?

**Interviewee:** I would say it's probably about six months ago.

**Chris:** When was the, you're on the road all the time, and you're cranky, you need to come home, you've got two kids. When did that argument happen? It had to be something like OK, you come home and you're cranky but I'm not sleeping, so there had to be some conflict around that discussion at some point in time.

**Interviewee:** Oh, there was a lot of that. Because remember my son is two now, so a year ago he was one.

**Chris:** And you're gone all the time.

**Interviewee:** For most of the year he was less than that. I was not around much.

**Chris:** Then when you come home, you're waking up and you're feeling like crap and it's like, 'Why aren't you helping?'

**Interviewee:** Yeah, and 'hey, you've been gone all week, so you can be a dad for three days.'

**Chris:** Why didn't you go get a mattress earlier? It sounded like you knew it for a year, your wife is basically . . . you bought it in September, so a year ago September, it's like OK. By February she's like, 'Yeah, there's something not right here.' Right? Why did you wait so long to get a mattress?

**Interviewee:** I think life gets in the way, between building a company over the last 18 months and trying to raise two kids in a small condo and sell it, and then move to a different place.

**Chris:** Amazing, you moved in this . . .?

**Interviewee:** Buying a new mattress was not top of priority list.

**Bob:** When did you move?

**Chris:** Yeah, when did you move?

**Interviewee:** June.

**Chris:** OK.

**Bob:** You brought the old mattress with you?

**Interviewee:** Could I lay on a sofa for this?

**Chris:** OK, just game off for a second. What are you guys hearing?

**Audience Member:** He's got a stressed out life, and he's fine when he's traveling, away from the stressed life part. The mattress is being the victim of blame.

**Chris:** Right. Let's compare it back to how you guys talk to your customers. If we were interviewing him about mattresses, what would we be asking him about versus what we're talking about right now?

**Audience Member:** Competitor information, where did you find, did you look at other . . .

**Chris:** How firm is it, do you want firmness, coiled box springs. We're talking about none of that stuff yet, right?

**Audience Member:** [inaudible 20:44 to 20:46]

**Audience Member:** You're delighted [inaudible 20:48] $2,000 on it.

**Interviewee:** What was that?

**Audience Member:** You put $2,000 on the mattress, and if we do it again, did you want, 'I've got to get my use out of the $2,000.'

**Chris:** Right, he wants to extend the life of it, right?

**Audience Member:** Even though he's uncomfortable, he doesn't want to make that commitment.

**Audience Member:** I just wonder with the $2,000 mattress purchase, did you ever go back to the manufacturer, the company, and say, 'Hey, I'm having this trouble.' There should be some sort of guarantee timeline where you can . . .

**Interviewee:** Are we game on or off?

**Chris:** Game on, go ahead and answer that question.

**Interviewee:** Well, no, I just didn't know if that was something [inaudible 21:26].

**Chris:** No, it's a good question.

**Interviewee:** Yeah, well, the other caveat that makes this interesting that you might have heard me say really subtly when everyone was talking was, it was sold to me by my uncle.

**Audience:** Oh.

**Interviewee:** No, no, but to answer your question, yes. It was Macy's Home Store, and I had done, when we purchased the original mattress.

**Chris:** The research, you knew exactly [inaudible 21:55].

**Interviewee:** Did a lot of research on it. Was hoping that my uncle would actually give me a deal, which I found out at check out he wasn't going to. It's not like he was pushing this, but. I went back to Macy's Home Store and asked some questions, 'Well, you've got to rotate your mattress. Well, you've got to try this. Well, is it maybe how you're sleeping? Well, our warranty is good for this, but it covers sinkage, and what you have to do is lay a yard stick across the sink of the mattress.'

**Chris:** Did you do that?

**Interviewee:** I did not do that, because they said it had to be at least an inch and a half. Then I thought in my head, and other people suggested, 'Why don't you get some giant [inaudible 22:42], and set it in where the sinkholes are already, and have the guy come out.

**Chris:** And measure it?

**Interviewee:** And measure it to make sure you've hit that magic number, because if it didn't hit that magic number, nothing about the warranty mattered. It was not an issue of, 'oh, you found it uncomfortable? You can return it and we'll get you something else.'

**Audience Member:** Was it your uncle or your wife's?

**Interviewee:** My uncle.

**Bob:** Who suggested the cement bags?

**Interviewee:** My brother-in-law.

**Chris:** Not related to your uncle though?

**Interviewee:** No.

**Bob:** How did he even know that this was happening?

**Interviewee:** Good question, because then once I went through, which we're not even talking about yet, actually the experience on the memory foam mattress, there was a lot of discussion around that, and they asked the same question about, 'Well, did Macy's do anything to work with you or help you on your existing mattress experience?' That was a topic of conversation.

**Bob:** After you bought the new mattress?

**Interviewee:** Yes.

**Bob:** The cement thing happened, the suggestion for the cement bags happened before or after you bought the foam mattress?

**Interviewee:** That was after the foam mattress, because I had said earlier on that although there's these little sink areas on each side of the bed, it didn't get an inch and a half. The warranty didn't matter, so I wasn't going to get any recourse there.

**Bob:** Game off. This is really interesting to me that you're still talking about this old mattress that you hated, after you even bought the new one, and you're talking about it with a family member, and then the cement bags come up. Why are you still so attached? Maybe this should be game on, but I find it interesting that you're still talking about this mattress, even after you bought the new one.

**Interviewee:** I actually slept on the old mattress last night.

**Chris:** Wait, you didn't throw it out?

**Interviewee:** I have not thrown it out yet. I once had, you know dueling piano bars? I had two king sized beds in my bedroom.

**Chris:** Game off for a second.

**Interviewee:** See, you don't get this in focus groups.

**Chris:** No you don't. The point though is think of all the emotional energy that he's gone through. In a focus group, yeah, he's an impulse buyer at a Costco, that he happened to be cutting through the aisle to pick up the mattress. I say, bulls***. The fact is, he's been looking for a year and figuring out ways to see how he can return the old mattress, and then just happened to run by . . . See the thing is, he's been thinking about it, and there was something about the moment that said, 'Now.' Right? We're going to dig back to the moment of now. We only have scheduled an hour, but the key is to see, we need to find the emotional energy. We need to find out what's driving him. We need to understand how he's choosing. The thing is literally, there's so much emotion tied up in all this. Is he worried about springs? Is he worried about this has 32 coils versus 21 coils? There's just none of that thought. The thing is, what we want to get to is how did he choose that one, and how many times has he actually walked by it before and never saw it? You have a question up here.

**Audience Member:** I might give it away, but the trigger [inaudible 26:23] aisle, going to check-out at Costco, you have the history of stress and that trigger of stress checking out. At that point it seemed like you were looking for piece of mind, or piece and tranquility at that moment. You saw the mattress as maybe a solution to that.

**Chris:** Game off for a second. The thing is that what you want to be able to do is, as he formed a theory about how that happened, what you want to do is ease into the theory. Nobody wants to be told what happened. There's a technique we call 'dumbing up.' I'm a little confused here for a second, so let me just play it. I have to say I'm confused, because at some point you're not sleeping well. You're all stressed. You're in the middle of Costco, taking a shortcut to try to ease your way onto the Kennedy a little bit faster, get out of there faster, and you see a mattress. You say, 'This is the time.' What made you think you had the time today to get that? Because you had to go all the way back and get a flatbed and re-enter the Kennedy to get out?

**Interviewee:** As we talked about, this is mid-September. Now let's rewind about three months. Within that three month window, I started doing research, saying, 'The old mattress has to be replaced.' The idea of going into a mattress store or furniture store just gave me the skeeves. I did a lot of online research, and I thought, 'You know what? I'm going to make a commitment to a memory foam mattress of some kind.' I did a lot of online research, came this close to pulling the trigger on a Groupon for a memory foam mattress, and said after my experience with Macy's Home Store, the last thing I want to do is order something through Groupon online. In the event that I don't like it, then what am I going to do? Then this brings us back to the day of, apparently, the crime and the crime scene. I'm in the aisle, and all of a sudden here's all these different memory foam mattresses. I'm like, OK. I'm in Costco. I've done a lot of research. The idea of box springs versus 18 inch versus 12 versus coils, none of that stuff had ever even gone through my head. To me, it was about a good night's sleep. Waking up, feeling pretty good, so I could be as productive as I could be as a business guy and a dad and a husband the next day. I see this, my kids are talking about they want to get pizza in the checkout, and I'm like OK. Here it is. We joked about packaging earlier? The biggest thing that fascinated me is if anyone has bought one of these is to know actually how to package. Because it's in a box about this high, about that wide, cube rectangle I guess. I'm like, 'Wow.' I had to go back for the flatbed because I'm like, I pull it down and realize, this is really effing heavy. As you had asked me, the cart was pretty full. Trying to throw that on top of everything else wasn't going to work.

**Chris:** What was your wife doing at the time? Was your wife going, 'Good idea,' was she going, 'Oh come on'?

**Interviewee:** She was a little skeptic.

**Chris:** What did you say? Here's the scene, I think we should get this. What'd she look like? Hands on the hip, what's the scene?

**Interviewee:** Well, she's beautiful, so I'm setting the stage.

**Chris:** Of course. That's on tape and on video, we're all settled there.

**Interviewee:** Bless her, she was probably more content in keeping my kids from hitting each other. There was some franticness. There was some, 'Are you sure you want it?' Then I pulled down the little 12 inch by 12 inch sample of the foam. 'Here touch it, feel it.' 'Oh, that's actually not bad. If you want it, get it. It's a lot of money, I know you're not sleeping, get it.' That's when I went out and got the flatbed.

**Chris:** Had she done it, if you did the Groupon one, she hadn't touched or felt it before, right?

**Interviewee:** No.

**Bob:** How much was it? Do you remember what you paid?

**Interviewee:** Yeah, it was $699. It's funny, because the Groupon happens to be available, and the one on Groupon was less, but again I felt very concerned about if I have a bad experience about this, do I want to go the Groupon, online route versus getting it at the Costco that's five minutes from my house?

**Bob:** What was the variety?

**Chris:** Go ahead guys, go ahead.

**Bob:** Was there one kind of mattress or was there a huge assortment?

**Interviewee:** Not a huge assortment, but there was two or three different kinds, and then they had them by your different bed sizes.

**Chris:** Got it. Were there different samples or just one sample? You don't do it to me all the time.

**Bob:** I know.

**Bob:** OK.

**Interviewee:** Yeah.

**Bob:** Did you squeeze all of them, or?

**Interviewee:** There was two that we were specifically looking at, and one was a lot higher and seemed a lot softer. That was the one that we went with.

**Chris:** Was it the most expensive one?

**Interviewee:** It was.

**Audience Member:** Can I ask a question?

**Chris:** Game on, go ahead.

**Audience Member:** Take a step back. When you were in that alley [sic], and you saw the mattress, could you tell us what was the spark or the attraction or the appetite that you said, 'Oh, this one.' Because it seems like there was a couple of them, and was it price, was it something on the package, a statement or somebody sleeping, looking comfortable? Was there anything that you remember?

**Interviewee:** It's funny that you ask about the packaging, because they had their four or five, and as someone that part of my life is marketing too, it's funny to see the four or five people at point, and of course the couple that's getting a great night's sleep on some mattress. That really didn't get me. What got me was the ability to at least touch and feel it a little bit. Again, also knowing that whatever mattress I had been having and still have wasn't cutting the deal, I wanted to try something radically different. To me going with foam was radically different. I don't know what it is about, and I'm sure everyone's experienced this at some point or other, there's also something about a Costco that just fuels that occasional impulse, where it just pulls you over . . .

**Audience Member:** Let me ask you, if it was Walgreens or any other store, would that be the case?

**Interviewee:** I think that's a great question.

**Audience Member:** Like if you didn't happen to be at Costco, just at Walgreens that day . . .

**Interviewee:** I will tell you this. Walgreens specifically I wouldn't purchase it there. I would've only purchased at a store where I know I've had a great brand and customer experience, and if I ever have had a problem with any product . . . I know a couple of people have mentioned Zappos earlier. One of the things everyone loves about them is their experience. People feel more confident there. I've always historically had good experiences in a Costco. If I've had an issue it's been very [inaudible 33:56]

**Chris:** Game off for a second. OK? You need to strike all of that from the record. Every last thing from 'where else would you buy it? Why?' It's espoused behavior. We end up locking onto it and saying, 'If we did this and this and this, we could sell mattresses too.' The thing is that as much as he's talking about it, it's not the real behavior that he experienced. It's very, very risky to actually take what he just said and turn it into an opportunity for Walgreens or whatever. The notion is you want to get the stories of what it was, and we'll show you a way in which to get at that point. Not implying Walgreens, if you hadn't come across this, where would you have gone, how would you have gone? The best part about it is he had a Groupon, right? What was the store you were going to buy that from? You're not buying it from Groupon, Groupon's offering the promotion. Who was the company that was selling the mattress?

**Interviewee:** I honestly can't think of it now.

**Chris:** Did you hear that? Can't even figure out who it was. The thing is he's substituting retail with Groupon at this point. There's two other big points. One is price. Is he a knowledgeable shopper? He literally has been researching it for at least three months prior to . . . Now wait, he had a move. The thing is that the move, I had to get through the move, I had to get out of my condo, I had to get into my house, I've got two young kids, I'm getting the house settled. OK. I'm still getting a s***ty night's sleep every night. This now bubbles to the top. I couldn't have done it three months ago because you were just moving, and it's like I've got enough expenses on the other side of this thing. Prior three months is basically I know we're looking for a house, and it takes time to close. I'm not going to buy a mattress because I don't know what the house is going to be like. He's got all these barriers holding him up, but it was time. OK, go ahead. Ryan?

**Audience Member:** There's a gap in the story I'm trying to understand. I've got a sense, I'm trying to see the timeline in my head. There was a period of a year where you said, over the last year, I'm really unhappy with the mattress. Then there's a period, going back from the day that you bought it, three months where you said you were doing some research, looking around online. Do you remember a time when you were researching online?

**Chris:** Specifically.

**Audience Member:** Specific time.

**Chris:** When were you like, 'I'm looking for mattresses, man'?

**Interviewee:** A couple times in the middle of the night when I couldn't sleep.

**Chris:** Key point. Where were you? In the bedroom, or did you get up and get out?

**Interviewee:** No, I was downstairs.

**Chris:** Literally, it's 'I can't sleep, I'm going to get up. I can't sleep because of this damn mattress.' You went down to the kitchen table?

**Interviewee:** There or the island a couple times.

**Jason:** Can I throw something out really quick?

**Chris:** Go ahead.

**Jason:** This is just, so much popped in my head if I'm a mattress manufacturer. I'm offering discounts between midnight and 3:00 a.m. now. Buy now between midnight and 3:00 for 10% off.

**Chris:** You laugh, but that's the point. Do you know how many people have this story? They're thinking, again, he bought the most expensive mattress. He had an opportunity to buy it cheaper on Groupon, from somebody he didn't know. The other thing to realize is there's a subtle action that was in the middle of this, which is his wife was with him, she has to sleep on the bed. It's going to be impossible to make a purchase like that, because in a lot of cases the anxiety of saying, 'You bought this crappy mattress and I wasn't part of it,' the dynamic you have between those kinds of decisions are really, really difficult. The notion of both being in the same place, her being able to touch it, and her acknowledging that you can, OK, 'I know you're not sleeping well, you can' is like . . . I'll go. That's the dynamic.

**Bob:** The other thing we need to dive into is you made the comment that going into a mattress store gave you the heebie-jeebies, something like that. When's the last time you were in a mattress store, do you remember? You went to Macy's, so that counts. Was there any other mattress stores in between?

**Interviewee:** Well, Macy's was more of a furniture store with a mattress department, but been a long time. I walk by them. I just walked by one the other day, and since this mattress issue still hasn't actually been resolved, I was like, 'I can't go in.'

**Bob:** What happens in a mattress store?

**Interviewee:** First of all, I'm a germaphobe. I see all these beds lined up everywhere and it's creepy. Secondly I generally see someone that is working in the mattress store that I think can have no concept of, has asked anywhere near the level of questions that you've asked me. It's usually a, 'What size bed do you have? How much are you looking to spend?' I think there's a lot of people at that mattress world from my previous experiences in them that is the same as the bad notion of the car salesman. I'm not saying they're all that way, it's just that's how some of my experiences have been.

**Bob:** Game off.

**Chris:** Game off. Sorry, I've got to stand up.

**Bob:** The interesting thing is shopping on the island downstairs, he doesn't buy until he can feel the mattress, right? You give it to your wife, that experience of being able to touch and feel the product, we can't replicate online. The normal purchase process is impossible for you. You can't walk into a mattress store and even feel it, because there's this anxiety around, you're going to get approached by this salesperson.

**Chris:** Part of it you could say this is a sample of one. My thing is when you start to interview, you start to see patterns. Holy crap, 38% of these people all touch it before they buy it, and they both touch it at the same time. How can I sell a mattress online if I don't have samples? It might be that we need to say, we need to cut samples, order a sample here and return it to us with a self-addressed envelope that allows us to come to the house, that allows them to say, 'Yeah, we're going to order this,' and you order it. The thing is if you know that that's a critical point, you need to know how to do it. It has nothing to do with the features and benefits of the mattress.

**Bob:** The other . . . oh, sorry.

**Chris:** She can barely contain herself over here.

**Audience Member:** I'm like [inaudible 40:37], did you lay on the mattress at Macy's? If you're a germophobe.

**Interviewee:** I did.

**Audience Member:** OK, because the fact that you would buy a mattress just by touching it with your hand, I have to lay on it, I'm rolling around, I'm spooning my husband.

**Chris:** Oh you're the one. There's a YouTube video about you.

**Audience Member:** Even the thought, I guess sleeping, if you're taking away oh, for an online mattress company to cut away samples, his problem isn't solved. So maybe that's not . . .

**Chris:** Right. You have to do enough interviews to understand how they actually chose, but the thing is, how did you feel when you had to lay on that bed in Macy's? Were you like, 'oh my God,' or were you like, 'eh.' Can you remember the moment?

**Interviewee:** I can, only because . . .

**Chris:** How long ago was it? Four years?

**Interviewee:** That would've been five years ago, and I remember the moment only though because my wife was pregnant, and we wanted to get this new bed before the baby came, and I just remember being more concerned as to whether she was comfortable than I was comfortable. Along my OCD journey, it's gotten worse the last couple years. I'm on my way to becoming Jack Nicholson in 'As Good As It Gets,' but I'm not there yet.

**Chris:** That's the other thing. I'm not sure we're going to talk about it but the whole thing is he'll say, 'Yeah, I'm a germophobe,' that's something you need to probe deep. Because the thing is, in some cases there are people who are like rubber gloves in their house, and 'I'm a germophobe, I use wipes.'

**Bob:** He's a germophobe, but he touched a public mattress sample. It was probably dirty.

**Interviewee:** That may have been why I got sick.

**Bob:** All right, go, go.

**Audience Member:** It just sounds like, I'm focusing on the moment of truth, right? It seems like his wife was calling him a nag or a complainer, right? The moment of truth is when she finally resigned, there's the nagging, kids are in the cart, everything, chaos is going all over the place. He's stressed out, he's not sleeping. It all built to that one moment. She finally slumped her shoulders and said, 'Yeah, just go ahead and get it.' It seems like the moment of truth, where the shoulders just relaxed.

**Bob:** That's right.

**Chris:** Let me go really quick. There's a couple things. What you just experienced is the normal interview outcome. It defies all logic. You never laid on the mattress, I can't believe it. This is what comes out of these things. When you look at the forces there's all this, we'll describe how we use this, but there's all this push around I haven't slept in a year and a half. There's the reduction in anxiety because my wife, I've got her buy-in. If this thing stinks, first of all, you were in that with me. You can't blame me completely for it. Plus, have you returned anything at Costco ever? Have you brought anything back?

**Interviewee:** Other than the mattress?

**Chris:** Yeah.

**Interviewee:** Oh yeah. Not a lot, but a couple things.

**Chris:** He's done the return process, so it's possible to take this back. I'm lowering the anxiety around that. As awkward as it seems, it's easier for him to take that leap, never having laid on it, than it is to walk into the mattress store and lay down. It's one of those things where we just want to hear it a couple times, and we could say, 'That's real.'

**Audience Member:** I'm fascinated by this, because I bought one at Costco, and I'm not a germophobe, and I was going to get a Tempurpedic. I went into the mattress store, which I also find skeevy. Laid on it, did everything else. Mine came far more into, 'Wait a minute, is it really worth . . .' Tempurpedic is like $3,500 or whatever it was. 'Is it really worth this?' When I really looked into it, people were saying, 'No, it's insane.' To me Costco was the huge thing because of the return policy. They have lifetime, if you don't like it, I literally said to my wife, she'd laid on the Tempurpedic, 'We'll buy it, it's $800,' or whatever it is. 'If we don't like it . . .'

**Chris:** Let me throw something out here. [inaudible 44:52] interview like Bob was saying. Let's say this return policy ends up being one of the key things. You can't just think about return policy, because returning something like a mattress is hard. What if the store's return policy is, 'We'll pick the mattress up at your house.' That's one of the things that will reduce the anxiety.

**Audience Member:** For me Costco said that they would.

**Chris:** OK, that was it? It's not just we'll accept the return, it's 'we'll pick it up for you.'

**Interviewee:** They did that?

**Audience Member:** I ordered it and I never even touched it.

**Interviewee:** I wish I knew that.

**Chris:** The notion of this is that they're willing to pay more for it. As much as they say 'I'm not going to pay more for it,' it's the thing holding you back from buying. This is one of the frameworks which we're going to go through, but the thing is, this is . . . From the first thought to basically all the way through what we call passive looking. I'm not going to invest time, but if I'm looking through the paper and there's a circular, I'm going to start to look at it. At some point there's some event that basically causes him to actively start to invest his time to look. Then there's another event, usually it's a time-based event. Things are only going to get worse, there's a time event that causes him to say, 'I need to decide.' Then there's basically purchase and consumption. What happens is most of the time, we stand in the interview in two places. Most people will say, 'Hey, you're looking, what are you looking for?' The notion is that they haven't made the trade-offs. 'I have to lay on the mattress to make a decision. I guess not.' Everything they're going to say looking at it this way, you get bulls***.

**Bob:** I bet you the mattress industry is obsessed with the laying on the mattress part. That's all they can think about. That's how you buy mattresses, because you're going to sleep on it so you've got to lay on it. Again, this is one interview, but it might turn out that that's not the case at all. But they can't see that.

**Chris:** The second part is the interview is most people will say, 'Tell me about the experience of buying the mattress.' A customer satisfaction thing, you're looking back. We're not listening to that either. Most of the time when you get people and they're talking, they want to say, 'Oh, I love the mattress,' or 'I hate it,' and they'll tell you all the stuff about the consumption. To be honest with you, don't care. Whatever the product is, we need to be able to understand this story, all the way to the decide. I really don't care that he didn't like it. OK? At the end of the day, being a product person at the end of the day, I don't want to know what it didn't do. It's what's the magic in his mind to say, 'Poof. I just got that new mattress in my room, I'm sleeping like a baby, I'm playing with the kids, I've got more energy. When I bought that thing, what was my life going to be like?' It really doesn't matter what he bought, because that's the job. The job is basically what is he hoping for the moment he puts the money down? It's not the free. Let me give you a free trial. That's not commitment. You need to make sure they understand, what are they willing to trade off, what are they willing to pay. Think of the music. People are wrestling with music. 'I want this, I want this, I want this.' As you go back and forth, it's just not shaped up enough to make the commitment.

---

## Key JTBD Concepts from This Interview

### The Four Forces Framework
1. **Push of the current situation** - Not sleeping well, back pain, cranky, affecting family life
2. **Pull of the new solution** - Promise of better sleep, being productive, being a better dad/husband
3. **Anxiety of the new solution** - What if it doesn't work? Can I return it? Wife's buy-in needed
4. **Habit of the present** - Sunk cost of $2,000 mattress, familiarity with current situation

### Timeline Methodology
- **First Thought** → **Passive Looking** → **Active Looking** → **Deciding** → **Purchase** → **Consumption**

### Key Interview Techniques
1. **"Game on/Game off"** - Switching between interview mode and instructional commentary
2. **Getting to the "scene of the crime"** - Understanding the exact moment of purchase decision
3. **Asking about seemingly irrelevant details** (milk, baby wipes) to reconstruct the moment
4. **"Dumbing up"** - Pretending confusion to let interviewee explain their reasoning
5. **Avoiding espoused behavior** - Focus on what actually happened, not hypotheticals

### Key Insights
- "Impulse" purchases often have months of background deliberation
- Touch/feel samples can overcome anxiety even without laying on the product
- Wife's buy-in reduced anxiety ("You can't blame me completely")
- Costco's return policy reduced anxiety more than product features
- He was willing to pay MORE for reduced anxiety (Costco vs. cheaper Groupon)
- Traditional mattress store experience created anxiety (salespeople, germs)
- Research happened at 2-3am when he couldn't sleep

---

**Note:** This transcript was extracted from jobstobedone.org. For the Q&A debrief episode, visit: https://jobstobedone.org/radio/
