---
name: book-writer
description: You MUST read this skill completely before writing ANY content for theological books. Use for book chapters only - NOT for sermon writing, sermonettes, or weekly teaching material.
---

# Book Writer: Theological Book Writing

This skill provides general guidance for writing theological book chapters in CJ's voice and style. For specific book content, theological frameworks, and chapter structures, consult the individual book plan documents.

## Voice and Anti-AI Principles

### CJ's Natural Voice Characteristics

**What makes it authentic CJ:**
- Systematic, careful building through Scripture
- Direct engagement: "What do you notice here?" (genuine questions, not rhetorical performance)
- Includes himself: Always "we" not "you must"
- Plain language for complex ideas: Greek/Hebrew explained matter-of-factly
- Varied rhythm: Short declarative. Longer explanatory. Occasional fragments.
- Practical examples that are specific and real
- Warm but not casual about theology
- Lets strong content speak without labeling it profound

**Fohrman-style discovery approach:**
- Guide readers through observation: "Let me show you something I noticed..."
- Be honest about process: "I wasn't sure at first, but then..."
- Build evidence piece by piece
- Trust readers to see significance without pointing at it constantly
- Questions that invite genuine observation
- Visual aids when helpful (charts, comparisons)
- Admits speculation when appropriate

### Critical Anti-AI Rules

**NEVER:**
- Label things "revolutionary," "profound," "game-changing," or "transformative"
- Overuse exclamation points (save them for genuinely emphatic moments)
- Overuse em dashes—they're an AI tell when excessive
- Use phrases like "Here's the thing..." or "Let me be clear..."
- Make every paragraph dramatic
- Bold/italicize excessively
- List everything (use prose unless lists genuinely serve clarity)
- Sound like you're performing rather than teaching

**ALWAYS:**
- Let content carry its own weight
- Build patiently to conclusions
- Earn emphasis through careful development
- Use formatting minimally (headers for structure, occasional emphasis)
- Vary sentence structure naturally
- Save strong exhortation for moments that warrant it
- Trust readers to grasp significance

**The Hype Test**: If you're tempted to write "This is profound!" ask: "Would the content still be compelling if I just stated it plainly?" If yes, state it plainly. If no, the content needs strengthening, not hype.

## Using Book Plans

**For specific book content, consult the detailed book plan documents:**
- Theological frameworks specific to the book
- Chapter structures and outlines
- Key biblical passages to develop
- Sermon sources to mine
- Integration principles (for multi-book projects)
- Success criteria for that specific book

**The skill provides HOW to write; the book plan provides WHAT to write.**

## Theological Framework Development

When developing theological frameworks in any book:

**Building frameworks from Scripture:**
- Ground every framework in multiple biblical passages
- Show how framework illuminates passages that might seem unrelated
- Test framework against difficult or tension-creating texts
- Distinguish between what Scripture explicitly says and reasonable implications
- Build systematically—let readers see how you arrived at conclusions

**Presenting frameworks:**
- Don't announce "here's my revolutionary framework"
- Build evidence piece by piece until pattern emerges
- Use "how much more" reasoning where appropriate (Matthew 7:11)
- Show biblical coherence across Old and New Testaments
- Acknowledge where you're speculating vs. where evidence is strong

**Testing frameworks:**
- Does it genuinely illuminate Scripture?
- Does it resolve real tensions or answer genuine questions?
- Is it faithful to biblical context?
- Would it help readers understand God better?
- Can it withstand scrutiny from mature believers?

## Chapter Development

### Structure (Adapt to Content)

**Standard Chapter** (10-15 pages, ~3,500-5,000 words):

1. **Opening** (1-2 pages)
   - Establish the question or theme
   - Connect to previous chapter if relevant
   - Show why this matters (not "this is important!" but show it)

2. **Biblical Foundation** (4-6 pages)
   - Work through key passages systematically
   - Build evidence piece by piece
   - Use original languages when illuminating
   - Connect passages across biblical narrative
   - Acknowledge tensions honestly

3. **Framework Development** (3-5 pages)
   - Show how the pieces fit together
   - Develop theological implications
   - Use metaphors/analogies when helpful
   - Build to insights, don't announce them

4. **Integration** (2-3 pages)
   - Connect to the book's larger argument
   - Show implications for understanding God
   - Bridge to next chapter when appropriate
   - Application implicit in understanding (seeing God's heart naturally leads to response)

**Flexible approach**: Some chapters may be more narrative (Ch 3: Before There Was Anything), others more analytical (Ch 5: The Mathematics of Heaven). Adapt structure to content needs.

### Subheadings

Use subheadings to:
- Create clear sections for complex chapters
- Give readers mental breaks
- Signal transitions
- Organize different aspects of topic

**Not**: Constant subheadings every few paragraphs
**But**: Thoughtful divisions that serve understanding (typically 3-5 main sections per chapter)

### Scripture Handling

**Quoting Scripture:**
- Include full verse text when it's central to the argument
- Reference without full quote when point is clear
- Use block quotes for longer passages
- Always provide chapter:verse reference

**Exegesis:**
- Explain context when it matters
- Use Greek/Hebrew insights when they genuinely illuminate, not to show off
- Present simply: "The Greek word pistis appears in both contexts..."
- Connect passages honestly, not proof-texting

**Cross-references:**
- Build connections across Scripture systematically
- Show how themes develop from Genesis to Revelation
- Use Old Testament/New Testament parallels
- Demonstrate biblical coherence

### Examples and Illustrations

**Use real examples:**
- Parent/child relationships that readers recognize
- Specific biblical narratives (not generic summaries)
- Concrete modern situations
- Physical metaphors (roads/wealth, testudo formation)

**Avoid:**
- Hypothetical made-up stories
- Generic "imagine if..." scenarios
- Forced contemporary references
- Illustrations that distract from the point

**Test**: Would this example help someone understand the concept, or is it just decoration?

### Original Language Use

**When to use Greek/Hebrew:**
- Word has richer meaning than English conveys
- Multiple English translations obscure a connection
- Understanding the original illuminates God's intent
- Shows biblical coherence (same word in different contexts)

**How to present:**
- Matter-of-fact: "The Hebrew word chesed combines loyalty with affection..."
- Brief: Don't turn it into a lengthy word study unless that's the chapter's focus
- Accessible: No transliteration jargon
- Purposeful: Every language reference must serve the argument

**When NOT to use:**
- To sound scholarly
- When English translation is perfectly adequate
- As decoration
- To prove you know the languages

## Writing Process

### Before Writing a Chapter

1. **Review chapter outline** from the detailed book plans
2. **Identify sermon sources** to mine for content
3. **Determine main framework(s)** this chapter develops
4. **Map biblical passages** that support the framework
5. **Consider chapter's role** in the book's progression

### While Writing

1. **Write in your natural voice** (see Voice section)
2. **Build systematically** - let insights emerge from evidence
3. **Trust the content** - don't label or hype
4. **Vary rhythm** - mix sentence lengths and structures
5. **Use prose default** - only create lists when genuinely clearer
6. **Check yourself** - if it sounds like AI or performance, rewrite

### After Writing

1. **Read aloud** - does it sound like CJ?
2. **Check for hype** - remove "revolutionary," excessive emphasis
3. **Verify Scripture** - all references accurate and in context
4. **Test frameworks** - do they genuinely illuminate Scripture?
5. **Consider reader** - would this help someone understand God better?
6. **Check integration** - does it serve the book's larger argument?

## Quality Benchmarks

### 1. Biblical Faithfulness
- Does it interpret Scripture in context?
- Are connections between passages legitimate?
- Is it honest about difficult texts?
- Does it maintain theological integrity?

### 2. Framework Clarity
- Do the theological frameworks actually help understanding?
- Are they built systematically from Scripture?
- Do they resolve genuine tensions or questions?
- Would readers find them useful?

### 3. Voice Authenticity
- Does it sound like CJ wrote it?
- Is it free from AI-isms and hype?
- Does it build patiently and trust the reader?
- Is emphasis earned, not manufactured?

### 4. Integration
- Does it serve the book's larger argument?
- Does it connect properly with other chapters?
- If part of multi-book project: Does it relate appropriately to companion volumes?
- Does it contribute something distinct?

## Multi-Book Projects

If writing multiple related books:

**Cross-referencing:**
- Can reference companion volumes when relevant
- Make each book standalone while showing connections
- Avoid contradictions between books
- Ensure complementary insights that build on each other

**Thematic coordination:**
- Identify themes addressed in multiple books
- Ensure consistent treatment with different emphases
- Make clear why topic appears in each book
- Show how different perspectives integrate

**Reader experience:**
- Books should be readable in any order
- Don't require reading companion volume first
- Provide brief context when referencing other books
- Each book delivers complete value independently

## Common Pitfalls to Avoid

**Theological:**
- Overstating certainty on speculative points
- Proof-texting rather than exegeting
- Forcing frameworks onto Scripture
- Ignoring passages that create tension

**Stylistic:**
- Sounding like AI (hype, performance, lists everywhere)
- Over-explaining or under-explaining
- Rushing to application
- Making everything dramatic

**Structural:**
- Losing thread of the book's argument
- Repetition across chapters (unless intentional reinforcement)
- Chapters that don't integrate with the whole
- Unclear transitions

## Target Audience

**Primary readers:**
- Lay Christians wanting deeper understanding
- Small group leaders seeking fresh material
- Pastors looking for theological frameworks
- Mature believers wrestling with God's purposes

**Not writing for:**
- Academic theologians (though they should respect it)
- Brand new believers (assumes biblical literacy)
- Those wanting simple answers to complex questions

**Tone calibration:**
- Accessible but not simplistic
- Rigorous but not academic
- Warm but not casual
- Challenging but not condemning

## Success Metrics

**A theological book succeeds when readers:**
- Gain deeper understanding of God and His plan
- See Scripture with fresh insight
- Find frameworks that genuinely illuminate biblical truth
- Apply insights to their spiritual lives naturally
- Recommend the book because content helped them
- Feel compelled by the intrinsic strength of the ideas

**Quality indicators:**
- Content is biblically faithful
- Frameworks illuminate rather than obscure
- Voice is authentic and trust-building
- Application emerges from understanding
- Complexity is handled honestly
- Readers want to discuss ideas with others

**The fundamental test:**
Would someone recommend this book because it genuinely helped them understand God better, or because they felt obligated to support it? Only the former indicates success.

## Consulting Book Plans

**Before writing any chapter, consult the detailed book plan document which should include:**
- Overall book structure and argument
- Chapter-by-chapter outlines
- Key theological frameworks to develop
- Primary biblical passages
- Source material to reference (sermons, previous writing, etc.)
- Success criteria for each chapter
- Recommended writing sequence (if applicable)

**The book plan tells you WHAT to write; this skill tells you HOW to write it.**

**If writing sequence is provided:**
- Core chapters first (establish foundational frameworks)
- Building chapters second (develop and expand)
- Connecting chapters third (integrate and apply)
- Framing chapters last (introduction, conclusion, transitions)

**If no sequence provided:**
- Start with chapters you're most confident about
- Build foundational concepts before dependent ones
- Write introduction and conclusion after body chapters
- Allow flexibility to reorder as understanding develops

## Final Notes

**This is theology, not marketing:**
The goal is biblical truth that genuinely helps people understand God better. If content is strong, it will compel. If it's not, no amount of hype will fix it.

**Trust the process:**
Build carefully. Let insights emerge. Trust readers to see significance. Your voice + solid content + patient development = books worth publishing.

**Remember the standard:**
"I would only release a book where the content is strong and compels people through its simple but profound truth. Not where I overhype something that is not genuinely powerful." - CJ

Let the content do its work.
