---
name: bookmark-processor
description: This skill should be used when the user asks to "process bookmarks", "run /process-bookmarks", "analyze my twitter bookmarks", "find skill candidates from bookmarks", or wants to fetch, categorize, and extract insights from Twitter bookmarks for skill discovery.
version: 1.0.0
---

# Twitter Bookmark Processor

Automate the bookmark-to-skill discovery pipeline. Fetch, analyze, extract, propose, track, clean.

## The Workflow

```
Fetch Bookmarks → Categorize → Score → Extract Resources → Generate Proposals → Update CSV → Unbookmark
```

## How to Use

### Process All Recent Bookmarks

```
/process-bookmarks
```

### Process with Options

```
/process-bookmarks --keep-bookmarks    # Don't unbookmark after processing
/process-bookmarks --min-relevance 4   # Only process relevance 4+
/process-bookmarks --category AI-LLM   # Only process specific category
```

## What Gets Processed

### Categories

| Category | Examples |
|----------|----------|
| AI-LLM | Claude tips, agent patterns, MCP servers |
| DevOps | CI/CD, infrastructure, deployment |
| Marketing | Growth tactics, content strategy |
| Business | Pricing, sales, startup advice |
| Design | UI/UX, visual design |
| Personal | Health, productivity, life advice |
| Other | Everything else |

### Relevance Scoring (1-5)

| Score | Meaning |
|-------|---------|
| 5 | Definitely a skill - actionable workflow or pattern |
| 4 | Likely a skill - useful technique or tool |
| 3 | Maybe a skill - interesting but needs exploration |
| 2 | Not a skill - just information |
| 1 | Not relevant - personal/off-topic |

### Skill Candidate Criteria

A bookmark becomes a skill candidate when:
- Relevance score is 4-5
- Contains actionable workflow
- Has reusable pattern
- Includes tools/techniques
- Could benefit multiple projects

## Output Files

### CSV Tracking File

Location: `~/projects/adam/twitter-bookmarks.csv`

Columns:
- `handle` - Twitter username
- `tweet_text` - Tweet content (truncated)
- `url` - Tweet URL
- `timestamp` - When bookmarked
- `category` - Assigned category
- `relevance` - Score 1-5
- `plugin` - Yes/Candidate/blank

### Skill Proposals Document

Location: `~/projects/adam/skill-proposals-YYYY-MM.md`

Contains:
- Summary table of candidates
- Detailed skill specifications
- Implementation notes
- Source attribution

## Processing Steps

### 1. Fetch Bookmarks

Uses Twitter API to get recent bookmarks with:
- Tweet text (including long tweets)
- Author info
- URLs/links
- Engagement metrics

### 2. Categorize

Analyzes tweet content to assign:
- Category (AI-LLM, DevOps, etc.)
- Relevance score (1-5)
- Skill candidate flag

### 3. Extract Resources

For skill candidates, fetches linked resources:
- Blog posts
- GitHub repos
- Documentation
- Videos (extracts descriptions)

### 4. Generate Proposals

For each skill candidate:
- Summarizes core concept
- Identifies key features
- Notes implementation approach
- Estimates complexity

### 5. Update CSV

- Adds new entries
- Updates existing entries if re-bookmarked
- Maintains chronological order

### 6. Unbookmark Processed

Removes processed bookmarks from Twitter to:
- Keep bookmark list fresh
- Prevent reprocessing
- Signal "already captured"

## Configuration

### Set in CLAUDE.md or Memory

```markdown
## Bookmark Processing Preferences

CSV Location: ~/projects/adam/twitter-bookmarks.csv
Proposals Location: ~/projects/adam/skill-proposals-{date}.md
Auto-unbookmark: true
Min Relevance for Skill: 4
Focus Categories: AI-LLM, DevOps
```

## Example Session

**User**: `/process-bookmarks`

**Claude**:
```
Fetching bookmarks...
Found 25 new bookmarks since last processing.

Categorizing...
- AI-LLM: 15
- DevOps: 5
- Marketing: 3
- Personal: 2

Scoring relevance...
- Score 5: 8 bookmarks
- Score 4: 6 bookmarks
- Score 3: 7 bookmarks
- Score 2: 3 bookmarks
- Score 1: 1 bookmark

Skill candidates identified: 6

Extracting linked resources...
- Fetched 4 blog posts
- Fetched 2 GitHub repos

Generating skill proposals...
Created: skill-proposals-2026-01.md

Updating CSV...
Added 25 entries (total: 154)

Unbookmarking processed items...
Removed 25 bookmarks from Twitter.

Summary:
- New entries: 25
- Skill candidates: 6
- Resources extracted: 6
- Proposals generated: skill-proposals-2026-01.md
```

## Integration with Other Skills

### With skill-creator

When ready to implement a proposed skill:
```
/create-skill from proposal "Plain English E2E Testing"
```

### With voice-learning

Extract voice patterns from thought leader bookmarks:
```
/learn-voice from bookmarks by @bcherny
```

## Weekly Automation

Consider scheduling weekly processing:

```bash
# In cron or automation
claude -p "/process-bookmarks --quiet" >> ~/logs/bookmark-processing.log
```

## Handling Rate Limits

If Twitter API rate limits hit:
- Processing pauses automatically
- Resume with `/process-bookmarks --continue`
- Partial progress saved to CSV

## Privacy Note

- Bookmarks are private Twitter data
- Processing happens locally
- CSV is local file
- Unbookmarking is optional

## Credits

Meta-skill developed during Twitter bookmark analysis session on 2026-01-08.
