---
name: brainstorming
description: Structured Socratic questioning for exploring ideas and solutions. Use when exploring new features, evaluating approaches, or need to think through complex decisions.
---

# Brainstorming Skill

Guide for structured exploration of ideas through Socratic questioning.

## When to Use

- Exploring new feature ideas or requirements
- Evaluating multiple solution approaches
- Challenging assumptions about a problem
- Breaking down complex decisions
- Early-stage design discussions

## Socratic Questioning Framework

### 1. Clarifying Questions
- What do you mean by...?
- What is the core problem we're solving?
- Can you give an example?
- What would success look like?

### 2. Probing Assumptions
- What are we assuming here?
- Why do we believe this is true?
- What if the opposite were true?
- What are we taking for granted?

### 3. Exploring Perspectives
- How would [stakeholder] view this?
- What would a user expect?
- What would a skeptic say?
- How have others solved similar problems?

### 4. Examining Evidence
- What evidence supports this approach?
- Are there counter-examples?
- What data would change our mind?
- How confident are we in this?

### 5. Considering Consequences
- What happens if we do this?
- What are the second-order effects?
- What could go wrong?
- What's the cost of being wrong?

### 6. Questioning the Question
- Is this the right question to ask?
- What question should we be asking instead?
- Are we solving the right problem?

## Brainstorming Session Structure

```
1. DEFINE (5 min)
   - State the problem/opportunity clearly
   - Identify constraints and goals

2. DIVERGE (15 min)
   - Generate many ideas without judgment
   - Build on each other's ideas
   - Encourage wild ideas

3. CHALLENGE (10 min)
   - Apply Socratic questions to top ideas
   - Identify hidden assumptions
   - Explore edge cases

4. CONVERGE (10 min)
   - Evaluate ideas against criteria
   - Combine complementary approaches
   - Select promising directions

5. NEXT STEPS (5 min)
   - Define concrete actions
   - Assign owners and timelines
```

## Project-Specific Context

[CUSTOMIZE] Add domain-specific questions relevant to your project:
- Industry-specific considerations
- Technical constraints unique to your stack
- Stakeholder perspectives to consider
- Common assumptions in your domain

## Anti-Patterns to Avoid

- **Premature convergence**: Settling on first reasonable idea
- **Groupthink**: Not challenging popular opinions
- **Analysis paralysis**: Endless questioning without action
- **Leading questions**: Questions that assume the answer
- **Defensive responses**: Treating questions as attacks

## Output Artifacts

After brainstorming, document:
1. Problem statement (refined)
2. Key insights discovered
3. Assumptions identified (and which were challenged)
4. Top approaches with pros/cons
5. Decision and rationale
6. Open questions for future exploration
