---
name: brand-voice
description: "Define or extract a consistent brand voice that other skills can use. Two modes - Extract (analyze existing content you're proud of) or Build (strategically construct a voice from scratch). Use when starting a project, when copy sounds generic, or when output needs to sound like a specific person/brand. Triggers on: what's my voice, analyze my brand, help me define my voice, make this sound like me, voice guide, brand personality. Outputs a voice profile that can be fed into direct-response-copy and other content skills."
---

# Brand Voice

Generic copy converts worse than copy with a distinct voice. Not because the words are different—because the reader feels like they're hearing from a PERSON, not a marketing team.

This skill defines that voice. Either by extracting it from existing content or building it strategically from scratch.

---

## The core job

Create a **voice profile** that other skills can reference to produce on-brand output.

The profile should be specific enough that anyone (human or AI) could read it and write in a way that sounds consistent with the brand.

**Output format:** A voice profile document containing:
- Voice summary (2-3 sentences capturing the essence)
- Personality traits (with explanations)
- Tone spectrum (where they land on key dimensions)
- Vocabulary guide (words to use, words to avoid)
- Rhythm and structure patterns
- Example phrases (on-brand vs off-brand)
- Do's and don'ts

---

## Two modes

### Mode 1: Extract
**Use when:** They have existing content they're proud of—website copy, emails, social posts, newsletters, videos transcripts.

**Process:** Analyze the content for patterns, then codify what makes it distinctive.

### Mode 2: Build
**Use when:** Starting fresh, existing content is weak/generic, or they want to evolve their voice strategically.

**Process:** Ask strategic questions, then construct a voice aligned with their identity, audience, and positioning.

**How to choose:**

Ask: "Do you have existing content that represents how you want to sound?"

- **Yes, I have content I'm proud of** → Extract mode
- **No, I'm starting fresh** → Build mode
- **I have content but want to evolve** → Build mode (with existing content as reference for what to keep/change)

---

## Mode 1: Extract

### What to analyze

Request 3-5 pieces of content they consider "most them":
- Website copy (especially About page, homepage)
- Emails they've sent
- Social posts that performed well
- Newsletter editions
- Video or podcast transcripts
- Anything where they felt "this sounds like me"

### What to look for

**1. Tone patterns**
- Formal ↔ Casual (contractions? slang? sentence fragments?)
- Serious ↔ Playful (humor? lightness? gravity?)
- Reserved ↔ Bold (hedging? strong claims? confidence?)
- Distant ↔ Intimate (we/they vs I/you? personal stories?)

**2. Vocabulary patterns**
- Industry jargon level (heavy, light, translated?)
- Signature words or phrases they repeat
- Words they seem to avoid
- Curse words or edgy language?
- Formal words vs everyday words

**3. Rhythm patterns**
- Average sentence length
- Paragraph length
- Mix of short punchy vs longer flowing
- Use of fragments
- List usage

**4. Structural patterns**
- How they open (story? question? statement?)
- How they transition
- How they close (CTA style? summary? open loop?)
- Headers and formatting preferences

**5. Personality signals**
- Self-deprecating or confident?
- Teacher or peer?
- Polished or raw?
- Optimistic or realistic?
- References and examples they use

**6. POV patterns**
- First person (I) or plural (we)?
- How they address reader (you? folks? friends?)
- Direct address or general statements?

### Extract output

After analysis, produce the voice profile (format below).

---

## Mode 2: Build

### Strategic questions to ask

**Identity:**
1. What are 3-5 words that describe your personality?
2. What do you stand for? What's your core belief about your industry/topic?
3. What's your background? What shaped how you see things?
4. What makes you genuinely different from others in your space?

**Audience:**
5. Who are you talking to? (Be specific)
6. What tone resonates with them? (What do they respond to?)
7. What would make them trust you? What would turn them off?

**Positioning:**
8. Are you the expert, the peer, the rebel, the guide, the insider?
9. Where do you sit on accessible ↔ exclusive?
10. Where do you sit on approachable ↔ authoritative?

**Aspiration:**
11. Name 2-3 brands or people whose voice you admire. What specifically do you like about how they communicate?
12. What do you explicitly NOT want to sound like?

**Practical:**
13. Any words or phrases that are signature to you?
14. Any words or phrases you hate or want to avoid?
15. How do you feel about humor? Profanity? Hot takes?

### Build process

From the answers, construct voice profile:

1. **Synthesize personality** → Core traits that should come through
2. **Define tone spectrum** → Where they land on key dimensions
3. **Set vocabulary rules** → What to use, what to avoid
4. **Establish rhythm** → Sentence/paragraph patterns that fit
5. **Create examples** → Write sample phrases that embody the voice
6. **Define boundaries** → What's off-brand

---

## The Voice Profile (Output Format)

```
# [Brand/Person Name] Voice Profile

## Voice Summary
[2-3 sentences capturing the essence. What does this voice FEEL like to encounter?]

## Core Personality Traits
- **[Trait 1]:** [What this means in practice]
- **[Trait 2]:** [What this means in practice]
- **[Trait 3]:** [What this means in practice]
- **[Trait 4]:** [What this means in practice]

## Tone Spectrum

| Dimension | Position | Notes |
|-----------|----------|-------|
| Formal ↔ Casual | [e.g., "Casual, but not sloppy"] | [specifics] |
| Serious ↔ Playful | [e.g., "Mostly serious, occasional wit"] | [specifics] |
| Reserved ↔ Bold | [e.g., "Bold, makes strong claims"] | [specifics] |
| Simple ↔ Sophisticated | [e.g., "Simple words, sophisticated ideas"] | [specifics] |
| Warm ↔ Direct | [e.g., "Direct but not cold"] | [specifics] |

## Vocabulary

**Words/phrases to USE:**
- [word/phrase] — [why/when]
- [word/phrase] — [why/when]
- [signature phrases if any]

**Words/phrases to AVOID:**
- [word/phrase] — [why]
- [word/phrase] — [why]
- [AI-sounding words to skip]

**Jargon level:** [Heavy / Moderate / Light / Translated]

**Profanity:** [Yes / Occasional / Never]

## Rhythm & Structure

**Sentences:** [e.g., "Mix of short punchy (3-5 words) and medium (10-15 words). Rarely long."]

**Paragraphs:** [e.g., "Short. 1-3 sentences max. Lots of white space."]

**Openings:** [e.g., "Often starts with bold statement or direct challenge. Rarely asks questions."]

**Formatting:** [e.g., "Uses headers. Bulleted lists. Bold for emphasis. Minimal emojis."]

## POV & Address

**First person:** [I / We / Mix]
**Reader address:** [You / Direct name / Folks / Friends / etc.]
**Relationship stance:** [Teacher / Peer / Guide / Insider / Rebel]

## Example Phrases

**On-brand (sounds like us):**
- "[Example phrase]"
- "[Example phrase]"
- "[Example phrase]"

**Off-brand (doesn't sound like us):**
- "[Example phrase]" — [why it's wrong]
- "[Example phrase]" — [why it's wrong]
- "[Example phrase]" — [why it's wrong]

## Do's and Don'ts

**DO:**
- [specific guidance]
- [specific guidance]
- [specific guidance]

**DON'T:**
- [specific guidance]
- [specific guidance]
- [specific guidance]
```

---

## Example: Extracted Voice Profile

### Input analyzed:
Website copy, 10 tweets, 3 newsletter editions from a SaaS founder

### Output:

```
# Marc Lou Voice Profile

## Voice Summary
Sounds like a friend who's been in the trenches, figured some things out, and is sharing what actually worked—not what should work in theory. Self-deprecating but confident. Casual but sharp. Makes you feel like you're getting the real story, not the polished version.

## Core Personality Traits
- **Self-deprecating confidence:** Admits failures freely ("I believed I was Mark Zuckerberg") but backs claims with specific results. Not arrogant, but clearly knows what works.
- **Builder energy:** Everything framed around shipping, making, creating. Impatient with theory. Values speed and action.
- **Radical transparency:** Shares real numbers ($45K/month), real failures (0 users), real timelines. Nothing hidden.
- **Accessible expertise:** Knows a lot but explains simply. Never talks down. Peer, not guru.

## Tone Spectrum

| Dimension | Position | Notes |
|-----------|----------|-------|
| Formal ↔ Casual | Very casual | Contractions, fragments, emoji |
| Serious ↔ Playful | Playful with serious points | Humor to disarm, but real substance |
| Reserved ↔ Bold | Bold | Strong claims, specific numbers, no hedging |
| Simple ↔ Sophisticated | Simple | Short words, clear sentences |
| Warm ↔ Direct | Direct but warm | Friendly but doesn't waste words |

## Vocabulary

**Words/phrases to USE:**
- "Ship" — core action verb
- "Madman" — intensity descriptor ("shipped like a madman")
- Specific numbers always ($45K, 16 startups, 2 years)
- "Hey, it's [name] 👋" — signature opener

**Words/phrases to AVOID:**
- "Comprehensive" / "robust" / corporate speak
- "I think" / "maybe" / hedging language
- "Passionate about" / empty descriptors
- Anything that sounds like a LinkedIn post

**Jargon level:** Light — uses "MRR" but explains concepts simply

**Profanity:** Occasional, casual (not aggressive)

## Rhythm & Structure

**Sentences:** Short. Punchy. Often fragments. Longest sentences are lists.

**Paragraphs:** 1-2 sentences. Lots of breathing room.

**Openings:** Personal intro ("Hey, it's Marc 👋") or bold claim.

**Formatting:** Minimal headers. Emoji as punctuation. Numbers stand out.

## POV & Address

**First person:** I (never "we" unless referring to a group)
**Reader address:** You, direct
**Relationship stance:** Peer who's slightly ahead. "I was where you are."

## Example Phrases

**On-brand:**
- "I shipped 16 startups in 2 years. Now I'm happy and earn $45,000 a month."
- "If you could, you would have already. 🤷🏻"
- "I believed I was Mark Zuckerberg, built a startup for 1 year, and got 0 users."

**Off-brand:**
- "Our comprehensive solution helps entrepreneurs optimize their workflow." — Corporate, vague, no personality
- "I'm passionate about helping founders succeed." — Empty, cliché
- "It might potentially help some people in certain situations." — Hedge-y, weak

## Do's and Don'ts

**DO:**
- Lead with specific results and real numbers
- Admit failures and mistakes openly
- Write like you're texting a smart friend
- Use emoji sparingly but naturally
- Keep paragraphs short

**DON'T:**
- Hedge or qualify statements unnecessarily
- Use corporate or marketing-speak
- Write long paragraphs
- Hide behind "we" when you mean "I"
- Sound like you're trying to impress
```

---

## Example: Built Voice Profile

### Inputs provided:
New coaching business. Personality: direct, warm, no-BS. Audience: overwhelmed entrepreneurs. Positioning: experienced peer, not guru. Admires: Sahil Bloom's clarity, James Clear's simplicity. Hates: hustle culture, fake positivity.

### Output:

```
# [Coach Name] Voice Profile

## Voice Summary
The supportive friend who's direct enough to tell you what you need to hear, not what you want to hear. Warm but efficient. Experienced but not preachy. Makes complex things simple without dumbing them down. Anti-hustle, pro-sustainable success.

## Core Personality Traits
- **Warm directness:** Cares about you AND will tell you straight. No toxic positivity, no harsh criticism. Honest but kind.
- **Calm confidence:** Been through it, figured things out. Doesn't need to prove anything. Shares from experience, not theory.
- **Simplifier:** Takes complicated concepts and makes them actionable. Values clarity over cleverness.
- **Anti-hustle:** Success doesn't require suffering. Sustainable beats unsustainable. Rest is productive.

## Tone Spectrum

| Dimension | Position | Notes |
|-----------|----------|-------|
| Formal ↔ Casual | Casual-professional | Warm, approachable, but not sloppy |
| Serious ↔ Playful | Mostly serious | Occasional lightness, but grounded |
| Reserved ↔ Bold | Measured bold | Clear opinions, not aggressive |
| Simple ↔ Sophisticated | Simple | Everyday words, accessible |
| Warm ↔ Direct | Both | Direct message, warm delivery |

## Vocabulary

**Words/phrases to USE:**
- "Here's the thing" — transition into real talk
- "What actually works" — contrast to theory/hype
- "Sustainable" — key value
- "You don't have to" — permission-giving
- Specific but not hypey numbers

**Words/phrases to AVOID:**
- "Hustle" / "grind" / "crush it"
- "10x" / "scale" / growth-bro language
- "Just" (minimizing: "just do this")
- "Amazing" / "incredible" / empty superlatives
- "Rise and grind" / hustle culture phrases

**Jargon level:** Very light — explains everything in plain language

**Profanity:** Rare, only for emphasis

## Rhythm & Structure

**Sentences:** Medium length. Flows conversationally. Short sentences for emphasis.

**Paragraphs:** 2-4 sentences. Enough room to develop a thought.

**Openings:** Often reframes a problem. "Most advice about X tells you to Y. But here's what actually works."

**Formatting:** Clean. Some bold for emphasis. Occasional bullet points. Minimal emoji.

## POV & Address

**First person:** I (personal, not hiding behind "we")
**Reader address:** You, direct and personal
**Relationship stance:** Experienced peer. Been there, found a path, sharing it.

## Example Phrases

**On-brand:**
- "You don't have to burn out to build something meaningful."
- "Here's the thing about productivity advice: most of it assumes you have unlimited energy. You don't."
- "I tried the hustle approach for 3 years. It worked—until it didn't. Here's what I do instead."

**Off-brand:**
- "Ready to 10x your productivity and CRUSH your goals?!" — Hustle culture, hype-y
- "In this comprehensive guide, you'll learn..." — Corporate, distant
- "Just wake up at 5am!" — Oversimplified, "just" minimizes difficulty

## Do's and Don'ts

**DO:**
- Acknowledge their struggle is real
- Offer permission to do less/differently
- Share what you actually do, not what sounds good
- Keep it simple and actionable
- Speak as a peer who's further down the same path

**DON'T:**
- Promise unrealistic results
- Use hustle/grind language
- Talk down to them
- Overcomplicate with jargon
- Sound like a motivational poster
```

---

## How this skill connects to others

The voice profile becomes an INPUT to other skills:

**direct-response-copy + voice profile:**
"Write landing page copy for [product]. Use the attached voice profile to match tone, vocabulary, and style."

**lead-magnet + voice profile:**
"Generate lead magnet concepts for [business]. The hook and framing should align with this voice profile."

**email sequences, social posts, long-form content:**
All can reference the voice profile to maintain consistency.

**The workflow:**
1. Run brand-voice first (Extract or Build)
2. Save the voice profile
3. Reference it in every subsequent content task

---

## When to revisit

Voice isn't static. Revisit the profile when:
- The brand evolves or pivots
- Audience changes significantly
- Current voice isn't converting
- New team members need onboarding
- Content starts feeling inconsistent

---

## The test

A good voice profile passes this test:

1. **Recognizable:** Could someone identify content as "theirs" without a byline?
2. **Actionable:** Could a writer (human or AI) produce on-brand content using only the profile?
3. **Differentiated:** Does it sound different from competitors?
4. **Authentic:** Does it feel true to who they are (or want to be)?
5. **Consistent:** Can it be applied across formats (social, email, long-form)?

If any answer is no, the profile needs more specificity.
