---
name: Business Plan Writer
slug: business-plan-writer
description: Create comprehensive business plans, financial projections, and strategic documents for funding or planning
category: business
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "business plan"
  - "write business plan"
  - "financial projections"
  - "business strategy"
  - "strategic plan"
  - "funding plan"
tags:
  - business-planning
  - strategy
  - finance
  - fundraising
  - business-operations
---

# Business Plan Writer

Expert business plan creation system that helps you develop comprehensive business plans, financial projections, market analysis, and strategic documents for fundraising, partnerships, or internal planning. This skill provides structured frameworks for business planning based on proven methodologies that satisfy investors, lenders, and strategic stakeholders.

A strong business plan is your roadmap and your pitch. This skill helps you think through your business model, validate market opportunity, project financials realistically, and communicate your vision compellingly. Whether you're raising venture capital, securing a bank loan, or planning strategic growth, this provides the structure and rigor required.

Built on business planning best practices from leading accelerators, investors, and strategic consultants, this skill combines market analysis, financial modeling, and strategic thinking to create plans that drive action and secure resources.

## Core Workflows

### Workflow 1: Business Plan Structure
**Standard business plan outline (20-40 pages typical)**

1. **Executive Summary (1-2 pages)**
   - Company overview and mission
   - Problem and solution
   - Market opportunity (TAM, SAM, SOM)
   - Business model and revenue streams
   - Competitive advantage
   - Financial highlights (3-year projections)
   - Funding ask and use of funds
   - Write this LAST (summarize entire plan)

2. **Company Description (2-3 pages)**
   - Company history and background
   - Legal structure (LLC, C-corp, etc.)
   - Location and facilities
   - Mission, vision, values
   - Key milestones achieved
   - Current stage (pre-revenue, early revenue, growth)

3. **Products & Services (3-5 pages)**
   - Detailed product/service descriptions
   - Features and benefits
   - Intellectual property (patents, trademarks)
   - Product roadmap and R&D
   - Pricing strategy
   - Competitive positioning

4. **Market Analysis (5-7 pages)**
   - Industry overview and trends
   - Target market definition
   - Market size (TAM, SAM, SOM)
   - Customer segments and personas
   - Market trends and drivers
   - Regulatory environment

5. **Competitive Analysis (3-4 pages)**
   - Direct and indirect competitors
   - Competitive landscape matrix
   - Strengths and weaknesses analysis
   - Competitive advantages (moats)
   - Barriers to entry

6. **Marketing & Sales Strategy (4-5 pages)**
   - Go-to-market strategy
   - Marketing channels and tactics
   - Sales process and methodology
   - Customer acquisition strategy
   - Customer retention strategy
   - Pricing and positioning

7. **Operations Plan (3-4 pages)**
   - Production/service delivery process
   - Suppliers and vendors
   - Facilities and equipment
   - Technology and systems
   - Quality control
   - Scalability plan

8. **Management Team (2-3 pages)**
   - Organizational structure
   - Leadership team bios
   - Key advisors and board members
   - Talent acquisition plan
   - Compensation philosophy

9. **Financial Projections (5-7 pages)**
   - Income statement (3-5 year projections)
   - Cash flow statement
   - Balance sheet
   - Key assumptions
   - Break-even analysis
   - Unit economics

10. **Funding Request (2-3 pages)** *(if raising capital)*
    - Amount seeking
    - Use of funds (detailed breakdown)
    - Type of funding (equity, debt, convertible note)
    - Terms sought
    - Exit strategy

11. **Appendix**
    - Detailed financials
    - Market research data
    - Product specs
    - Letters of intent from customers
    - Resumes of key team members

### Workflow 2: Market Analysis & Sizing
**Validate market opportunity with data**

1. **Market Segmentation**
   - **TAM (Total Addressable Market)**: Total market demand
     - Example: All email marketing software globally = $5B
   - **SAM (Serviceable Addressable Market)**: Market you can serve
     - Example: Email marketing for SMBs in US = $1B
   - **SOM (Serviceable Obtainable Market)**: Market you can capture
     - Example: Realistic 5% market share = $50M

2. **Market Research Methods**
   - **Primary Research**: Surveys, interviews, focus groups
   - **Secondary Research**: Industry reports (Gartner, Forrester, IBISWorld)
   - **Competitive Analysis**: Competitor revenue estimates, market share
   - **Government Data**: Census, industry statistics
   - **Trade Associations**: Industry reports and benchmarks

3. **Customer Segmentation**
   - Define 2-3 target customer segments
   - Create detailed personas:
     - Demographics (age, income, location, role)
     - Psychographics (values, motivations, pain points)
     - Behavior (buying patterns, media consumption)
     - Needs and goals
   - Quantify each segment size and value

4. **Market Trends**
   - Growth rate and trajectory
   - Technology disruptions
   - Regulatory changes
   - Demographic shifts
   - Macro-economic factors

### Workflow 3: Financial Projections & Modeling
**Build credible 3-5 year financial forecasts**

1. **Revenue Model**
   Choose appropriate model for your business:
   - **SaaS**: MRR × # of customers
   - **E-commerce**: Units sold × Average order value
   - **Marketplace**: GMV × Take rate
   - **Freemium**: Free users × Conversion rate × ARPU
   - **Service**: Billable hours × Hourly rate × Utilization

2. **Revenue Projections**
   - Start with bottom-up model:
     - Month 1: X customers at $Y/month = $Z
     - Assume X% MoM growth
     - Project 36-60 months forward
   - Validate with top-down:
     - If capturing 1% of $1B market = $10M (achievable?)
   - Build multiple scenarios: Conservative, Base, Optimistic

3. **Cost of Goods Sold (COGS)**
   - Direct costs tied to revenue
   - Variable costs that scale with sales
   - Examples: Hosting, payment processing, manufacturing, shipping
   - Calculate gross margin % (Revenue - COGS) / Revenue
   - Target gross margins by industry:
     - SaaS: 75-90%
     - E-commerce: 30-50%
     - Services: 50-70%

4. **Operating Expenses**
   - **Salaries & Benefits**: Headcount plan × average salary
   - **Marketing & Sales**: CAC × new customers, campaigns
   - **Rent & Facilities**: Office space, utilities
   - **Software & Tools**: SaaS subscriptions, licenses
   - **Professional Services**: Legal, accounting
   - **R&D**: Product development, engineering
   - Model month-by-month for Year 1, quarterly for Years 2-3

5. **Cash Flow Projections**
   ```
   Starting Cash
   + Revenue collected (consider payment terms: Net 30)
   - COGS paid
   - Operating expenses paid
   - CapEx (equipment, buildout)
   = Ending Cash
   ```
   - Identify cash flow gaps (when do you run out of cash?)
   - Determine funding needed to reach profitability or next milestone

6. **Key Metrics to Calculate**
   - **Break-even point**: When revenue = total costs
   - **Burn rate**: Monthly cash spent
   - **Runway**: Months of cash remaining
   - **CAC**: Customer acquisition cost
   - **LTV**: Customer lifetime value
   - **LTV:CAC ratio** (target: 3:1 or higher)
   - **Payback period**: Months to recover CAC
   - **Rule of 40**: (Growth rate % + Profit margin %) ≥ 40 (for SaaS)

### Workflow 4: Competitive Analysis
**Understand competitive landscape and differentiation**

1. **Competitor Identification**
   - **Direct Competitors**: Same product, same market
   - **Indirect Competitors**: Different solution to same problem
   - **Future Competitors**: Adjacent players who could enter
   - Identify top 5-10 competitors to analyze

2. **Competitive Matrix**
   Create table comparing you vs. competitors on:
   - Product features
   - Pricing
   - Target market
   - Distribution channels
   - Strengths and weaknesses
   - Market share/revenue (estimated)

3. **Competitive Advantages (Moats)**
   Identify sustainable advantages:
   - **Technology**: Proprietary technology, patents
   - **Network Effects**: Value increases with users
   - **Brand**: Strong brand recognition and loyalty
   - **Switching Costs**: Hard for customers to leave
   - **Scale**: Cost advantages from size
   - **Data**: Proprietary data that improves product
   - **Distribution**: Unique access to customers

4. **Barriers to Entry**
   What prevents new competitors from entering?
   - High capital requirements
   - Regulatory hurdles
   - Existing customer relationships
   - Intellectual property protection
   - Economies of scale

### Workflow 5: Go-to-Market Strategy
**Define how you'll acquire and retain customers**

1. **Customer Acquisition**
   - **Marketing Channels**:
     - Inbound: SEO, content marketing, social media
     - Outbound: Cold email, cold calling, ads
     - Partnerships: Channel partners, integrations, affiliates
     - Events: Trade shows, conferences, webinars
   - For each channel, estimate:
     - Cost per lead
     - Conversion rate
     - CAC

2. **Sales Process**
   - **Sales Motion**: Self-serve, inside sales, field sales
   - **Sales Cycle Length**: Days from lead to close
   - **Average Deal Size**: Typical contract value
   - **Sales Funnel**:
     - Leads → MQLs → SQLs → Opportunities → Customers
     - Conversion rates at each stage
   - **Pricing Model**: Freemium, tiered, usage-based, custom

3. **Customer Retention**
   - Onboarding process
   - Customer success programs
   - Retention initiatives (loyalty programs, community)
   - Expansion opportunities (upsell, cross-sell)
   - Churn reduction targets

4. **Unit Economics**
   ```
   CAC (Customer Acquisition Cost) = Sales & Marketing Spend / New Customers
   LTV (Lifetime Value) = ARPU × Gross Margin % × (1 / Churn Rate)
   LTV:CAC Ratio = LTV / CAC (target: 3:1 or higher)
   CAC Payback = CAC / (ARPU × Gross Margin %) (target: <12 months)
   ```

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Start business plan | "Create business plan outline" |
| Market sizing | "Calculate TAM/SAM/SOM for [market]" |
| Financial model | "Build 3-year financial projections" |
| Competitor analysis | "Analyze competitors in [industry]" |
| Unit economics | "Calculate CAC and LTV" |
| Break-even analysis | "When do we break even?" |
| Use of funds | "Create use of funds breakdown" |
| Executive summary | "Write executive summary" |
| SWOT analysis | "Create SWOT for [company]" |
| Pitch deck version | "Convert plan to pitch deck" |

## Best Practices

### Writing Quality
- **Clear and concise**: No jargon, easy to understand
- **Data-driven**: Back claims with research and numbers
- **Realistic**: Avoid over-optimistic projections
- **Compelling**: Tell a story, not just facts
- **Visual**: Use charts, graphs, tables (break up text)
- **Proofread**: Typos undermine credibility

### Financial Projections
- **Build bottom-up**: Start with unit economics, build up
- **Conservative assumptions**: Better to exceed expectations
- **Multiple scenarios**: Show range of outcomes
- **Monthly detail Year 1**: Quarterly Years 2-3
- **Document assumptions**: Make it easy to update
- **Validate reasonability**: Does market share seem achievable?

### Market Analysis
- **Cite sources**: Industry reports, research studies
- **Be specific**: "SMB market" is too broad
- **Show growth**: Investors want growing markets
- **Prove demand**: Customer interviews, LOIs, waitlist
- **Realistic capture**: Don't claim 50% market share in Year 2

### Competitive Positioning
- **Honest assessment**: Don't claim "no competition"
- **Differentiation**: Clearly articulate your unique value
- **Sustainable advantages**: Why can't competitors copy you?
- **Roadmap**: How will you stay ahead?

### Team Section
- **Highlight experience**: Relevant backgrounds, past successes
- **Fill gaps**: Acknowledge weaknesses, plan to hire
- **Advisors**: Credible advisors add legitimacy
- **Commitment**: Show team is full-time, invested

## Plan Variations by Audience

**Investor Business Plan** (VC/Angel):
- Emphasize: Market size, growth potential, team, traction
- Financial focus: Revenue growth, path to profitability (or next milestone)
- Length: 20-30 pages
- Tone: Bold, ambitious

**Bank Loan Business Plan**:
- Emphasize: Profitability, cash flow, collateral, repayment ability
- Financial focus: Steady revenue, conservative projections
- Length: 15-25 pages
- Tone: Conservative, low-risk

**Internal Strategic Plan**:
- Emphasize: Objectives, initiatives, resource allocation
- Financial focus: Budgets, ROI on initiatives
- Length: 10-20 pages
- Tone: Operational, detailed

**Partnership Business Plan**:
- Emphasize: Mutual benefits, market opportunity, integration plan
- Financial focus: Revenue sharing, joint economics
- Length: 10-15 pages
- Tone: Collaborative

## Common Pitfalls to Avoid

- **Hockey stick projections**: Unrealistic exponential growth
- **Ignoring competition**: Claiming "no competitors"
- **Weak team section**: Lack of relevant experience
- **Vague market**: "Everyone is our customer"
- **Missing use of funds**: Not specifying how capital is spent
- **No traction**: No validation, customers, or momentum
- **Overconfidence**: Dismissing risks and challenges
- **Too long**: 50+ page plans don't get read
- **No executive summary**: Readers need the highlights first
- **Ugly formatting**: Poor design undermines professionalism

## Financial Projection Template (SaaS Example)

**Year 1 Monthly Projections:**

| Month | New MRR | Total MRR | Churn | Net New MRR | Customers | COGS | OpEx | Profit |
|-------|---------|-----------|-------|-------------|-----------|------|------|--------|
| Jan | $5K | $5K | $0 | $5K | 10 | $1K | $30K | -$26K |
| Feb | $7K | $12K | $200 | $6.8K | 24 | $2K | $32K | -$22K |
| Mar | $10K | $22K | $400 | $9.6K | 44 | $4K | $35K | -$17K |
| ... | ... | ... | ... | ... | ... | ... | ... | ... |

**Assumptions:**
- ARPU: $500/month
- Churn: 2% monthly
- CAC: $1,000
- Gross margin: 80%
- Initial team: 3 FTEs at $100K avg

**Key Metrics:**
- Break-even month: Month 18
- Runway: 24 months (with $500K seed funding)
- Year 3 ARR: $2.5M
- LTV:CAC: 4.2:1

## Tools & Resources

**Business Planning Software:**
- LivePlan: Guided templates, financials
- Enloop: Automated financial forecasting
- Bizplan: Drag-and-drop builder

**Financial Modeling:**
- Excel/Google Sheets: Full control
- Causal: Modern financial modeling
- Finmark: SaaS-specific modeling

**Market Research:**
- IBISWorld: Industry reports
- Statista: Market statistics
- Gartner/Forrester: Tech market research
- Census Bureau: Demographic data

**Examples & Templates:**
- SBA.gov: Free templates and guides
- Sequoia Capital: Business plan template
- Y Combinator: Startup school resources
