---
name: "Business Registry Lookup"
description: "Lookup company registration records and corporate information"
allowed-tools:
  - src.tools.business_registry
---

# Business Registry Lookup

## Purpose

Search official business registries to verify company registration, corporate structure, and filing status. Access formation documents, registered addresses, and corporate officers.

## When to Use

- Verifying company existence and legal status
- Confirming registered business addresses
- Identifying corporate officers and directors
- Checking company formation dates and jurisdiction
- Due diligence on business counterparties
- Validating corporate structure and ownership
- Investigating shell companies or suspicious entities

## How to Use

The business registry tool searches multiple official databases:

- **Company Formation**: Incorporation date, jurisdiction, entity type
- **Registered Information**: Official addresses, registered agents
- **Corporate Officers**: Directors, officers, authorized representatives
- **Filing Status**: Active/inactive status, compliance with filing requirements
- **Corporate Structure**: Parent/subsidiary relationships where available

## Examples

**Basic company verification:**
```
Company: XYZ Corporation
Registry Search: Verify incorporation, registered address, current status
```

**Corporate officer identification:**
```
Entity: International Holdings Ltd
Investigation: Identify directors, officers, and key management
```

**Multi-jurisdiction search:**
```
Company Group: ABC Holdings and subsidiaries
Analysis: Map corporate structure across multiple jurisdictions
```

**Shell company investigation:**
```
Suspicious Entity: Offshore Trading Co.
Due Diligence: Verify legitimate business operations vs shell company indicators
```

## Important Notes

- Registry information varies by jurisdiction - some provide more details than others
- Offshore jurisdictions may have limited public disclosure requirements
- Information freshness depends on filing frequency and registry update cycles
- Cross-reference with other sources for complete due diligence
- Some registries require paid subscriptions for detailed information
- Be aware of privacy laws that may limit access to certain records
- Verify information currency as corporate structures can change rapidly