---
schema: "1.0"
name: business-strategy
version: "1.0.0"
description: 商業策略：藍海策略、差異化、競爭優勢、價值創新、商業模式設計
domain: business
triggers:
  keywords:
    primary: [策略, strategy, 藍海, blue ocean, 商業模式, business model, 競爭優勢, positioning]
    secondary: [差異化, differentiation, 價值主張, value proposition, 護城河, moat, B2B, B2C, D2C, 平台, platform]
  context_boost: [創新, innovation, 市場, market, 分析, 洞察, insight]
  context_penalty: [技術, code, 程式, frontend]
  priority: high
dependencies:
  software-skills: [documentation]
author: claude-domain-skills
---

# 商業策略 Business Strategy

> 創造無人競爭的市場空間，讓競爭變得無關緊要

## 適用場景

- 新事業/產品策略規劃
- 市場定位與差異化
- 商業模式設計與創新
- 競爭策略分析
- 價值主張設計

## 藍海策略框架

```
┌─────────────────────────────────────────────────────────────────┐
│  紅海 vs 藍海                                                   │
│                                                                 │
│  紅海（Red Ocean）           藍海（Blue Ocean）                 │
│  ─────────────────           ─────────────────                  │
│  在現有市場競爭               創造新市場空間                    │
│  打敗競爭對手                 讓競爭變得無關                    │
│  剝削現有需求                 創造並掌握新需求                  │
│  價值與成本取捨               打破價值-成本抵換                 │
│  差異化或低成本二選一         同時追求差異化與低成本            │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

### 四項行動架構 (ERRC)

| 行動 | 問題 | 目的 |
|------|------|------|
| **消除 (Eliminate)** | 產業認為理所當然但可消除的因素？ | 降低成本 |
| **降低 (Reduce)** | 哪些因素應降低到產業標準以下？ | 降低成本 |
| **提升 (Raise)** | 哪些因素應提升到產業標準以上？ | 增加價值 |
| **創造 (Create)** | 產業從未提供的因素應該創造？ | 增加價值 |

### 策略畫布

```
價值
  ↑
高 │           ●───●
   │          /     \
   │    ●────●       ●
中 │   /              \
   │  ●                ●───●
低 │ ●                      ●
   └─┴──┴──┴──┴──┴──┴──┴──┴──→ 競爭因素
     A  B  C  D  E  F  G  H

── 產業標準
── 我們的策略
── 競爭者

目標：創造差異化的價值曲線
```

## 競爭策略

### Porter 競爭策略

```
┌─────────────────────────────────────────────────────────────────┐
│                     競爭優勢來源                                │
│              ┌────────────────┬────────────────┐               │
│              │    低成本      │    差異化      │               │
│  ┌───────────┼────────────────┼────────────────┤               │
│  │  廣泛     │  成本領導      │  差異化        │               │
│  │  市場     │  Cost Leader   │  Differentiation│              │
│  ├───────────┼────────────────┼────────────────┤               │
│  │  利基     │  成本聚焦      │  差異化聚焦    │               │
│  │  市場     │  Cost Focus    │  Diff. Focus   │               │
│  └───────────┴────────────────┴────────────────┘               │
│                                                                 │
│  ⚠️ 避免「卡在中間」：沒有明確策略定位                         │
└─────────────────────────────────────────────────────────────────┘
```

### 競爭優勢來源

| 類型 | 說明 | 範例 |
|------|------|------|
| **成本優勢** | 比競爭者更低的成本結構 | Walmart, Costco |
| **差異化優勢** | 獨特的價值讓客戶願意付溢價 | Apple, Tesla |
| **網路效應** | 用戶越多價值越高 | Facebook, Uber |
| **轉換成本** | 離開的成本高 | Adobe, SAP |
| **品牌護城河** | 強烈的品牌認知 | Coca-Cola, Nike |
| **專利/獨家** | 法律或獨家保護 | 藥廠專利 |

## 商業模式設計

### Business Model Canvas

```markdown
┌──────────────────┬──────────────────┬──────────────────┐
│   關鍵合作夥伴   │    關鍵活動      │   價值主張       │
│   Key Partners   │  Key Activities  │ Value Proposition│
│                  │                  │                  │
│  • 供應商        │  • 產品開發      │  • 解決什麼問題？│
│  • 策略聯盟      │  • 營運維護      │  • 滿足什麼需求？│
│                  │  • 平台維護      │  • 提供什麼價值？│
│                  ├──────────────────┤                  │
│                  │    關鍵資源      │                  │
│                  │  Key Resources   │                  │
│                  │                  │                  │
│                  │  • 人才          │                  │
│                  │  • 技術          │                  │
│                  │  • 資金          │                  │
├──────────────────┴──────────────────┼──────────────────┤
│          成本結構                   │    收入來源      │
│       Cost Structure                │  Revenue Streams │
│                                     │                  │
│  • 固定成本：人事、租金             │  • 銷售收入      │
│  • 變動成本：行銷、客服             │  • 訂閱收入      │
│                                     │  • 授權收入      │
└─────────────────────────────────────┴──────────────────┘
              │                              │
              │       顧客關係               │
              │   Customer Relations         │
              ├──────────────────────────────┤
              │       通路                   │
              │       Channels               │
              ├──────────────────────────────┤
              │       顧客區隔               │
              │    Customer Segments         │
              └──────────────────────────────┘
```

### 價值主張設計

```markdown
## Value Proposition Canvas

### 顧客輪廓 (Customer Profile)
┌─────────────────────────────────────┐
│  顧客任務 (Jobs)                    │
│  • 顧客想完成什麼？                 │
│  • 功能性、社會性、情感性任務       │
├─────────────────────────────────────┤
│  痛點 (Pains)                       │
│  • 什麼讓顧客煩惱？                 │
│  • 風險、障礙、不想要的結果         │
├─────────────────────────────────────┤
│  收益 (Gains)                       │
│  • 顧客想要什麼結果？               │
│  • 必要、預期、渴望、意外的收益     │
└─────────────────────────────────────┘

### 價值地圖 (Value Map)
┌─────────────────────────────────────┐
│  產品與服務                         │
│  • 提供什麼？                       │
├─────────────────────────────────────┤
│  痛點解決方案                       │
│  • 如何減輕顧客痛點？               │
├─────────────────────────────────────┤
│  收益創造者                         │
│  • 如何創造顧客收益？               │
└─────────────────────────────────────┘

目標：達成 Product-Market Fit
```

## 洞察力培養

### 洞察來源

| 來源 | 方法 |
|------|------|
| **顧客觀察** | 實地觀察用戶行為，非問卷 |
| **異常現象** | 注意不符合預期的數據或行為 |
| **極端用戶** | 研究重度使用者和拒絕者 |
| **類比思考** | 其他產業如何解決類似問題？ |
| **逆向思考** | 如果反過來做會怎樣？ |

### 洞察筆記模板

```markdown
## 💡 洞察記錄

**觀察**：（看到什麼現象？）
**為什麼**：（背後的原因是？）
**所以**：（代表什麼機會？）
**行動**：（可以怎麼做？）
```

## 差異化策略

### 差異化來源

```
┌─────────────────────────────────────────────────────────────────┐
│  差異化維度                                                     │
│                                                                 │
│  產品差異化                                                     │
│  ├─ 功能：更多/更少/不同的功能                                 │
│  ├─ 品質：更耐用/更精緻                                        │
│  ├─ 設計：更美觀/更人性化                                      │
│  └─ 技術：更先進/更簡單                                        │
│                                                                 │
│  服務差異化                                                     │
│  ├─ 速度：更快交付                                             │
│  ├─ 便利：更容易購買/使用                                      │
│  ├─ 客製化：個人化服務                                         │
│  └─ 售後：更好的支援                                           │
│                                                                 │
│  形象差異化                                                     │
│  ├─ 品牌：情感連結                                             │
│  ├─ 故事：品牌敘事                                             │
│  └─ 價值觀：社會責任                                           │
└─────────────────────────────────────────────────────────────────┘
```

### 差異化檢查清單

```markdown
## 差異化評估

□ 對顧客有價值嗎？（願意付錢）
□ 競爭者難以模仿嗎？
□ 與我們的能力匹配嗎？
□ 可以持續維持嗎？
□ 可以清楚溝通嗎？
```

## 策略規劃流程

### 策略思考框架

```markdown
1. Where to Play（在哪裡競爭）
   - 目標市場？
   - 目標顧客？
   - 地理範圍？
   - 產品/服務範圍？

2. How to Win（如何取勝）
   - 差異化還是成本領導？
   - 獨特價值主張？
   - 核心競爭力？

3. What Capabilities（需要什麼能力）
   - 必須擁有的能力？
   - 需要建立的能力？
   - 可以外包的能力？

4. What Management Systems（管理系統）
   - 衡量指標？
   - 激勵機制？
   - 決策流程？
```

## 商業模式類型

### 交易對象分類

```
┌─────────────────────────────────────────────────────────────────┐
│  商業模式矩陣                                                   │
│                                                                 │
│              賣給誰？                                           │
│              ┌────────────────┬────────────────┐               │
│              │   消費者 (C)   │   企業 (B)     │               │
│  ┌───────────┼────────────────┼────────────────┤               │
│  │  企業 (B) │    B2C         │    B2B         │               │
│  │  賣       │  電商、零售    │  SaaS、批發    │               │
│  ├───────────┼────────────────┼────────────────┤               │
│  │  消費者   │    C2C         │    C2B         │               │
│  │  (C) 賣   │  二手平台      │  網紅、接案    │               │
│  └───────────┴────────────────┴────────────────┘               │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

| 模式 | 說明 | 典型案例 |
|------|------|----------|
| **B2C** | 企業對消費者 | Amazon、Netflix、星巴克 |
| **B2B** | 企業對企業 | Salesforce、AWS、聯強 |
| **C2C** | 消費者對消費者 | eBay、蝦皮、Airbnb |
| **C2B** | 消費者對企業 | 網紅行銷、Upwork、群募 |
| **B2B2C** | 企業透過企業到消費者 | 品牌 → 通路 → 消費者 |
| **D2C** | 直接對消費者 | 品牌官網、特斯拉直銷 |

### 電子商務模式

```markdown
## 電商營收模式

### 1. 產品銷售
- 自營商品
- 代銷/寄賣
- 訂閱制（週期性購買）

### 2. 平台抽成
- 交易手續費
- 上架費
- 廣告收入

### 3. 會員制
- 免運會員
- 折扣會員
- 專屬服務

## 金流整合考量

| 金流方式 | 優點 | 缺點 |
|----------|------|------|
| 信用卡 | 即時、普及 | 手續費高 |
| 第三方支付 | 安全、便利 | 需整合 |
| 銀行轉帳 | 手續費低 | 確認慢 |
| 貨到付款 | 信任度高 | 拒收風險 |
| 分期付款 | 提高客單 | 風險管理 |
```

### 平台策略

```
┌─────────────────────────────────────────────────────────────────┐
│  平台商業模式                                                   │
│                                                                 │
│  雙邊市場 (Two-Sided Market)                                    │
│                                                                 │
│  供給側                     平台                    需求側      │
│  ┌─────────┐           ┌──────────┐           ┌─────────┐      │
│  │ 賣家    │  ←─────→  │  撮合    │  ←─────→  │ 買家    │      │
│  │ 司機    │           │  信任    │           │ 乘客    │      │
│  │ 房東    │           │  支付    │           │ 房客    │      │
│  └─────────┘           └──────────┘           └─────────┘      │
│                                                                 │
│  關鍵挑戰：                                                     │
│  1. 雞生蛋問題（先有供給還是需求？）                            │
│  2. 網路效應培養                                                │
│  3. 供需平衡                                                    │
│  4. 品質控制                                                    │
└─────────────────────────────────────────────────────────────────┘
```

## 常見陷阱

| 陷阱 | 解決 |
|------|------|
| 模仿競爭者 | 專注創造獨特價值 |
| 只看數據不看人 | 實地觀察顧客行為 |
| 太多事情都想做 | 明確取捨，聚焦 |
| 假設顧客知道要什麼 | 測試驗證假設 |
| 忽略執行難度 | 評估組織能力 |

## 相關資源

- [Blue Ocean Strategy](https://www.blueoceanstrategy.com/)
- [Strategyzer (Business Model Canvas)](https://www.strategyzer.com/)
- [Playing to Win - A.G. Lafley](https://rogerlmartin.com/lets-read/playing-to-win)
- [Good Strategy Bad Strategy - Richard Rumelt](https://www.amazon.com/Good-Strategy-Bad-Difference-Matters/dp/0307886239)
