# Business Writing Anti-Patterns

> **Purpose**: Catch salesy language and corporate speak BEFORE sending
> **Principle**: If it wouldn't pass the "text to colleague" test, don't send it

---

## Category 1: Creepy Tracking References

### The Pattern
Mentioning you saw they opened/viewed the email.

### Examples

**❌ NEVER:**
- "I saw you opened the email 7 times..."
- "I noticed you viewed this yesterday..."
- "I see you clicked the link but didn't complete..."
- "Tracking shows you downloaded the attachment..."

**Why it fails:**
- Creepy surveillance vibes
- Makes recipient uncomfortable
- Destroys trust immediately
- Shows you're monitoring them

**✅ Instead:**
- Just send the follow-up
- No reference to tracking
- Respect their privacy

---

## Category 2: Corporate Throat-Clearing

### The Pattern
Unnecessary opening phrases that add no value.

### Examples

**❌ NEVER:**
- "I hope this email finds you well"
- "I trust you're doing well"
- "I hope you had a great weekend"
- "I wanted to reach out to you..."
- "I'm reaching out because..."
- "I wanted to circle back on..."
- "Just following up to see if..."
- "Just touching base about..."
- "I wanted to check in regarding..."

**Why it fails:**
- Wastes reader's time
- Signals low confidence
- Corporate speak (not human)
- Gets deleted before main point

**✅ Instead:**
- Start with the point
- "You good to start?"
- "Great talking this morning"
- Get to it immediately

---

## Category 3: Weak Permission-Asking

### The Pattern
Asking permission for things that don't need permission.

### Examples

**❌ NEVER:**
- "Would you be open to discussing..."
- "Would you have any interest in..."
- "Would it make sense to explore..."
- "Do you have 15 minutes to chat about..."
- "Would love to get on your calendar..."
- "Are you available for a quick call..."
- "Would you mind if I sent you..."

**Why it fails:**
- Weak positioning
- Gives easy "no" exit
- Sounds like you're asking for favor
- Debtor position (not creditor)

**✅ Instead:**
- Make direct offers: "Here's the link"
- Ask specific questions: "Free tomorrow 3-5 PM?"
- State what you'll do: "I'll send X"

---

## Category 4: Sales Enthusiasm Tells

### The Pattern
Over-the-top excitement that screams "salesperson."

### Examples

**❌ NEVER:**
- "I'm excited to share..."
- "We're thrilled to announce..."
- "I'd love to show you..."
- "We'd be delighted to..."
- "It would be our pleasure to..."
- "We're passionate about..."

**Why it fails:**
- Nobody talks like this
- Signals sales pitch incoming
- Inauthentic emotion
- Makes reader defensive

**✅ Instead:**
- Calm confidence: "Here's what we talked about"
- Simple statements: "This works for X"
- Actual emotion: "Loved the 'kitchen guy' positioning"

---

## Category 5: Verbose Value Props

### The Pattern
Over-explaining features, benefits, and value.

### Examples

**❌ NEVER:**

```
"Our industry-leading platform leverages cutting-edge AI technology
to provide best-in-class visualization capabilities that empower
contractors like yourself to deliver exceptional client experiences
while streamlining your workflow and maximizing ROI through our
comprehensive suite of tools..."
```

**Why it fails:**
- Too long (nobody reads it)
- Buzzword soup
- Features not benefits
- No clear point

**✅ Instead:**
- One benefit: "Close deals faster"
- Specific result: "2/10 → better"
- Proof: "8,800+ contractors"
- 10 words max

---

## Category 6: Hedging Language

### The Pattern
Undermining your own message with uncertainty.

### Examples

**❌ NEVER:**
- "I think this might be helpful..."
- "This could potentially solve..."
- "We believe this may work for..."
- "Perhaps we could explore..."
- "Possibly we can discuss..."
- "Maybe it makes sense to..."

**Why it fails:**
- Signals lack of confidence
- Makes reader doubt value
- Weak positioning
- Invites "no"

**✅ Instead:**
- Confident statements: "This solves X"
- Direct questions: "You good to start?"
- Clear offers: "Here's the link"

---

## Category 7: Vague Next Steps

### The Pattern
Unclear or optional actions.

### Examples

**❌ NEVER:**
- "Feel free to reach out if..."
- "Let me know if you'd like to discuss"
- "Happy to chat whenever works"
- "Don't hesitate to contact me"
- "I'm here if you have questions"
- "Reach out if you want to learn more"

**Why it fails:**
- No clear action
- Reader does nothing
- Deal dies
- Weak close

**✅ Instead:**
- Specific action: "Reply with your availability"
- Clear deadline: "Start by Friday"
- Direct ask: "You good to start?"
- Binary choice: "Payment now OR Nov 4 call"

---

## Category 8: Fake Urgency

### The Pattern
Creating urgency through pressure tactics.

### Examples

**❌ NEVER:**
- "This offer expires in 24 hours!"
- "Only 3 spots left!"
- "Limited time pricing!"
- "Act now before..."
- "Don't miss this opportunity!"
- "Time-sensitive offer inside!"

**Why it fails:**
- Obvious manipulation
- Destroys trust
- Signals desperation
- Makes offer seem weak

**✅ Instead:**
- Real deadlines: "Start by Sunday to lock Month 1 rate"
- Natural urgency: "Perfect timing with your Q4 push"
- Honest scarcity: "Two projects ahead of you this week"

---

## Category 9: Over-Apologizing

### The Pattern
Apologizing for normal business communication.

### Examples

**❌ NEVER:**
- "Sorry to bother you..."
- "Apologies for the follow-up..."
- "I know you're busy, but..."
- "Sorry for the long email..."
- "I hate to keep bugging you..."

**Why it fails:**
- Weak positioning
- Signals low value
- Makes reader feel guilty
- Undermines message

**✅ Instead:**
- No apology needed for valuable offers
- Respect their time through brevity
- Confidence: "Here's what you need"

---

## Category 10: Complex Sentence Structure

### The Pattern
Long, winding sentences with multiple clauses.

### Examples

**❌ NEVER:**

```
"Having reviewed the information that we discussed during our call,
and taking into consideration the various factors that you mentioned
regarding your business needs and requirements, I wanted to provide
you with a comprehensive overview of how our solution can address
those specific challenges while also delivering additional value
through our suite of complementary features..."
```

**Why it fails:**
- Too hard to parse
- Reader gives up
- Point gets lost
- Sounds robotic

**✅ Instead:**
- One idea per sentence
- Subject-verb-object
- 15 words or less
- "You good to start?"

---

## The Quick Scan Test

**Before sending, scan for these red flags:**

### Immediate Delete Signals
- [ ] Any sentence over 25 words?
- [ ] Using "I hope this finds you well"?
- [ ] Asking permission to help?
- [ ] Fake enthusiasm words ("excited", "thrilled")?
- [ ] Mentioning email opens/tracking?

### Warning Signals
- [ ] Email longer than 10 sentences?
- [ ] Over-explaining value?
- [ ] Hedging language ("maybe", "perhaps")?
- [ ] Vague next steps?
- [ ] Apologizing unnecessarily?

### Green Light Signals
- [x] 2-5 sentences total?
- [x] Direct question or offer?
- [x] One clear point?
- [x] One clear action?
- [x] Sounds like text message?

**If ANY delete signal → Rewrite**
**If 2+ warning signals → Simplify**
**If all green lights → Send**

---

## The Colleague Test

**Final check before sending:**

> "Would I text this exact message to a colleague I respect?"

**If yes** → Send it
**If no** → It's too formal, too long, or too salesy

**Remember:**
- Business emails ARE text messages (just slightly more complete)
- Colleagues get your best, clearest communication
- Customers deserve the same respect

---

## Recovery Examples

### Before/After Transformations

#### Example 1: Follow-Up

**❌ Before (162 words):**
```
Hi Gun,

I hope this email finds you well and that you had a great weekend.
I wanted to follow up on the Studio Plan proposal I sent over on
Friday regarding our conversation about Renovate AI.

I noticed you opened the email several times, so I wanted to make
sure you had all the information you needed to move forward. I'm
excited to potentially work with you and help transform how you
present renovation projects to your clients.

Would you be open to a quick 15-minute call this week to discuss
any questions you might have? I'd be happy to walk through the
features again or address any concerns.

Please don't hesitate to reach out if you need any additional
information. I'm here to help in any way I can.

Looking forward to hearing from you soon!

Best regards,
Sid
```

**✅ After (8 words):**
```
Hey Gun,

You good to start this week?

Let me know if anything's blocking you.

- Sid
```

**What changed:**
- 162 words → 8 words (95% reduction)
- Corporate speak → Human voice
- Vague ask → Direct question
- Weak position → CREDITOR confidence

#### Example 2: Pricing Offer

**❌ Before (247 words):**
```
Dear Mr. Baron,

Thank you so much for taking the time to meet with me and Sara this
morning. I truly enjoyed learning about YD Builders and the incredible
work you're doing in the kitchen and bathroom renovation space.

Based on our conversation, I believe Renovate AI would be an excellent
fit for your business needs. Our platform has helped over 8,800
contractors worldwide streamline their visualization process and close
more deals with homeowners.

I wanted to present you with a special early-access pricing opportunity
that I think you'll find very attractive. We're currently offering our
Studio Plan at a discounted rate for the first month...

[Continues for 2 more paragraphs]
```

**✅ After (89 words):**
```
Dan,

Great talking this morning. Loved the "I'm the kitchen guy" positioning - that specificity is powerful.

**Studio Plan for YD Builders:**
Month 1: $160
Month 2+: $199/mo

[Payment link]

Or, let's do a Nov 4 call to talk materials addon ($300/mo - integrate your vendor catalogs).

Either way works. Your call.

- Sid

P.S. - Sara, the 20/20 workflow fits your process perfectly.
```

**What changed:**
- 247 words → 89 words (64% reduction)
- Formal → Conversational
- One path → Two clear options
- Generic → Personalized (call callbacks)

---

## The Core Principle

> **"Every word you remove makes the remaining words more powerful."**

Anti-patterns exist because we think more words = more value.

Truth: Fewer words = more respect for reader's time = more likely to read = more likely to act.

**The math:**
- 200-word email = 5% read rate
- 50-word email = 60% read rate
- 8-word email = 95% read rate

Brevity isn't just style. It's strategy.

---

*"If you can't text it, don't email it."*
