# Sid's Business Writing Voice Guide

> **Source**: Writing/Craft + RAI B2B real emails + Books/Writing Tools
> **Purpose**: Codify Sid's actual voice patterns (not corporate templates)

---

## Core Voice Principles

### The Foundation

**From Books/Writing Tools:**
- Tool 1: Subject-verb structure (who does what)
- Tool 3: Active voice (not passive)
- Tool 11: Simple over technical (short words at complexity)

**From On Clear Writing:**
- Reduce before writing (answer 6 questions)
- One point per email
- Write for ONE person

**From Sid's B2B Practice:**
- Brief beats long (2-5 sentences ideal)
- Questions beat statements
- Human beats robotic
- Helpful beats pushy

---

## Length Guidelines

### The Ideal Range

**Most emails**: 2-5 sentences
**Complex offers**: 6-10 sentences (value stacks need space)
**Maximum ever**: 12 sentences (if longer, break into two emails)

### Why This Works

**Psychological reasons:**
- Shorter = higher read rate
- Shorter = faster decision
- Shorter = respects time
- Shorter = confidence signal

**Practical reasons:**
- Mobile-friendly (most read on phone)
- Scannable (can parse in 10 seconds)
- Actionable (clear what to do next)

### Length by Email Type

| Type | Sentence Count | Example |
|------|---------------|---------|
| Check-in | 2-4 | "You good? Let me know." |
| Follow-up | 3-5 | "Great talking. Here's link. Try Month 1." |
| Offer | 6-10 | Gun Belgium email |
| Objection | 4-7 | Address concern + solution |
| Professional | 3-4 | Meeting reschedule |

---

## Sentence Structure Patterns

### Tool 1: Subject-Verb Beginning

**Start with who does what.**

**✅ Good:**
- "You good to start?"
- "Steve will be live same day"
- "I'll create our WhatsApp group"
- "This solves X"

**❌ Bad:**
- "It would be great if you could..."
- "There might be an opportunity to..."
- "This could potentially help with..."

**The pattern**: [Subject] [verb] [object]. Direct. Clear.

### Tool 3: Active Voice Always

**Who performs the action? Put them first.**

**✅ Good:**
- "I'll handle the setup" (I = actor)
- "You'll close deals faster" (you = actor)
- "Steve uses it in field" (Steve = actor)

**❌ Bad:**
- "The setup will be handled" (passive, who?)
- "Deals can be closed faster" (passive, how?)
- "It can be used in field" (passive, by whom?)

**The test**: Can you add "by zombies" after the verb? If yes, it's passive. Rewrite.

### Tool 11: Simple Over Technical

**Short words at complexity.**

**✅ Good:**
- "blocking you" (not "impediments to progress")
- "You good?" (not "Are you prepared?")
- "Your call" (not "Whatever works best for you")
- "Let me know" (not "Please don't hesitate to reach out")

**The pattern**: If a 5th grader can't understand it, simplify it.

---

## Question Patterns (Sid's Signature)

### Why Questions > Statements

**Questions engage:**
- Force reader to think
- Create conversation
- Feel less pushy
- Get responses

### The Core Questions

**Check-in:**
- "You good?"
- "You good to start?"
- "You good to start this week?"

**Help offer:**
- "What's blocking you?"
- "Let me know if anything's blocking you"
- "What do you need?"

**Availability:**
- "Free tomorrow 3-5 PM?"
- "Work for you?"
- "Your call - payment now OR Nov 4?"

**Clarification:**
- "Which version resonates?"
- "Make sense?"
- "Questions?"

### Question Structure

**Pattern**: [Core question] [Simple close]

**✅ Good:**
```
You good to start?
Let me know if anything's blocking you.
```

**❌ Bad:**
```
I wanted to check in to see if you've had a chance to review
the proposal and if you might be ready to move forward, or if
there are any questions or concerns I can help address?
```

**The rule**: One question per sentence. Period after answer.

---

## Tone & Attitude Patterns

### Confident (Not Arrogant)

**Confidence signals:**
- Direct offers: "Here's the link"
- Clear statements: "This works for X"
- No hedging: "You'll see results" (not "might see")

**Humility signals:**
- "Your call" (respect their decision)
- "Let me know" (open door)
- "Either way works" (no pressure)

**The balance**: Confident in product, humble in approach.

### Helpful (Not Pushy)

**Helpful framing:**
- "What's blocking you?" (removing friction)
- "I'll handle X" (doing work for them)
- "Let me know if you need..." (available)

**Pushy framing (avoid):**
- "Have you had a chance to..." (guilt)
- "Just checking in again..." (desperate)
- "Following up on my last email..." (annoying)

**The test**: Am I offering value or asking for favor?

### Human (Not Robotic)

**Human voice:**
- "Great talking this morning"
- "Loved the 'kitchen guy' positioning"
- "Your call"
- Contractions: "You'll", "I'll", "Let's"

**Robotic voice (avoid):**
- "Thank you for your time"
- "I trust this finds you well"
- "Per our conversation"
- No contractions: "You will", "I will", "Let us"

**The test**: Would I say this out loud to them?

---

## Specific Phrase Patterns

### Opening Lines

**✅ Use these:**
- "Hey [Name]," (casual but professional)
- "[Name]," (ultra direct)
- "Great talking [timeframe]" (call callback)

**❌ Never use:**
- "Dear [Name]" (too formal)
- "Hi there" (too casual)
- "I hope this finds you well" (corporate throat-clearing)

### Transition Phrases

**✅ Use these:**
- "Here's what we talked about"
- "What stood out:"
- "Two paths:"

**❌ Never use:**
- "As discussed"
- "Per our conversation"
- "Further to our meeting"

### Closing Phrases

**✅ Use these:**
- "Let me know"
- "Your call"
- "Either way works"
- "- Sid" (just name, no "Best regards")

**❌ Never use:**
- "Best regards"
- "Sincerely"
- "Looking forward to hearing from you"
- "Thanks in advance"

### Call-to-Action Phrases

**✅ Direct:**
- "[Payment link]"
- "Reply with your availability"
- "Start by Friday"

**❌ Weak:**
- "Feel free to..."
- "Don't hesitate to..."
- "If you're interested..."

---

## Personalization Patterns

### Call Callbacks

**Reference specific details from conversation:**

**✅ Good:**
- "Loved the 'kitchen guy' positioning" (exact quote)
- "That 2/10 number" (their pain point)
- "5-7 projects/month" (their volume)

**Why it works:**
- Shows you listened
- Proves conversation was real
- Makes email unique (not template)

### Stakeholder Inclusion

**P.S. pattern for secondary stakeholders:**

**✅ Good:**
```
P.S. - Steve, you'll be live same day. iPad ready for next visit.
P.S. - Sara, the 20/20 workflow fits your process perfectly.
```

**Why it works:**
- Acknowledges everyone's role
- Addresses their specific concern
- Makes them feel included

### Personal Touch

**Add one human element:**

**✅ Good:**
- "Looking forward to making Belgium our European launch story"
- "Your specificity is powerful"
- "Perfect timing with your Q4 push"

**Why it works:**
- Not templated
- Shows genuine interest
- Creates connection

---

## Formatting Patterns

### White Space

**Use line breaks liberally:**

**✅ Good:**
```
Hey Gun,

You good to start this week?

Let me know if anything's blocking you.

- Sid
```

**❌ Bad:**
```
Hey Gun, You good to start this week? Let me know if
anything's blocking you. - Sid
```

**The rule**: One idea per paragraph. Visual breathing room.

### Bold for Emphasis

**Use sparingly for key info:**

**✅ Good:**
```
**Studio Plan:**
Month 1: $160
Month 2+: $199/mo
```

**❌ Bad:**
```
**Great** talking this **morning**. **Loved** the **"kitchen guy"**
positioning - that **specificity** is **powerful**.
```

**The rule**: Bold 3-5 words max. Structure or numbers only.

### Lists for Clarity

**Bullets for value stacks:**

**✅ Good:**
```
**What you get:**
- 5 team seats
- Unlimited renders
- WhatsApp support
```

**The rule**: Use for 3+ similar items. Not for narrative flow.

---

## Voice Checklist

**Before sending, verify:**

### Structure
- [ ] Subject-verb beginning? (Tool 1)
- [ ] Active voice throughout? (Tool 3)
- [ ] Simple words used? (Tool 11)
- [ ] 2-10 sentences total?
- [ ] One point, one action?

### Tone
- [ ] Questions used where possible?
- [ ] Confident but humble?
- [ ] Helpful not pushy?
- [ ] Human not robotic?
- [ ] Contractions included?

### Personalization
- [ ] Call callbacks included?
- [ ] Stakeholders addressed?
- [ ] One personal touch?

### Formatting
- [ ] White space between paragraphs?
- [ ] Bold used sparingly (if at all)?
- [ ] Lists for value stacks?

### Anti-Patterns
- [ ] No corporate throat-clearing?
- [ ] No sales enthusiasm?
- [ ] No hedging language?
- [ ] No vague CTAs?

**If all checked → Sounds like Sid**
**If any unchecked → Revise**

---

## The Ultimate Voice Test

**Read your email out loud.**

**Ask yourself:**
1. Would I say this to them in person?
2. Does this sound like me (Sid)?
3. Would I want to receive this?
4. Could I text this (with minor edits)?

**If yes to all 4 → Voice is right**
**If no to any → Rewrite**

---

## Voice Evolution Notes

**Sid's voice has evolved through:**
- 90-90-1 Writing Project (UNAPOLOGETIC principle)
- RAI B2B sales practice (real deals, real feedback)
- Writing Tools mastery (Tools 1, 3, 11)
- On Clear Writing framework (6 questions)

**The voice continues to evolve:**
- New patterns emerge from usage
- Better phrases discovered
- Tighter formulations found

**This guide updates based on what works.**

---

*"Write like you talk. Talk like you mean it. Mean what you say."*
