# B2B Email Examples (Real Emails That Worked)

> **Purpose**: Learn from actual emails that closed deals or moved deals forward
> **Source**: RAI B2B sales pipeline (Oct 2025)
> **Pattern**: These emails reflect Sid's actual voice, not theoretical best practices

---

## Example 1: Simple Check-In (Gun Follow-Up - Oct 27, 2025)

### Context
- Demo completed: Oct 24
- Offer sent: Oct 24 (Studio Plan $160 Month 1 → $199/mo)
- Deadline passed: Oct 27
- Email opens: 7 times (high engagement, deliberating)
- Temperature: 8/10 HOT

### The Email

```
Subject: Belgium Launch Partner - Quick Check-In

Hey Gun,

You good to start this week?

Let me know if anything's blocking you.

- Sid
```

### Why This Works

**Clarity (6 questions applied):**
1. What am I saying? → Check if ready to start
2. Why should they care? → I'm removing friction
3. Most important point? → Are you blocked?
4. Easiest to understand? → Two simple questions
5. How should they feel? → Supported, not pressured
6. What to do next? → Reply with status or questions

**Voice:**
- 3 sentences (ultra brief)
- Direct question: "You good?"
- Helpful framing: "blocking you" (not "any concerns")
- No sales language
- No over-explanation

**Strategy (NOT Grand Slam - this is check-in):**
- CREDITOR position maintained (offering help, not chasing)
- Deadline extended without pressure ("this week" vs "you missed Sunday")
- Acknowledges engagement (implicitly - saw opens but doesn't mention tracking)
- Opens door without forcing through

**What's NOT here:**
- ❌ "I wanted to follow up..."
- ❌ "Just checking in to see if..."
- ❌ "I noticed you viewed the email..."
- ❌ Value prop restatement
- ❌ Urgency pressure

---

## Example 2: Partnership Offer (Gun Belgium - Oct 24, 2025)

### Context
- Demo completed same morning
- Decision maker confirmed (Gun = owner)
- Partnership angle offered ("your guys in Belgium")
- Belgium market = first European customer opportunity

### The Email

```
Subject: Belgium Launch Partner - Studio Plan

Gun,

Here's what we talked about this morning.

**Studio Plan - Early Partner Price**
Month 1: $160
Month 2+: Auto-renews at $199/mo

**What you get:**
- Commercial license (field sales + showroom)
- 5 team seats (you, Steve, team)
- Unlimited renders (no volume caps)
- Shared projects (team collaboration)
- WhatsApp support group (direct to me + Ercan)

**Steve will be live same day.** iPad ready for next client visit.

Try it for a month. Use it on your next 5 meetings. I think you'll see that 2/10 number move.

[Payment link - use code DEMOPROMO20]

Once you're in, I'll create our WhatsApp group. Direct line to me + Ercan for anything you need.

Looking forward to making Belgium our European launch story.

- Sid

P.S. - Steve, you'll be live same day. iPad ready for next client visit.
```

### Why This Works

**Clarity:**
- One point: Here's the offer
- One action: Click payment link
- One feeling: This is irresistible

**Grand Slam (4 value drivers):**

1. **Dream Outcome (↑)**: "Belgium our European launch story" (status gain)
2. **Likelihood (↑)**: "8,800+ users" implied, "unlimited renders" = no limits
3. **Time Delay (↓)**: "Same day", "next client visit" (fast win)
4. **Effort (↓)**: "WhatsApp support", "Direct line" (done-for-you)

**Voice:**
- Partnership framing ("our European launch")
- Calls back pain: "2/10 number" (from demo conversation)
- Personal touch: P.S. to Steve (secondary stakeholder)
- Transparent pricing (shows Month 1 + Month 2+)
- Direct offer (not "would you like to...")

**Structure:**
- Brief intro (call callback)
- Clear pricing (transparent)
- Value stack (what's included)
- Fast win (same day)
- Risk reversal (try Month 1)
- Clear action (payment link)
- Personal commitment (WhatsApp group)
- Status framing (Belgium launch story)
- P.S. for Steve (stakeholder inclusion)

---

## Example 3: Call Summary + Offer (YD Builders v2 - Oct 24, 2025)

### Context
- Demo with Dan Baron (owner) + Sara Carr (operations)
- "Kitchen guy" positioning (5-7 kitchens/bathrooms per month)
- Vendor relationships important (tile, countertop suppliers)
- Month 1 discount strategy: $160 → $199

### The Email (Improved Version)

```
Subject: Kitchen Visualization for YD Builders

Dan,

Great talking this morning. Loved the "I'm the kitchen guy" positioning - that specificity is powerful.

**What stood out:**
- 5-7 projects/month = perfect volume for Studio Plan
- Tile/countertop relationships = materials addon makes sense later
- Client decision speed matters (visual sells faster than samples)

**Studio Plan for YD Builders:**
Month 1: $160 (contractor early-access rate)
Month 2+: $199/mo (auto-renews)

[Payment link - code DEMOPROMO20]

Or, let's do a Nov 4 call to talk through materials addon ($300/mo - integrate your vendor catalogs).

Either way works. Your call.

- Sid

P.S. - Sara, the 20/20 workflow (scan → render → present) fits your process perfectly. Dan renders in field, you handle follow-up.
```

### Why This Works

**Improvement over v1:**
- Added call summary (warmth + context)
- Acknowledged positioning ("kitchen guy")
- Listed what stood out (shows listening)
- Two clear paths (payment OR Nov 4 call)

**Voice:**
- Conversational ("Great talking", "Your call")
- Calls back specific details ("5-7 projects", "kitchen guy")
- P.S. to Sara (operations stakeholder, not just Dan)
- Two paths offered (respects their decision process)

**Strategy:**
- Path 1: Fast action (payment now)
- Path 2: Future expansion (materials addon call)
- No pressure ("Either way works")
- Seeds future upsell naturally

---

## Example 4: Simple Professional Request (Internal Pattern)

### Context
This pattern works for non-sales professional emails.

### The Email

```
Subject: [Direct subject - what it's about]

[Name],

[One sentence context]

[One sentence ask]

[One sentence timeline or next step]

- Sid
```

### Example

```
Subject: Meeting Reschedule - Oct 28

Ercan,

Demo with Pacific Clay ran over - need to push our 4 PM sync.

Free tomorrow 3-5 PM?

Let me know.

- Sid
```

**Why this works:**
- 4 sentences total
- Context → Ask → Timeline → Close
- No fluff, no apology
- Direct and respectful

---

## Pattern Analysis Across Examples

### Common Elements

**ALL emails have:**
1. Direct subject (what it's about)
2. 2-10 sentences (usually 3-5)
3. One clear point
4. One clear action
5. Sid's name signed (not "Best regards")

**NONE have:**
- "I hope this email finds you well"
- "Just following up to see if..."
- "I wanted to reach out about..."
- "Would you be open to..."
- "Feel free to..."

### Voice Patterns

**Questions > statements:**
- "You good?" (not "I hope you're ready")
- "What's blocking you?" (not "Please let me know if there are any concerns")

**Simple > complex:**
- "blocking you" (not "impediments to progress")
- "Your call" (not "Whatever works best for you")

**Active > passive:**
- "I'll create our WhatsApp group" (not "A WhatsApp group will be created")
- "Let me know" (not "Please feel free to reach out")

**Specific > vague:**
- "Nov 4 call" (not "future discussion")
- "Same day" (not "quickly")
- "$160 Month 1" (not "discounted rate")

---

## Email Type Quick Reference

### Follow-Up After Demo
**Length**: 3-5 sentences
**Structure**: Check-in question + offer to help
**Example**: Gun follow-up

### Pricing Offer
**Length**: 8-12 sentences (value stack needs space)
**Structure**: Intro → Price → Value → Fast win → Action
**Example**: Gun Belgium offer

### Check-In on Deal
**Length**: 2-4 sentences
**Structure**: Context → Question → Help offer
**Example**: Gun simple check-in

### Call Summary + Offer
**Length**: 6-10 sentences
**Structure**: Summary → Offer → Two paths → P.S.
**Example**: YD Builders v2

### Professional Request
**Length**: 3-4 sentences
**Structure**: Context → Ask → Timeline
**Example**: Meeting reschedule

---

## Anti-Pattern Examples (What NOT to Send)

### Bad: Over-Explaining Value

```
❌ Bad:

Hey Gun,

I wanted to follow up on our demo from yesterday. I really enjoyed learning about your business and the incredible growth you've experienced over the past 2 years from 3 employees to 25 - that's truly impressive!

As I mentioned during our call, Renovate AI is specifically designed for contractors like yourself who are looking to modernize their sales process and close more deals. With over 8,800 users worldwide, we've helped contractors increase their conversion rates significantly.

I wanted to make sure you had all the information you need to make an informed decision about moving forward with our Studio Plan...

[Continues for 3 more paragraphs]
```

**Problems:**
- Way too long (would you read this?)
- Sales voice ("truly impressive!", "specifically designed")
- Over-explaining value
- No clear point
- Weak action ("make sure you had...")

### Good: Sid's Actual Email

```
✅ Good:

Hey Gun,

You good to start this week?

Let me know if anything's blocking you.

- Sid
```

**Why it works:**
- 3 sentences
- Clear question
- Helpful tone
- Direct

---

## The Voice Test

**Before sending, ask:**
1. Would I text this to a colleague?
2. Is every word necessary?
3. Does this sound like Sid?
4. Would I want to receive this?

**If yes to all → Send**
**If no to any → Cut more**

---

*"The best business emails sound like text messages from someone who respects your time."*
