# Clear Writing Framework

> **Source**: On Clear Writing (Logseq secondbrain)
> **Core principle**: "Every writing project must be reduced before you start"

---

## The 6 Questions (Answer BEFORE Writing)

### 1. What Am I Really Trying To Say?

Strip away decoration and get to the core message. What's the actual point?

**Bad**: "I wanted to reach out and touch base about potentially exploring whether we might be able to discuss..."
**Good**: "Want to schedule a call?"

### 2. Why Should People Care?

What's in it for them? Not what you want to say, but why they should listen.

**Bad**: "Our new feature improves productivity by 40%"
**Good**: "You'll close deals faster" (they care about results, not features)

### 3. What Is The Most Important Point?

Every successful piece leaves the reader with ONE provocative thought they didn't have before.

**Rule**: One email = one point. If you have 3 points, write 3 emails.

### 4. What Is The Easiest Way To Understand The Most Important Point?

Simplicity beats cleverness. Short words at complexity.

**Bad**: "This will facilitate the optimization of your workflow"
**Good**: "This makes your work faster"

### 5. How Do I Want The Reader To Feel?

Emotion drives action. Pick one feeling to create.

**Options**:
- Confident (they can do this)
- Curious (want to learn more)
- Urgent (act now)
- Valued (you care about them)

### 6. What Should The Reader Do Next?

One clear action. Remove all ambiguity.

**Bad**: "Feel free to reach out if you'd like to discuss"
**Good**: "Reply with your availability this week"

---

## The Reduction Principle

**Tolstoy couldn't write a book about war and peace.**

He made reductive decisions: one man pursuing one whale, specific time and place.

**Every writing project must be reduced before you start.**

For business emails:
- One topic (not three)
- One ask (not multiple paths)
- One feeling (not mixed messages)

---

## Pre-Writing Questions (Capacity & Style)

Before writing, decide:

### Capacity
**"In what capacity am I addressing them?"**
- Peer? Expert? Helper? Partner?
- Choose one. Stick to it.

### Pronoun & Tense
**"What pronoun am I using?"**
- You/I (personal)
- We (partnership)
- Pick one voice.

### Style
**"What style fits this context?"**
- Personal and casual (most B2B emails)
- Personal but formal (enterprise sales)
- Impersonal reportorial (status updates)

### Attitude
**"What attitude toward material?"**
- Confident (most sales)
- Helpful (follow-ups)
- Curious (discovery)
- Direct (check-ins)

---

## The One Provocative Thought Rule

**Every successful email should leave the reader with one thought they didn't have before.**

**Bad email**: Restates what they already know
**Good email**: Introduces one new insight, perspective, or action

**Examples**:
- "You could be live by Friday" (time reframe)
- "Your Belgium launch story" (status reframe)
- "2/10 close rate → better" (pain reframe)

---

## Application to Business Emails

### Follow-up After Demo
**Reduce to**: Did demo work? What's blocking you?
**One point**: Remove friction to start
**Reader feels**: Confident they can proceed
**Action**: Reply with start date or questions

### Pricing Offer
**Reduce to**: Here's what you get, here's the price
**One point**: This offer is irresistible
**Reader feels**: Stupid to say no
**Action**: Click payment link

### Check-in on Deal
**Reduce to**: Are you good?
**One point**: I'm here if you need help
**Reader feels**: Supported, not pressured
**Action**: Reply with status or questions

---

## Key Phrases That Signal Reduction Working

**Reduced emails use:**
- "You good?"
- "What's blocking you?"
- "Reply with X"
- "Let me know if Y"

**Unreduced emails use:**
- "I wanted to circle back..."
- "Just following up to see if..."
- "Would you be open to discussing..."
- "I'm reaching out because..."

---

## The Brackish Prose Principle

> **"Like water, writing comes alive at the extremes. Avoid brackish prose."**

**Brackish**: Neither salt nor fresh, tepid middle ground

**Extremes that work:**
- Ultra brief (2 sentences)
- Deeply personal (write to one person)
- Completely direct ("You good to start?")
- Absolutely clear (one point, one action)

**Brackish that fails:**
- "Professional" corporate speak
- Hedging language ("perhaps", "possibly")
- Permission asking ("would you be open to")
- Vague actions ("feel free to reach out")

---

## Quick Reference Checklist

Before sending any business email, check:

- [ ] Answered all 6 questions?
- [ ] Reduced to one point?
- [ ] Reader knows exactly what to do next?
- [ ] Chose capacity, pronoun, style, attitude?
- [ ] One provocative thought included?
- [ ] Avoided brackish middle ground?

**If yes to all → Send**
**If no to any → Reduce further**

---

*"Nobody can write about something. Make reductive decisions. One point. One action. One thought."*
