---
name: Campaign Analyzer
slug: campaign-analyzer
description: Analyze marketing campaign performance and extract actionable insights
category: marketing
complexity: intermediate
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "campaign analysis"
  - "campaign performance"
  - "marketing metrics"
  - "campaign report"
  - "marketing ROI"
tags:
  - analytics
  - campaign-management
  - performance-marketing
  - reporting
  - metrics
---

# Campaign Analyzer

Turn marketing data into actionable insights that improve campaign performance. This skill helps you systematically analyze campaigns across channels, identify what's working, diagnose what's not, and make data-driven optimization decisions.

Raw metrics don't tell stories - this skill helps you find the narrative in your data. From awareness campaigns to lead generation to e-commerce, learn to measure what matters, benchmark against industry standards, and present findings that drive better marketing decisions.

Built for marketing managers, performance marketers, analysts, and anyone responsible for demonstrating marketing impact and improving results.

## Core Workflows

### Workflow 1: Campaign Performance Review
1. **Goal Alignment** - Compare results to objectives
2. **KPI Dashboard** - Track primary and secondary metrics
3. **Funnel Analysis** - Identify conversion bottlenecks
4. **Channel Attribution** - Understand contribution by source
5. **Spend Efficiency** - Calculate cost metrics (CPM, CPC, CPA, ROAS)
6. **Audience Performance** - Segment by demographic/behavior
7. **Creative Analysis** - Identify top-performing assets
8. **Recommendation Synthesis** - Actionable next steps

### Workflow 2: Multi-Channel Analysis
1. **Channel Mapping** - All touchpoints in customer journey
2. **Attribution Modeling** - First touch, last touch, multi-touch
3. **Cross-Channel Synergies** - How channels work together
4. **Budget Allocation Review** - Spend vs performance by channel
5. **Audience Overlap** - Reach and frequency across channels
6. **Journey Mapping** - Path to conversion analysis
7. **Optimization Recommendations** - Reallocation suggestions

### Workflow 3: Creative Performance Analysis
1. **Asset Inventory** - All creative variations tested
2. **Performance Ranking** - Best to worst performers
3. **Element Analysis** - What elements drive performance
4. **Format Comparison** - Static vs video vs carousel
5. **Message Testing** - Which value props resonate
6. **Creative Fatigue** - Performance over time
7. **Learning Documentation** - Insights for future creative

### Workflow 4: ROI & Attribution Analysis
1. **Revenue Attribution** - Connect marketing to revenue
2. **Customer Acquisition Cost** - Fully-loaded CAC calculation
3. **Lifetime Value Analysis** - LTV by acquisition channel
4. **ROAS Calculation** - Return on ad spend by campaign
5. **Payback Period** - Time to recoup acquisition cost
6. **Incrementality Testing** - True marketing impact
7. **Budget Optimization Model** - Optimal allocation recommendations

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Campaign review | "Analyze performance of [campaign name]" |
| Channel comparison | "Compare performance across [channels]" |
| ROI calculation | "Calculate ROI for [marketing initiative]" |
| Creative analysis | "Identify top performing creative" |
| Funnel analysis | "Find conversion bottlenecks" |
| Spend optimization | "Recommend budget reallocation" |
| Attribution review | "Analyze attribution for [campaign]" |
| Executive summary | "Create executive summary of [campaign results]" |

## Best Practices

- **Start with goals** - Analysis serves objectives, not vanity
- **Define success upfront** - Benchmarks before launch
- **Segment everything** - Aggregate data hides insights
- **Compare apples to apples** - Normalize for meaningful comparison
- **Look for patterns** - Single data points mislead
- **Context matters** - Seasonality, competition, market conditions
- **Attribution is imperfect** - Acknowledge model limitations
- **Focus on actionable** - Insights must lead to actions
- **Trend over point-in-time** - Direction matters more than absolute
- **Test before scaling** - Validate before major spend shifts
- **Document learnings** - Build institutional knowledge
- **Automate reporting** - Spend time on analysis, not data pulling
- **Visualize effectively** - Charts that tell stories
- **Executive vs detailed** - Right depth for right audience
- **Lead with recommendations** - What should we do differently?
