# Audience Archetypes & Awareness Levels

## Audience Archetypes

### 1. Heart Patients (Secondary Prevention)
**Profile**: Post-MI, post-stent, or bypass patients
**Core Focus**: Statins, secondary prevention, medication adherence, lifestyle modifications
**Content Needs**: 
- Medication management and adherence
- Lifestyle changes post-event
- Warning signs and when to seek help
- Recovery milestones
- Long-term prevention strategies
**Tone**: Reassuring, evidence-based, empowering
**Example Topics**: "How to stick with your statin regimen", "5 warning signs after stent placement", "Your first 90 days after a heart attack"

### 2. Lifestyle Disease Group (Diabetes, MetS, Hypertension)
**Profile**: People with metabolic syndrome and cardiometabolic overlap
**Core Focus**: Primary prevention, insulin resistance, risk stratification
**Content Needs**:
- Understanding disease interconnections
- Risk assessment and monitoring
- Lifestyle interventions
- Medication rationale
- Prevention strategies
**Tone**: Educational, motivating, practical
**Example Topics**: "The diabetes-heart disease connection explained", "Why your A1C matters for your heart", "Reversing insulin resistance: a cardiologist's guide"

### 3. Proactive Health Optimizers (Biohackers)
**Profile**: Self-trackers, longevity enthusiasts, early adopters
**Core Focus**: ApoB, diet debates, supplements, CAC/Lp(a) monitoring, advanced biomarkers
**Content Needs**:
- Advanced testing and interpretation
- Cutting-edge prevention strategies
- Biomarker optimization
- Evidence on supplements/interventions
- Personalized risk assessment
**Tone**: Scientific, nuanced, data-driven
**Example Topics**: "ApoB vs LDL-C: what the evidence actually shows", "Should you get a CAC score in your 30s?", "The Lp(a) controversy: what we know in 2024"

### 4. Health Enthusiasts (General Public)
**Profile**: Educated laypersons seeking evidence-based clarity
**Core Focus**: Awareness, myth-busting, general education, prevention basics
**Content Needs**:
- Foundational knowledge
- Myth-busting common misconceptions
- Understanding risk factors
- When to see a doctor
- Preventive lifestyle changes
**Tone**: Accessible, clear, authoritative
**Example Topics**: "5 heart health myths debunked", "Understanding your cholesterol numbers", "What your blood pressure really means"

### 5. Caregivers of Heart Patients
**Profile**: Family members emotionally involved in a patient's care
**Core Focus**: Family screening, genetic counseling, prevention for relatives, supporting recovery
**Content Needs**:
- How to support their loved one
- Family risk assessment
- Genetic considerations
- Practical caregiving guidance
- Emotional support strategies
**Tone**: Empathetic, supportive, actionable
**Example Topics**: "How to help your spouse recover from a heart attack", "Should your family get screened?", "Genetic testing for heart disease: a family guide"

### 6. Young & Anxious (<50 years)
**Profile**: Young professionals with high anxiety about heart disease
**Core Focus**: Early screening, stress management, risk communication, health anxiety
**Content Needs**:
- Age-appropriate risk assessment
- When to worry vs. when to relax
- Stress and heart health
- Prevention in younger years
- Interpreting symptoms
**Tone**: Balanced, reassuring, evidence-based
**Example Topics**: "Should you worry about heart disease in your 30s?", "Chest pain at 35: when to see a cardiologist", "How stress actually affects your heart"

## Awareness Levels (Eugene Schwartz Framework)

### Unaware
**State**: Not conscious of having a problem or need
**Content Approach**: Educate and reveal the problem's existence/impact
**Example**: "Silent killers: 5 heart disease risk factors you're ignoring"
**Goal**: Make them recognize what's at stake

### Problem Aware
**State**: Realize they have a problem, but don't know solutions exist
**Content Approach**: Emphasize pain points, elaborate challenges, agitate discomfort
**Example**: "Why high cholesterol is scarier than you think (and what most doctors miss)"
**Goal**: Make them eager for a resolution

### Solution Aware
**State**: Know solutions exist but unsure which is best
**Content Approach**: Demonstrate why particular solutions work via USPs, evidence, case studies
**Example**: "Statins vs PCSK9 inhibitors: which cholesterol medication is right for you?"
**Goal**: Guide them to the right solution category

### Product Aware
**State**: Know about possible solutions and your specific offering/approach
**Content Approach**: Show what sets your approach apart, address objections
**Example**: "Why I prescribe statins differently than other cardiologists (and the data behind it)"
**Goal**: Move them closer to adopting your recommendations

### Most Aware
**State**: Fully informed, need final nudge
**Content Approach**: Facilitate action, offer incentives, provide clear CTAs
**Example**: "Ready to start optimizing your heart health? Here's your first step"
**Goal**: Convert intention to action

## Matching Content to Audience & Awareness

**Not every piece works for all archetypes or awareness levels. Consider:**

1. **Does this topic matter to this archetype?**
   - Don't write about ApoB optimization for Problem Aware audiences
   - Don't write about post-MI recovery for Biohackers (unless they've had an MI)

2. **Is the awareness level appropriate?**
   - Don't assume Unaware readers understand medical terminology
   - Don't over-explain basics to Most Aware audiences

3. **Natural fit test:**
   - "Would a [archetype] at [awareness level] genuinely want to read this?"
   - If you're forcing it to "check the box," skip it

4. **Quality over quantity:**
   - Better to create 3 excellent pieces for the right audience than 18 mediocre pieces checking boxes
