# Content Format Specifications

## Short Newspaper Articles (Inshorts Style)

**Specs**:
- <400 characters total
- <60 words
- Title <55 characters
- Formal language
- Running paragraph format (no bullets)
- Capture most important points

**Approach**:
- Create multiple from source (all possible angles)
- Tailor to archetypes/modifiers where fitting
- Prioritize clinical relevance

**Output Format**:
```
1. [Title]
[Body paragraph]

2. [Title]
[Body paragraph]
```

## Atomic Essays

**Specs**:
- 600-700 characters max (1000 if interrelated points can't be omitted)
- Engaging, essay-style with hook, body, close
- Explore angles deeply
- Hooky title

**Approach**:
- Multiple from source
- Use 4A framework for different angles
- Apply content modifiers (tips, stats, stories, etc.)

**Output Format**:
```
1. [Hooky Title]
[Essay body with hook → insight → close]

2. [Hooky Title]
[Essay body with hook → insight → close]
```

## Tweets (Single)

**Specs**:
- 280 characters maximum
- Punchy and engaging
- Strong hook
- Thought leadership content (not random lines)

**Approach**:
- Use angles, archetypes, modifiers
- Apply headline formulas (X Ways, X Mistakes, etc.)
- Each tweet should stand alone

**Output Format**:
```
1. [Tweet text]

2. [Tweet text]

3. [Tweet text]
```

## Twitter Threads

**Specs**:
- 4-12 tweets each
- First tweet: strong hook answering WHO/WHAT/WHY
- Building narrative through middle
- Call-to-action/strong end last

**Structure Options**:
- **Story Thread**: High-drama opening → suspense → moral/lesson
- **Framework Thread**: Hook → each part of framework → CTA
- **Actionable Thread**: Hook → step-by-step → closing inspiration

**Formatting Requirements**:
- One idea per tweet (1-2 sentences max)
- Use skimmability rhythms (1/3/1, 1/5/1, etc.)
- Lists and bullets where appropriate
- Rate of revelation: every tweet teaches something new

**Output Format**:
```
Thread 1: [Title/Theme]
• Tweet 1 (Hook): [Text]
• Tweet 2: [Text]
• Tweet 3: [Text]
• Tweet 4: [Text]
• Tweet 5 (CTA): [Text]

Thread 2: [Title/Theme]
• Tweet 1 (Hook): [Text]
...
```

## Blogs (Medium-Style)

**Specs**:
- 800-2000 words
- In-depth with sections, hooks, stories
- Multiple if source yields distinct angles
- Well-referenced with citations

**Critical Requirement**:
If source is transcript/script (not well-referenced newsletter/knowledge base), use PubMed to back up facts and return a well-referenced long-form article.

**Structure**:
- Compelling title
- Hook introduction (personal anecdote or startling fact)
- Body sections with subheadings
- Clinical stories/examples throughout
- Evidence-based conclusions
- Clear takeaways/action items

**Output Format**:
```
Blog 1: [Title]

[Introduction with hook]

## [Section 1 Heading]
[Content with citations where needed]

## [Section 2 Heading]
[Content with citations where needed]

## [Section 3 Heading]
[Content with citations where needed]

[Conclusion with takeaways]

---

Blog 2: [Title]
...
```

## Citation Requirements for Blogs

When source material is transcript/script without references:

1. Identify factual claims that need backing
2. Use PubMed search to find supporting evidence
3. Cite studies with: [Study Name, Journal Year] or similar format
4. Focus on high-quality evidence (RCTs, meta-analyses, major trials)
5. Weave citations naturally into narrative

Example citation style:
"Recent data from the FOURIER trial showed that PCSK9 inhibitors reduced cardiovascular events by 15% in high-risk patients."
