# Content Modifiers & Voice Guidelines

## 10 Content Angle Modifiers

Use these to multiply variations and view content from different angles:

### 1. Tips
**What**: Actionable advice readers can implement immediately
**Format**: Brief, practical, specific
**Example**: "Tip: Take your statin before bed to minimize muscle soreness"
**Best for**: Actionable content, quick wins

### 2. Stats
**What**: Data, numbers, trial results, percentages, patient outcomes
**Format**: Lead with the number, follow with interpretation
**Example**: "In the FOURIER trial, PCSK9 inhibitors reduced cardiovascular events by 15%"
**Best for**: Analytical content, building credibility

### 3. Steps
**What**: Process breakdown showing how to do something
**Format**: Numbered sequence, linear progression
**Example**: "Step 1: Get baseline labs. Step 2: Start low-dose statin. Step 3: Recheck in 6 weeks."
**Best for**: How-to content, patient education

### 4. Lessons
**What**: What you learned from clinical experience
**Format**: Personal insight from practice
**Example**: "Lesson: Most statin side effects resolve within 2 weeks if patients push through"
**Best for**: Aspirational content, building trust

### 5. Examples
**What**: Specific patient cases or scenarios (de-identified)
**Format**: Brief case vignette with outcome
**Example**: "I had a 52-year-old patient with Lp(a) of 180 who..."
**Best for**: Story threads, making abstract concepts concrete

### 6. Reasons
**What**: Logical explanations (the WHY behind recommendations)
**Format**: "Because" statements, mechanism explanations
**Example**: "We use statins because they reduce LDL production in the liver by inhibiting HMG-CoA reductase"
**Best for**: Anthropological content, deeper understanding

### 7. Mistakes
**What**: What patients commonly get wrong
**Format**: "Don't do X" or "Avoid Y"
**Example**: "Mistake: Stopping your statin because you feel fine"
**Best for**: Problem-aware content, myth-busting

### 8. Questions
**What**: Thought-provoking queries patients should ask
**Format**: Question prompts for self-reflection or doctor visits
**Example**: "Are you asking your doctor about ApoB or just LDL-C?"
**Best for**: Engagement, empowering patients

### 9. Stories
**What**: Real clinical narratives with beginning, middle, end
**Format**: Patient journey or case arc
**Example**: "Last month, a 45-year-old tech exec came to my clinic convinced he was having a heart attack..."
**Best for**: Aspirational threads, humanizing medicine

### 10. Benefits
**What**: Concrete outcomes patients can expect
**Format**: Results-focused statements
**Example**: "Benefit: Statins reduce your risk of a second heart attack by up to 40%"
**Best for**: Most-aware content, conversion

## Anti-AI Writing Guidelines

### First-Person Clinical Voice
✅ **Do**: "In my clinic, I see patients make this mistake constantly"
❌ **Avoid**: "Patients often make this mistake" (sounds generic)

✅ **Do**: "After 15 years treating heart patients, here's what I've learned"
❌ **Avoid**: "Studies show that" (unless citing specific study)

✅ **Do**: "Last week, I had a patient who..."
❌ **Avoid**: "One common scenario is..." (too generic)

### Natural Sentence Variation
✅ **Do**: Mix short punchy sentences with longer, more complex ones. Vary your rhythm. Like this.
❌ **Avoid**: Every sentence being the same length. Every sentence following the same structure. Every sentence sounding robotic.

✅ **Do**: "Statins work. They've been proven in hundreds of trials. But here's what most doctors don't tell you about side effects."
❌ **Avoid**: "Statins are effective medications. They have been validated through extensive research. However, side effect management requires consideration."

### Eliminating AI Tells

#### Em Dashes
❌ **Never use**: "Statins lower cholesterol—but they do much more than that—they reduce inflammation."
✅ **Use instead**: "Statins lower cholesterol, but they do much more than that. They reduce inflammation."

#### Robotic Transitions
❌ **Avoid**: "Additionally, furthermore, moreover, in conclusion"
✅ **Use instead**: "Also," "And," "But here's the thing," "Look,"

#### Hedge Words (use sparingly)
❌ **Overuse**: "It's important to note that..." "Studies suggest that..." "Research indicates..."
✅ **Direct**: "Here's what matters:" "The data shows:" "We know that:"

### Conversational Yet Professional

✅ **Do**: "Look, I get it. Taking pills daily isn't fun."
❌ **Avoid**: "It is understandable that daily medication adherence presents challenges."

✅ **Do**: "Here's the truth most cardiologists won't tell you:"
❌ **Avoid**: "There exists information that may not be commonly disclosed:"

✅ **Do**: "This is where things get interesting."
❌ **Avoid**: "At this juncture, noteworthy observations emerge."

### Show, Don't Tell Expertise

✅ **Do**: "When I order a CAC score for my patients, I'm looking for specific thresholds: 0 is perfect, 1-99 needs lifestyle changes, 100-399 often needs medication, 400+ requires aggressive intervention."
❌ **Avoid**: "CAC scores are an important diagnostic tool that can help assess cardiovascular risk."

✅ **Do**: "I've seen this pattern in my clinic: patients with family history of early MI often have elevated Lp(a), even when their LDL looks perfect."
❌ **Avoid**: "There is an association between family history and Lp(a) levels."

### Specific Over Generic

✅ **Do**: "In the IMPROVE-IT trial, adding ezetimibe to statins reduced cardiovascular events by 6.4% over 7 years."
❌ **Avoid**: "Combination therapy has been shown to be beneficial."

✅ **Do**: "For my post-MI patients, I target LDL below 55 mg/dL based on 2018 ESC guidelines."
❌ **Avoid**: "Lower LDL targets are recommended for high-risk patients."

## Writing Quality Checklist

Before publishing any content, verify:

- [ ] Written in first-person where appropriate ("In my practice...")
- [ ] Sentences vary in length and structure
- [ ] Zero em dashes (or only 1-2 if absolutely essential)
- [ ] Conversational tone without being unprofessional
- [ ] Specific examples/data instead of vague statements
- [ ] Clinical judgment and expertise evident
- [ ] Natural transitions, not robotic
- [ ] Avoids AI hedge words and filler
- [ ] Sounds like a real cardiologist, not a content mill
- [ ] Not dumbed down—respects reader intelligence
