# Twitter Thread Writing Frameworks

## The 4A Framework

### Actionable – "Teach me how"
- Teach concrete outcomes with steps/templates/checklists
- Organize as Steps ("Step 1… Step 2…") or How-To lists
- Stay specific to increase credibility
- Example: "7 steps to manage cholesterol after your first heart attack"

### Analytical – "Show me the numbers"
- Lead with compelling stats, then present interpretation
- Pair with "Lessons/Mistakes/Case-study" containers
- Example: "43% of post-MI patients stop statins within 1 year — what the data reveals"

### Aspirational – "Make me believe"
- Motivate through before/after arcs
- Use personal stories or curate others' stories
- End with clear, transferrable takeaways
- Example: "How I helped my patient reverse pre-diabetes in 90 days"

### Anthropological – "Explain the real why"
- Reveal hidden causes behind behaviors
- Reframe mental models by surfacing underlying mechanisms
- Example: "Why patients fear statins — the psychology behind medication anxiety"

## Thread Structures

### Story Threads
- Begin with high-drama opening
- Maintain suspense with short tweets
- End with moral/lesson mapping back to opening
- Flow: Hook → Rising action → Resolution + Lesson

### Framework Threads
- Organize around repeatable structure
- Each tweet = one part of framework
- Flow: Hook explaining framework → Component 1 → Component 2 → Component 3 → CTA

### Actionable Threads
- Deliver step-by-step playbook
- Each tweet is a command, tip, or step
- Flow: Hook with promise → Step 1 → Step 2 → Step 3 → Close with encouragement

## Formatting Rules

### One Idea Per Tweet
- Don't cram multiple points
- 1–2 sentences max per tweet = best readability

### Skimmability Rhythms
- **1/3/1**: Hook → 3 supporting sentences → punchline
- **1/5/1**: Hook → 5 bullets/examples → summary
- **1/2/5/2/1**: Hook → 2 context → 5 items → 2 takeaways → 1 punch

### Lists & Bullets
- Use for chunked, scannable information
- Example: "5 misconceptions about blood pressure medications:"

### Rate of Revelation
- Every tweet must add new value
- Readers stay when each tweet teaches/entertains
- No filler sentences

## Hook Templates (First Tweet)

Must answer:
1. What is this about?
2. Who is this for?
3. Why should I care?

### Proven Formats:
- "X Ways To Do Y" (e.g., "7 ways to lower your heart disease risk")
- "X Mistakes To Avoid" (e.g., "5 statin myths that could cost you your life")
- "X Lessons Learned From Y" (e.g., "10 lessons from 15 years treating heart patients")
- "Why Everyone Gets This Wrong About X"
- "The Secret To [Outcome]"
- "What I Wish [Audience] Knew About X"
- "The Surprising Truth About X"

## Closing the Thread

Always end with:
- Summary of key insight
- Call-to-action:
  - Invite discussion ("Which step will you start with?")
  - Encourage share ("If this helped, share with someone at risk")
  - Offer more ("Follow for evidence-based cardiology insights")
