# Twitter Writing Guide

## The 4A Framework – Core Content Paths

### Actionable – "Here's how"
Teach concrete outcomes with steps/templates/checklists.
- Organize as Steps or How-To lists for instant skimmability
- Stay specific to increase credibility
- Examples: "7 steps to lower LDL after a heart attack" / "How to talk to your cardiologist about statin side effects"

### Analytical – "Show me the numbers"
Start from data/trends/stats, then present interpretation.
- Lead with compelling stat, then extract insights
- Examples: "43% of post-MI patients stop statins within 6 months — what that means" / "New ASCVD calculator changes everything for diabetics"

### Aspirational – "Make me believe"
Motivate through stories to create belief.
- Center on before/after arc with transferrable takeaways
- Use personal clinical stories or patient success cases
- Examples: "When I saw my first 35-year-old with MI..." / "How one patient reversed prediabetes"

### Anthropological – "Explain the real why"
Explain psychology or hidden causes behind behaviors.
- Reframe mental models by surfacing underlying mechanisms
- Examples: "Why patients fear statins more than heart attacks" / "The real reason people skip cardiac rehab"

## Headline Structures

### Formula
Number + What + Audience (optional) + Outcome + Curiosity Gap

### 10 Proven Formats
1. X Ways To Do Y
2. X Mistakes To Avoid  
3. X Lessons Learned From Y
4. X Tools Every [Audience] Needs
5. How I Achieved X In Y Time
6. Why Everyone Gets This Wrong About X
7. The Secret To [Outcome]
8. What I Wish I Knew Before X
9. The Framework Behind [Successful Example]
10. The Surprising Truth About X

### Clear > Clever
- Bad: "The Silent Killer" (vague)
- Good: "5 reasons high cholesterol causes heart attacks"
- Best: "5 reasons high cholesterol causes heart attacks — and how to reverse each one"

## Thread Structures

### Lead-In Tweet (Hook)
Must answer:
1. What is this about?
2. Who is this for?
3. Why should I care?

Include: Specific promise + Curiosity gap + Clear outcome

### Three Thread Types

**Story Threads**
- High-drama opening
- Maintain suspense with short tweets
- End with moral/lesson mapping back to opening

**Framework Threads**
- Organize around repeatable structure
- Each tweet = one part of framework
- Example: "The ASCVD calculator has 4 inputs that matter most ↓"

**Actionable Threads**
- Step-by-step playbook
- Each tweet is a command, tip, or step
- Example: "Want to lower your cholesterol naturally? Follow this 5-step plan ↓"

## Formatting for Skimmability

### Writing Rhythms
**1/3/1 rhythm**
- 1 short sentence (hook)
- 3 supporting sentences
- 1 short sentence (punchline)

**1/5/1 rhythm**
- 1 hook
- 5 bullets/examples
- 1 summary

**1/2/5/2/1 rhythm**
- 1 hook
- 2 context lines
- 5 list items/examples
- 2 takeaway lines
- 1 closing punch

### Core Rules
- One idea per tweet (1-2 sentences max)
- Use lists & bullets
- Bold/isolate key takeaways
- Rate of Revelation: every line teaches something new
- Short lines = inviting; long blocks = repelling

### Closing Threads
Always end with:
- Summary of key insight
- Call-to-action (invite discussion, encourage share, offer more)
