# Cardiology Content Frameworks

Structure templates for different content types, combining Eric Topol's evidence-based approach with Peter Attia's deep-dive rigor.

## Framework 1: Research Commentary (Breaking Down a Trial)

Best for: New trials, practice-changing studies, major publications

### Structure

```
[HOOK: Why this matters now]
Brief context - why we needed this study

[STUDY OVERVIEW]
- Design: RCT/observational/meta-analysis
- N = [number]
- Population: who was studied
- Intervention vs. control
- Primary endpoint
- Follow-up duration

[KEY RESULTS]
Main findings with specific numbers:
- Primary outcome: [X]% reduction/increase, HR/RR, CI, p-value
- Absolute vs. relative risk
- Number needed to treat if applicable
- Secondary outcomes worth noting

[VISUAL DATA]
Reference figure(s) showing:
- Main outcomes
- Subgroup analyses
- Forest plots if relevant

[LIMITATIONS]
- Study weaknesses (honestly addressed)
- Generalizability questions
- What we still don't know
- Confounders or biases

[CLINICAL IMPLICATIONS]
- What should change in practice?
- Who benefits most?
- Implementation considerations

[FORWARD LOOK]
- What trials do we still need?
- Where does this fit in evolving evidence?
- Balanced perspective on progress
```

### Example Opening

"Our gold standard for assessing efficacy in cardiology is a large-scale randomized trial. Last week, CLEAR Outcomes delivered exactly that for bempedoic acid—and the results warrant attention."

---

## Framework 2: Clinical Deep Dive

Best for: Exploring a topic thoroughly, explaining mechanisms, connecting evidence to practice

### Structure

```
[HOOK: The clinical question or controversy]
Why this matters for patients and practitioners

[CURRENT STATE OF KNOWLEDGE]
- What do we think we know?
- What's the conventional approach?
- What guidelines say

[THE EVIDENCE BASE]
Walk through key studies chronologically or by theme:

Study 1: [Name/Year]
- Key finding
- Relevance

Study 2: [Name/Year]
- Key finding
- How it adds or contradicts

[Include specific N, outcomes, magnitudes]

[THE MECHANISM]
(If relevant)
- Pathophysiology
- Why the intervention should work
- Biologic plausibility

[WHAT WE STILL DON'T KNOW]
- Evidence gaps
- Unanswered questions
- Ongoing trials to watch

[PRACTICAL APPLICATION]
- How I approach this in my practice
- Patient selection considerations
- Risk-benefit discussion framework

[BOTTOM LINE]
- Clear summary of current evidence
- Where certainty exists vs. remains uncertain
- Call for additional research if needed
```

### Example Opening

"PCSK9 inhibitors reduce LDL dramatically. But do they reduce events, and for whom? After years of trials, we finally have a clear picture—and it's more nuanced than the headlines suggest."

---

## Framework 3: Technology/AI Analysis

Best for: New devices, AI applications, digital health innovations

### Structure

```
[HOOK: The promise or the problem being solved]
What challenge does this address?

[THE TECHNOLOGY]
- How it works (accessible explanation)
- What's actually new here
- Comparison to existing approaches

[THE EVIDENCE]
- Studies supporting efficacy
- Validation data
- Real-world performance vs. controlled settings

[SPECIFIC RESULTS]
- Accuracy metrics
- Clinical outcomes if available
- Comparison to human performance

[LIMITATIONS AND RISKS]
- What can go wrong
- Implementation challenges
- Generalizability concerns
- Regulatory status

[WHERE WE ARE IN THE JOURNEY]
- Research → Development → Validation → Implementation
- What's proven vs. what's promised

[FORWARD LOOK]
- Realistic timeline
- What needs to happen next
- Potential impact if realized
```

### Example Opening

"AI can now detect atrial fibrillation from a standard 12-lead ECG during sinus rhythm. The machine sees patterns humans cannot. But can this translate to fewer strokes?"

---

## Framework 4: Video Script (YouTube/Educational)

Best for: Spoken delivery, visual medium, broader audience

### Structure

```
[COLD OPEN - First 10 seconds]
Provocative statement, question, or surprising fact
Hook the viewer immediately

"Stents don't prevent heart attacks in stable disease. I know—that sounds wrong. Stay with me."

[SETUP - 30-60 seconds]
- Why this topic matters
- What most people (wrongly) believe
- What we're going to cover

"Today I'm going to walk you through what the data actually shows about stents, why the ISCHEMIA trial changed everything, and what this means for you or someone you love."

[CONTENT SECTION 1]
- Key concept or evidence piece
- [VISUAL CUE: Show graphic/animation]
- Clear explanation
- Relevance to viewer

[TRANSITION]
"Now here's where it gets interesting..."
"But wait—there's a caveat..."
"So what does this mean practically?"

[CONTENT SECTION 2]
- Next concept or evidence
- [VISUAL CUE]
- Build on previous section

[CONTENT SECTION 3]
- Final concept or synthesis
- [VISUAL CUE]
- Tie pieces together

[THE TAKEAWAY - 60 seconds]
- Clear summary (3 points max)
- What the viewer should do/know
- Acknowledge remaining uncertainty

[CALL TO ACTION]
- Subscribe/follow prompt
- Invitation to comment
- Reference to additional resources

[END SCREEN MOMENT]
Brief wrap-up for end screen overlay
```

### Video Script Conventions

- Use **[VISUAL]** to mark where graphics/animations go
- Use **[B-ROLL]** for supplementary footage moments
- Use **[PAUSE]** for emphasis beats
- Write conversationally—contractions are fine
- Shorter sentences than written content
- Include verbal signposts: "First... Second... Finally..."
- Address viewer directly: "you," "your"

### Example Opening (Video)

"[COLD OPEN]
What if I told you that for most people with stable chest pain, a stent doesn't prevent heart attacks or extend life?

[PAUSE]

I know. If you've had a stent, that might be uncomfortable to hear. If you're considering one, this matters.

[SETUP]
I'm [Name], an interventional cardiologist who puts in stents. And today I'm going to tell you what the largest trial ever conducted on this question actually showed—and what it means for your decisions."

---

## Framework 5: Patient Education

Best for: Explaining conditions, procedures, or decisions to patients and families

### Structure

```
[RELATABLE OPENING]
Acknowledge the patient's perspective
Why they're reading this

[THE BASICS]
- What is this condition/procedure?
- Plain language explanation
- Analogy if helpful

[WHY IT MATTERS]
- What are the risks without treatment?
- What symptoms might you have?
- Natural history

[THE OPTIONS]
- Treatment approaches available
- What each involves
- Pros and cons of each

[THE EVIDENCE]
- What studies show (simplified)
- Success rates and risks
- Honest about uncertainty

[WHAT TO EXPECT]
- The procedure/treatment process
- Recovery timeline
- Warning signs to watch for

[QUESTIONS TO ASK YOUR DOCTOR]
- List of specific questions
- Empowers patient in discussion

[BOTTOM LINE]
- Key takeaway
- Reassurance where appropriate
- Resources for more information
```

### Patient Education Principles

- No jargon without definition
- Use analogies (plumbing, electrical, etc.)
- Acknowledge fear and uncertainty
- Be honest about what we don't know
- Empower, don't patronize
- Include specific numbers when helpful (10 out of 100 people...)

---

## Framework 6: Controversy Analysis

Best for: Debated topics, conflicting evidence, practice variation

### Structure

```
[THE CONTROVERSY]
What's being debated and why it matters

[POSITION A]
- Who holds this view
- Their evidence
- Their strongest arguments

[POSITION B]
- Who holds this view
- Their evidence
- Their strongest arguments

[THE ACTUAL DATA]
- Walk through key studies objectively
- Note quality and limitations of each
- Where do they agree? Disagree?

[WHY THE DISAGREEMENT EXISTS]
- Different populations studied?
- Different endpoints valued?
- Different interpretation of same data?
- Financial or philosophical conflicts?

[MY PERSPECTIVE]
- Where I come down and why
- Acknowledge uncertainty
- What would change my mind

[FORWARD LOOK]
- What evidence would resolve this?
- Ongoing trials to watch
- How to approach this clinically in meantime
```

### Example Opening (Controversy)

"Should we close a PFO after cryptogenic stroke? Depending on which neurologist or cardiologist you ask, you'll get confident but opposite answers. Here's what the trials actually show—and why the debate persists."

---

## Framework 7: Quick Take / Hot Take

Best for: Rapid response to news, single-study commentary, Twitter threads

### Structure

```
[HEADLINE FINDING]
One sentence summary of the key result

[CONTEXT]
Why this matters (1-2 sentences)

[KEY NUMBER(S)]
The most important data point(s)

[LIMITATION OR CAVEAT]
What to be cautious about

[BOTTOM LINE]
What this means practically
```

### Thread Format (5-7 tweets)

1. Hook + key finding
2. Study design basics
3. Main result with numbers
4. Most important caveat
5. Clinical implication
6. Forward look
7. Link to paper

---

## Choosing the Right Framework

| If the content is about... | Use Framework |
|---------------------------|---------------|
| A new major trial | Research Commentary |
| Explaining a complex topic | Clinical Deep Dive |
| New device, AI, digital | Technology Analysis |
| Spoken/YouTube content | Video Script |
| For patients/public | Patient Education |
| Debated clinical question | Controversy Analysis |
| Quick news response | Quick Take |

---

## Cross-Framework Principles

Regardless of format:

1. **Lead with the most important point**
2. **Support claims with specific data**
3. **Acknowledge limitations honestly**
4. **Make it accessible without dumbing down**
5. **End with practical implications**
6. **Reference primary sources**
7. **Maintain the Topol voice throughout**
