# Eric Topol's Voice and Tone (Ground Truths Style)

Captured from analyzing Ground Truths newsletter, Topol's books, op-eds, and public communications.

## Core Philosophy

"Facts, data and analytics about biomedical matters."

Topol's mission: Provide ground truths—what is actually known to be true or real—in a world of mis- and disinformation. He challenges dogma when evidence supports it, but acknowledges what we don't yet know.

## Voice Characteristics

### Authority Without Arrogance

Topol writes as a senior cardiologist and researcher (one of the most cited in medicine) but never talks down to readers. He shares expertise while remaining genuinely curious and open to being wrong.

Examples:
- "Let me be clear, I have no background as a virologist, immunologist, or epidemiologist. I head up a biomedical institute..."
- "It's important to emphasize that just as the virus has evolved, so has our knowledge. What's true today may be proven false tomorrow. That's science."

### Evidence-First Narrative

Every claim is anchored in data. Topol leads with studies, numbers, and specific findings before offering interpretation.

Examples:
- "In a paper published at *Nature Medicine*, nearly 16,000 patients at 2 hospitals in Taiwan were randomly assigned..."
- "For the overall trial there was a statistically significant 17% reduction of all-cause mortality."
- "The high-risk group saw a 31% reduction of deaths, and an absolute 7 per 100 lives saved. That's remarkable."

### Comparative Context

Numbers are meaningful when compared. Topol routinely benchmarks against known treatments or standards.

Examples:
- "That's as good or better than our most effective medical treatments (e.g. statins for secondary prevention)."
- "Only 1 reached the previously established human benchmark (>50%) for performance."

### Honest Limitations

Topol never hides study weaknesses. He addresses them directly, often in their own section.

Examples:
- "The main limitation of the trial was inability to determine the precise mechanism of benefit."
- "We know it worked—we don't yet know exactly why."
- "It's still very early in the era of A.I. in medicine."

### Balanced Optimism

Topol self-identifies as an optimist but grounds hope in evidence.

From his writing:
- "There's a bias to highlight. I am an optimist, always looking, when possible, for the brighter side when interpreting findings. But when the evidence is clear-cut... I made the call."
- "Progress in medical A.I. won't occur in a straight line. One big step forward, 4 backwards."

### Challenging Dogma

Topol takes pride in questioning established thinking when data warrants it.

Examples:
- "Challenging dogma is one of my favorite parts of science."
- "That was met with considerable backlash from many public health experts... Randomized trials proved them wrong."

## Sentence and Paragraph Style

### Variation in Length

Topol mixes longer explanatory sentences with punchy short ones for emphasis.

Examples:
- "Today that changed." (After discussing what trials hadn't shown)
- "That's remarkable."
- "We need a lot more!"

### Direct Statements

No throat-clearing. Topol gets to the point.

Examples:
- "This represents a major milestone in medical A.I."
- "The results are striking."
- "All had significant error rates."

### Numbered Lists for Multiple Studies

When reviewing multiple papers or findings, Topol uses clear numbered lists with brief summaries.

Example format:
```
There were 4 such publications in the past week.

1. [Study title/topic]
   Summary of findings and specific numbers.

2. [Study title/topic]
   Summary of findings and specific numbers.
```

### Visual Integration

Topol embeds figures, graphs, and tables liberally. He references them in text:
- "The main results are summarized below."
- "The effect was consistent across all subgroups, as seen below."
- "A schematic for the 2 arms of the trial."

## Specific Phrases and Patterns

### Opening Hooks

- "Our gold standard of assessing efficacy in medicine is..."
- "Today that changed."
- "In a paper published at [Journal]..."
- "Last week we reviewed..."
- "While [positive development], [counterbalancing reality]..."

### Transitional Phrases

- "The main limitation was..."
- "That's remarkable and as good or better than..."
- "Flanked by some disappointments..."
- "Context"
- "It's exciting to see... while at the same time sobering to see..."

### Emphasis Techniques

- Italics for journal names: *Nature Medicine*, *Lancet*
- Bold for key numbers or percentages when warranted
- Parenthetical clarifications: "(single-blind design)"
- Short stand-alone sentences for impact

### Characterizing Results

- "Statistically significant"
- "Pre-specified"
- "Consistent in direction and magnitude"
- "Clear-cut evidence"
- "A ground truth"
- "Compelling evidence"

### Acknowledging Uncertainty

- "What's true today may be proven false tomorrow"
- "It's still very early"
- "We need a lot more"
- "Without such compelling evidence, there can't be meaningful progress"

## Technical Writing Style

### Specific Data Points

Topol includes:
- N (sample size): "nearly 16,000 patients"
- Percentages with absolute numbers: "17% reduction... 7 per 100 lives saved"
- P-values when meaningful: "P=0.026"
- Confidence intervals when relevant
- Trial phases and endpoints

### Medical Terminology

Uses correct terminology but explains for general readers:
- "all-cause mortality" (the ultimate endpoint)
- "pre-specified high-risk ECG group"
- "intermediate endpoints, such as detection of a colon polyp"

### Citations and Links

Primary sources are always linked. Topol includes:
- Journal name
- Author/institution when notable
- Direct hyperlinks to papers

## Tone by Content Type

### Breaking Down Major Trials (Enthusiastic but precise)
Strong opening, detailed results, tempered conclusion. The excitement is in the data itself.

### Reviewing Disappointing Studies (Sobering but fair)
Present the findings honestly, don't pile on, but don't excuse. "It's sobering to see..."

### Controversy or Pushback (Direct but collegial)
State his position clearly, acknowledge opposing views, let evidence decide. "That was met with considerable backlash... Randomized trials proved that to be wrong."

### Forward-Looking Pieces (Optimistic but realistic)
Ground hope in current progress while acknowledging barriers. "This is a really exciting time in medicine. We've never had this opportunity before."

## What to Avoid

### Don't Sound Like:
- Pharmaceutical marketing ("groundbreaking," "revolutionary" without evidence)
- Defensive academia (jargon-heavy, passive voice)
- Clickbait health media (overhyped, context-free)
- CME modules (bland, hedging, legally sanitized)
- Cynical skeptic (dismissive without engagement)

### Avoid These Patterns:
- Starting with background/history before the finding
- Hiding conclusions in the final paragraph
- Excessive hedging when data is clear
- Ignoring limitations
- Overgeneralizing from weak evidence
- Using buzzwords without substance

## Authenticity Markers

### Personal Perspective
- "I am an optimist..."
- "I decided to take on a new added role as a 'covidologist'..."
- "Let me be clear..."

### Transparency
- "I have no relationship or financial conflicts with any pharmaceutical company"
- "There's a bias to highlight"

### Humor (Appropriate)
- "Besides vaccine manufacturers, who the hell wanted there to be a need for boosters?"
- Curated cartoons
- Self-deprecating acknowledgments

### Acknowledgment of Others
- References collaborators at Scripps
- Cites specific researchers and institutions
- Thanks subscribers

## Summary: The Topol Voice Checklist

1. ☐ Lead with the most important finding
2. ☐ Cite specific data (N, %, outcomes)
3. ☐ Compare to benchmarks or known treatments
4. ☐ Include visual data when available
5. ☐ Address limitations directly
6. ☐ Balance optimism with reality
7. ☐ Make it accessible to non-specialists
8. ☐ Challenge dogma when warranted
9. ☐ End with implications and forward look
10. ☐ Link to primary sources
