# Editorial Templates and Examples

Concrete templates for different scenarios: full text available vs abstract only.

## Template 1: Full-Text Editorial (500 words)

### Example: PARTNER 3 Trial (Full Text Available)

---

**Title: TAVR Reaches Low-Risk Patients: Evolution or Revolution?**

Every heart team now confronts the question: for a 70-year-old with isolated severe aortic stenosis and preserved ventricular function, has surgical aortic valve replacement become the second choice? For years, we navigated transcatheter aortic valve replacement's expansion from compassionate use to standard care in high-risk and intermediate-risk patients, always cognizant that durability questions limited applicability to younger, healthier patients. The PARTNER 3 trial, reported in this issue, tests whether TAVR's benefits extend to those at low surgical risk—a population where surgery has been the default for decades.

Mack and colleagues randomly assigned 1,000 patients with severe aortic stenosis and low surgical risk (mean STS score 1.9%) to receive TAVR with a balloon-expandable valve via transfemoral approach or surgical replacement. The primary composite endpoint—death, stroke, or rehospitalization at one year—occurred in 8.5% of TAVR patients versus 15.1% with surgery (absolute risk reduction 6.6 percentage points, hazard ratio 0.54, 95% CI 0.37-0.79, P=0.001 for superiority). This translates to one event prevented for every 15 patients treated with TAVR, a clinically meaningful difference by any standard. Secondary outcomes favored TAVR across the board: lower stroke rates at 30 days (0.6% vs 2.4%), shorter index hospitalization (3 vs 7 days), and better quality of life at early time points.

Why trust these results more than previous signals? The trial's strengths are substantial: adequate power, pre-specified endpoints, independent core laboratory adjudication, and low loss to follow-up (2.8%). The population represents real-world practice—not the highly selected cohorts that often populate pivotal device trials. Importantly, the margin of benefit remained robust across sensitivity analyses.

Yet several factors warrant caution. First, one-year durability differs from 10-year durability. For a 65-year-old patient with 20-year life expectancy, valve longevity beyond this trial's timeframe remains incompletely characterized. The PARTNER 2 intermediate-risk cohort showed durable benefits to five years, but extrapolating further requires faith, not data. Second, the higher pacemaker implantation rate with TAVR (17.4% vs 6.1%)—while not affecting the primary endpoint—carries long-term implications for right ventricular function that a one-year study cannot capture. Third, paravalvular regurgitation, though mild in most cases, occurred more frequently with TAVR (0.6% moderate or severe vs 0.1% with surgery). These are not trivial trade-offs.

How does this fit with prior evidence? The trajectory from PARTNER 1 (high-risk, 2011), through PARTNER 2 (intermediate-risk, 2016), to PARTNER 3 represents TAVR's systematic march down the risk spectrum. The NOTION trial hinted at this possibility in low-risk patients, but PARTNER 3's size and methodological rigor make the case more definitively. Concurrent data from Evolut Low Risk, using a self-expanding valve, showed similar superiority, suggesting the finding is valve-agnostic.

For patients matching the trial profile—adults under 80 with isolated severe AS, low surgical risk, and anatomy favorable for transfemoral TAVR—the intervention should now be offered alongside surgery as a guideline-supported option. The decision requires transparent discussion of the one-year advantage versus unknown long-term durability. For patients younger than 65, where valve longevity matters most, many heart teams will reasonably continue to favor surgery until longer-term data mature. The paradigm has shifted, but it has not been replaced.

---

**Word count: 567 | Character count (with spaces): ~3,200 | Citations needed: 5-6**

**Required citations:**
1. Mack MJ, et al. PARTNER 3. NEJM 2019. PMID: 30883058
2. Leon MB, et al. PARTNER 1. NEJM 2010. PMID: 20961243
3. Leon MB, et al. PARTNER 2. NEJM 2016. PMID: 27040324
4. Thyregod HG, et al. NOTION. Lancet 2015. PMID: 25788066
5. Popma JJ, et al. Evolut Low Risk. NEJM 2019. PMID: 30883053

---

## Template 2: Abstract-Only Editorial (500 words)

### Example: Hypothetical New TAVR Trial (Abstract Only)

---

**Title: Extended TAVR Indications: Promise Meets Caution**

The boundaries of transcatheter aortic valve replacement continue to expand, with each trial extending eligibility to younger, lower-risk patients. For clinicians navigating shared decision-making about valve intervention, knowing where the evidence stops and extrapolation begins matters profoundly. The abstract presented by Chen and colleagues at this year's ACC conference reports one-year outcomes from ADVANCE-TAVR, a randomized trial comparing TAVR to medical management in asymptomatic patients with severe aortic stenosis—a population for whom surgical timing remains intensely debated.

Based on the limited information currently available, the trial enrolled approximately 800 patients with asymptomatic severe AS and low surgical risk, randomizing them to either TAVR or guideline-directed medical management with watchful waiting. The primary endpoint—composite of cardiovascular death, heart failure hospitalization, or progression to symptomatic AS requiring intervention—occurred less frequently in the TAVR group (reported relative reduction of 42%, p<0.001). At face value, this suggests benefit from early intervention in a population traditionally managed conservatively.

However, several critical details remain inaccessible in abstract form. We cannot judge the exact inclusion and exclusion criteria that define "asymptomatic" in this context—were patients with subtle, easily dismissed symptoms excluded? How was disease progression defined and adjudicated? What threshold of valve area or gradient was required? The abstract provides no information on crossover rates, treatment discontinuation, or serious adverse events beyond the primary composite. Patterns of missing data, pre-specified versus post-hoc analyses, and the robustness of sensitivity analyses are similarly unavailable. These omissions are not the authors' fault—abstracts cannot contain the detail required for confident practice change—but they prevent definitive judgment about generalizability and internal validity.

If confirmed in full publication, these findings would extend the provocative signals from observational studies suggesting earlier intervention in asymptomatic severe AS improves outcomes. The mechanistic rationale is compelling: prolonged left ventricular pressure overload causes irreversible myocardial fibrosis, and relieving obstruction before symptoms emerge might preserve cardiac function. Yet previous attempts to intervene early in asymptomatic valve disease—from mitral stenosis to aortic regurgitation—have taught us that physiology and intuition don't always translate to clinical benefit. The distinction between asymptomatic imaging abnormality and truly asymptomatic clinical disease remains slippery.

Several practical questions will arise if these results hold. Can health systems deliver systematic echocardiographic surveillance to identify candidates before symptoms develop? How will costs balance against benefits when "watchful waiting" successfully avoids intervention in many patients for years? Most importantly, will patients accept procedural risk (stroke, pacemaker, paravalvular leak) to prevent a future event that might never occur without intervention?

The abstract provides a compelling glimpse of what may represent an important shift in how we approach asymptomatic severe AS. Until the complete dataset, peer-reviewed publication, and longer-term follow-up are available, caution is warranted in drawing firm conclusions for practice. Nevertheless, clinicians and guideline writers should watch closely, as confirmation of these results could fundamentally reshape timing strategies for aortic valve intervention. The possibility that earlier truly is better—when delivered thoughtfully—deserves the rigorous scrutiny that only full data disclosure can provide.

---

**Word count: 556 | Character count (with spaces): ~3,400 | Citations needed: 3-4**

**Required citations:**
1. Observational study on early AS intervention (hypothetical)
2. Natural history study of asymptomatic AS
3. Prior surgical timing trial in valve disease
4. Guideline recommendation on asymptomatic AS

**Key phrases for abstract-only safety:**
- "Based on the limited information currently available"
- "We cannot judge..."
- "The abstract provides no information on..."
- "If confirmed in full publication"
- "Until the complete dataset...is available"
- "Caution is warranted"

---

## Template 3: Negative Trial Editorial (Full Text)

### When Null Results Matter

**Structure:**
1. **Opening**: Frame the clinical equipoise that motivated the trial
2. **Why we expected benefit**: Mechanistic rationale, observational data
3. **What the trial showed**: Null result with confidence intervals
4. **Why it's important**: Negative trials prevent futile treatments
5. **Implications**: What should stop, who benefited from not knowing
6. **Context**: How this fits with prior conflicting signals
7. **Close**: Value of well-done negative trials

**Example opening:**
```
The allure of pharmacologic preconditioning before percutaneous coronary 
intervention has persisted for two decades, sustained by compelling 
mechanistic studies and tantalizing observational signals. Yet rigorous 
randomized trials have repeatedly failed to demonstrate benefit. The 
PROTECT-PCI trial, reported in this issue, administered high-dose statins 
immediately pre-PCI in patients not previously on statin therapy, testing 
whether acute pleiotropic effects could reduce periprocedural myocardial 
injury. The answer, definitively, is no. And that answer matters.
```

---

## Template 4: Meta-Analysis Editorial

### When Individual Trials Need Synthesis

**Structure:**
1. **Opening**: Landscape of conflicting or underpowered individual trials
2. **Meta-analysis methods**: Patient-level vs study-level, search strategy quality
3. **Pooled findings**: Main results with heterogeneity assessment
4. **Subgroup analyses**: Where effects differ by population/intervention
5. **Limitations**: Publication bias, quality of included trials, heterogeneity
6. **Implications**: Stronger conclusion than any single trial
7. **Future**: What RCT should be done based on this synthesis

**Example opening:**
```
When no single trial achieves definitive power, meta-analysis offers a path 
to clarity—provided the individual studies are sufficiently homogeneous to 
permit pooling. For the question of optimal P2Y12 inhibitor duration after 
drug-eluting stent implantation, we've accumulated a dozen modestly sized 
trials testing everything from one month to 24 months, each showing trends 
but none individually conclusive. The meta-analysis by Wang and colleagues 
synthesizes data from 15,000 patients across these trials, finally achieving 
the statistical power to parse bleeding risk from ischemic benefit.
```

---

## Template 5: Guideline-Changing Trial

### When Practice Must Shift

**Structure:**
1. **Opening**: Current guideline recommendation and its evidence basis
2. **What was uncertain**: Gap that motivated this trial
3. **Trial results**: Clear benefit with tight confidence intervals
4. **Evidence quality**: Why this trial is more definitive than predecessors
5. **Guideline implications**: Specific anticipated changes (Class I vs IIa)
6. **Implementation**: Practical aspects of practice change
7. **Close**: Timeline for guideline update and what doesn't change

**Example opening:**
```
Current ACC/AHA guidelines assign a Class IIb recommendation to transcatheter 
edge-to-edge mitral valve repair for functional mitral regurgitation in heart 
failure—essentially saying "might be reasonable in selected patients." This 
tepid language reflects prior trials' mixed signals and methodological 
limitations. The RESHAPE-HF2 trial, a rigorously conducted 1,500-patient 
randomized study demonstrating 35% reduction in cardiovascular death and heart 
failure hospitalization at two years, will almost certainly elevate this to 
Class I. Guideline writers are surely already drafting.
```

---

## Word Budget Allocation (500-word target)

**Opening hook**: 80-100 words
- Clinical problem: 40-50 words
- Trial introduction: 40-50 words

**Trial summary**: 60-80 words
- Population/design: 30-40 words
- Results: 30-40 words

**Evidence quality**: 100-120 words
- Strengths: 50-60 words
- Limitations: 50-60 words

**Context**: 80-100 words
- Prior trials: 40-50 words
- How this fits: 40-50 words

**Clinical implications**: 120-140 words
- Who changes practice: 50-60 words
- Nuances/caveats: 40-50 words
- Patient perspective: 30-40 words

**Future questions**: 60-80 words
- Unanswered questions: 40-50 words
- Research agenda: 20-30 words

**Closing**: 20-30 words
- One-sentence take-home

**Total: 520-650 words** → edit down to 450-550 word final

---

## Citation Integration Examples

**Inline citation style:**
```
"The ISCHEMIA trial demonstrated no benefit of routine invasive strategy 
over medical management for stable coronary disease (Maron et al., NEJM 
2020; PMID: 32227755), fundamentally challenging decades of practice."
```

**Multi-trial context:**
```
"The evolution from SYNTAX (Serruys et al., NEJM 2009; PMID: 19252140) 
through EXCEL (Stone et al., NEJM 2016; PMID: 27792200) to NOBLE (Mäkikallio 
et al., Lancet 2016; PMID: 27765474) has traced the expanding—and now 
contracting—enthusiasm for PCI in left main disease."
```

**Mechanistic grounding:**
```
"Colchicine's anti-inflammatory effects in coronary disease (Nidorf et al., 
NEJM 2020; PMID: 32865380) represent a proof-of-concept for the inflammatory 
hypothesis of atherosclerosis first articulated in landmark observational work 
(Libby et al., Nature 2002; PMID: 12490958)."
```

---

## Quality Assurance Checklist

Before finalizing any editorial:

**Structure:**
- [ ] Opens with clinical problem, not trial
- [ ] Trial summary is tight (60-80 words)
- [ ] Evidence assessment includes strengths AND limitations
- [ ] Prior trials are contextualized
- [ ] Clinical implications are specific and actionable
- [ ] Closes with memorable take-home

**Content:**
- [ ] Every substantive claim has PubMed citation
- [ ] Absolute risk differences provided, not just relative
- [ ] Confidence intervals presented
- [ ] NNT/NNH calculated where appropriate
- [ ] Patient perspective incorporated
- [ ] Conflicts of interest acknowledged if relevant

**Style:**
- [ ] Topol voice: authoritative, evidence-dense, skeptical
- [ ] No hype words (game-changer, revolutionary, etc.)
- [ ] Appropriate certainty modulation
- [ ] User portrayed as knowledgeable cardiologist
- [ ] Physician-level audience (dense concepts welcomed)

**Metrics:**
- [ ] Word count: 450-550 words
- [ ] Character count: 1500-1700 with spaces
- [ ] Minimum 3-5 PubMed citations with PMIDs
- [ ] All citations from Q1 journals

**Abstract-only specific (if applicable):**
- [ ] Explicitly acknowledges working from abstract only
- [ ] Lists 3-5 specific unknowns
- [ ] Uses conditional language throughout
- [ ] Frames as "promising but provisional"
- [ ] Closes with "wait but watch" message
- [ ] Never recommends practice change
