# Eric Topol Ground Truths Style Guide

Comprehensive guide to mimicking Eric Topol's authoritative, evidence-dense writing style for cardiology editorials.

## Voice Characteristics

### Authority Without Arrogance
- Speak as a peer to other physicians, not lecturing down
- Confidence comes from evidence, not bombast
- Willing to say "we don't know yet" when appropriate
- Show intellectual humility while demonstrating deep expertise

### Dense but Accessible
- Pack substantive content into every sentence
- Assume physician audience understands medical concepts
- Don't oversimplify, but don't use jargon gratuitously
- Balance technical precision with readability

### Evidence-Grounded Skepticism
- Default stance: "show me the data"
- Question methodology, not just accept conclusions
- Point out conflicts of interest when relevant
- Distinguish association from causation rigorously

### Patient-Centered Lens
- Always circle back to "what does this mean for patients?"
- Consider quality of life, not just mortality/morbidity
- Acknowledge treatment burden and patient preferences
- Question whether statistical significance equals clinical meaningfulness

## Structural Patterns

### Opening Gambits (First 1-2 Paragraphs)

**Pattern 1: The Clinical Dilemma**
```
Example: "Every interventional cardiologist faces this scenario weekly: 
an 82-year-old with severe aortic stenosis, multiple comorbidities, 
and a surgical risk score that makes the heart team uncomfortable. 
For years, we've navigated this with educated guesses about who 
truly benefits from transcatheter intervention. The NOTION-3 trial 
offers data where we've had only intuition."
```

**Pattern 2: The Practice Gap**
```
Example: "Despite decades of statin trials, we continue to debate 
LDL targets in secondary prevention. The paradigm of 'lower is better' 
bumps against concerns about polypharmacy, costs, and diminishing returns. 
Into this unsettled landscape comes CLEAR Outcomes, testing a question 
that practicing cardiologists need answered."
```

**Pattern 3: The Provocative Question**
```
Example: "Can we prevent Alzheimer's disease in patients with 
coronary artery disease by intensifying cardiovascular risk factor 
control? The connection between vascular health and cognitive 
decline has moved from hypothesis to mechanism, but intervention 
trials have disappointed. Now we have preliminary evidence that 
changes the conversation."
```

### The "Why I Trust This" / "Why I Hesitate" Technique

Always include both in evidence assessment:

**Trust signals:**
- Pre-specified primary outcome, no changes mid-trial
- Adequate sample size and power for stated hypothesis
- Independent adjudication of events
- Intention-to-treat analysis
- Low loss to follow-up (<5%)
- Registry in clinicaltrials.gov before enrollment
- Transparent reporting of conflicts

**Hesitation signals:**
- Composite endpoints hiding null individual components
- Early stopping for benefit (inflates effect size)
- Post-hoc subgroup analyses
- Surrogate endpoints without long-term validation
- Industry sponsorship without independent data monitoring
- Highly selected population limiting generalizability
- Missing data >10% for primary outcome

### Contextualizing with Prior Evidence

**Template:**
```
These findings [confirm/extend/contradict] the signals from [Trial A] 
and [Trial B], which demonstrated [brief prior result]. However, 
unlike those earlier studies, [current trial] enrolled [key difference], 
which may explain [why results differ or align].
```

**Always answer:**
1. What did we think before this trial?
2. How does this trial change our thinking?
3. What's the plausible mechanistic or methodological explanation?

### Clinical Implications: The "Monday Morning" Test

**Good practice guidance (Topol-style):**
```
"For patients who resemble the trial population—adults under 75 
with isolated severe AS and low surgical risk—TAVR should now be 
discussed alongside surgery as a guideline-supported option. The 
8.5% vs 15.1% composite endpoint at one year represents a number 
needed to treat of 15, clinically meaningful by any standard."
```

**What to avoid:**
```
"This is a game-changer. Everyone should get TAVR now."
```

**Nuanced stance:**
```
"The durability question remains. While TAVR shows superior 
short-term outcomes, valve longevity beyond 5 years is less 
well established than for surgical bioprostheses. For a 65-year-old 
with 20+ year life expectancy, this uncertainty matters and merits 
shared decision-making."
```

### Closing Statements

**Pattern 1: The Balanced Summary**
```
"This trial represents a major advance in how we approach [condition], 
but it is not the final word. [Specific unanswered question] will 
require longer follow-up and real-world data."
```

**Pattern 2: The Practice Directive**
```
"For the profile studied here—[specifics]—the evidence now supports 
[specific practice change], provided that [important caveat]. Outside 
this population, caution and individualization remain essential."
```

**Pattern 3: The Research Agenda**
```
"The natural next question is whether [extension or variation]. 
Until we have that data, clinicians will need to balance the clear 
gains in [outcome A] against uncertain effects on [outcome B]."
```

## Numerical Presentation

### Prefer Absolute Over Relative Risk

**Weak:**
```
"Treatment reduced events by 43%"
```

**Strong (Topol-style):**
```
"Treatment reduced events from 15.1% to 8.5%—an absolute risk 
reduction of 6.6 percentage points (HR 0.54, 95% CI 0.37-0.79). 
This translates to one event prevented for every 15 patients treated."
```

### Number Needed to Treat/Harm

Calculate and present when possible:
```
"With an ARR of 6.6%, the NNT is 15 to prevent one composite event 
(death, stroke, or rehospitalization) at one year. Against this, 
the increased pacemaker rate of 17% vs 7% yields an NNH of 10."
```

### Confidence Intervals Tell Stories

**Good:**
```
"The confidence interval (0.37 to 0.79) excludes unity and excludes 
trivial benefits, supporting both statistical and clinical significance."
```

**Point out when CIs are problematic:**
```
"While the point estimate suggests benefit, the wide confidence 
interval (0.58 to 1.12) includes both meaningful benefit and 
meaningful harm. This uncertainty should temper enthusiasm."
```

## Citation Discipline

### Always Cite Substantive Claims

**Claim types requiring citations:**
- Trial results or findings
- Historical context ("Previous trials showed...")
- Mechanistic statements ("The pathway involves...")
- Epidemiological data ("Affecting 5 million Americans...")
- Guideline recommendations

### Citation Format

**In-text:**
```
"The PARTNER 3 trial demonstrated superior outcomes with TAVR 
compared to surgery in low-risk patients (Mack et al., NEJM 2019; 
PMID: 30883058)."
```

**Reference list (end of editorial):**
```
1. Mack MJ, Leon MB, Thourani VH, et al. Transcatheter Aortic-Valve 
Replacement with a Balloon-Expandable Valve in Low-Risk Patients. 
N Engl J Med. 2019;380(18):1695-1705. doi:10.1056/NEJMoa1814052 
PMID: 30883058
```

### Multi-Trial Context Example

```
"The trajectory from PARTNER 1 (high-risk, 2011; PMID: 21696309) 
through PARTNER 2 (intermediate-risk, 2016; PMID: 27040324) to 
PARTNER 3 (low-risk, 2019; PMID: 30883058) traces TAVR's expansion 
across the surgical risk spectrum, each trial shifting the paradigm 
one step further."
```

## Language Patterns

### Certainty Modulation

**High certainty (strong evidence):**
- "The data demonstrate..."
- "This trial establishes..."
- "We can now conclude..."

**Moderate certainty (good but imperfect evidence):**
- "The findings suggest..."
- "This provides evidence that..."
- "It appears likely that..."

**Low certainty (preliminary, abstract-only, or limited data):**
- "Initial results hint at..."
- "If confirmed, this could..."
- "The abstract suggests, but does not prove..."

### Avoiding Hype

**Never use:**
- "Game-changer"
- "Paradigm shift"
- "Revolutionary"
- "Breakthrough" (unless truly first-in-class)
- "Definitive proof"

**Use instead:**
- "Important advance"
- "Meaningful progress"
- "Practice-changing for [specific population]"
- "Strong evidence"
- "Valuable contribution"

### Patient-Centered Language

**Integrate throughout:**
- "What patients actually experience..."
- "From the patient's perspective..."
- "The treatment burden includes..."
- "Quality of life considerations..."
- "Shared decision-making should weigh..."

## Topol Signature Moves

### The Comparative Framework

Position every trial against what came before:
```
"Unlike SURTAVI, which studied intermediate-risk patients, 
Evolut Low Risk enrolled patients with STS scores <3%, 
making direct comparison to PARTNER 3 possible for the 
first time across different valve platforms."
```

### The Methodological Dive

Show you've read the methods carefully:
```
"The trial's adaptive design allowed early stopping for efficacy, 
reached at the pre-planned interim analysis. While this accelerates 
knowledge, it also tends to overestimate effect sizes—something 
to remember when projecting benefits forward."
```

### The Cost/Access Reality Check

Don't ignore practical constraints:
```
"These results matter only if they translate to practice. At 
$30,000 per TAVR procedure, expansion to low-risk patients 
carries health system implications that extend beyond individual 
patient benefit. Cost-effectiveness analyses will be essential."
```

### The Subgroup Scrutiny

When subgroups tell different stories:
```
"While the overall benefit is clear, the interaction p-value of 0.03 
for age suggests younger patients derive less benefit—or potentially 
more harm. This isn't a post-hoc fishing expedition; it's a 
pre-specified analysis that demands attention."
```

## Word Economy

Topol packs information density into limited space:

**Weak (65 words):**
```
"The trial was a randomized controlled trial that included a total 
of 1000 patients. These patients had severe aortic stenosis and were 
considered to be at low risk for surgery. The patients were randomly 
assigned to receive either TAVR or surgical valve replacement. The 
main outcome that was measured was a composite endpoint consisting 
of death, stroke, or rehospitalization at one year."
```

**Strong (Topol-style, 35 words):**
```
"In this 1000-patient RCT, individuals with severe aortic stenosis 
and low surgical risk were randomized to TAVR versus surgery, with 
a primary composite endpoint of death, stroke, or rehospitalization 
at one year."
```

## Target Metrics

**For 500-word editorial:**
- Opening hook: 80-100 words
- Trial summary: 60-80 words
- Evidence quality: 100-120 words
- Context: 80-100 words
- Clinical implications: 120-140 words
- Limitations/future: 60-80 words
- Closing: 20-30 words

**Character count: 1500-1700** (including spaces, punctuation)

## Quality Checklist

Before finalizing, verify:

- [ ] Every substantive claim has a PubMed citation
- [ ] Numbers include both absolute and relative risks
- [ ] Confidence intervals are presented for effect estimates
- [ ] Prior trials are contextualized with specific citations
- [ ] Clinical implications are specific and actionable
- [ ] Limitations are acknowledged without undermining the message
- [ ] Patient perspective is incorporated
- [ ] No hype words ("game-changer", "revolutionary")
- [ ] Voice is authoritative but not arrogant
- [ ] User appears as knowledgeable cardiologist authority
- [ ] Physician audience would find content dense and valuable
- [ ] Word count: 450-550 words
- [ ] Character count: 1500-1700

## Common Pitfalls to Avoid

1. **Press release tone**: Don't simply relay trial conclusions
2. **Excessive hedging**: Balance skepticism with clarity
3. **Ignoring prior evidence**: Trials don't exist in vacuum
4. **Forgetting patients**: More than just statistics
5. **Uncritical acceptance**: Every trial has limitations
6. **Vague implications**: Be specific about who should change what
7. **Missing the forest**: What's the big picture message?
8. **Citation gaps**: Ground every claim in evidence
9. **Wrong audience level**: Assume MD-level sophistication
10. **Losing Topol voice**: Authoritative, evidence-dense, patient-centered
