# Tweet Examples

## Good Examples (Emulate These)

**Surprising fact opener:**
```
Your morning coffee might protect your heart. A meta-analysis of 36 studies found 3-5 cups daily linked to lowest CV risk. The mechanism? Likely polyphenols improving endothelial function.
```
Seeds: Coffee | Modifiers: Meta-Analysis, Mechanism

**Myth-busting:**
```
"All cholesterol is bad" is outdated thinking. LDL particle number matters more than total LDL. Two people with identical LDL-C can have vastly different cardiovascular risk.
```
Seeds: LDL, LDL-P | Modifiers: Myth-Busting, Comparison

**Counterintuitive insight:**
```
Elevated troponin after a marathon doesn't mean heart attack. It reflects cardiac strain, not damage. Levels normalize within 24-72 hours. Context matters in biomarker interpretation.
```
Seeds: Troponin, Athletes | Modifiers: Myth-Busting, Context

**Actionable advice:**
```
Want better blood pressure control? Try 150 min/week of moderate exercise. SPRINT trial showed lifestyle modifications alone dropped systolic BP by 5-8 mmHg on average.
```
Seeds: Hypertension, Exercise | Modifiers: How-To, Latest Research

**Clinical observation (anonymized):**
```
I often see patients dismiss leg swelling as "just water retention." But new ankle edema in someone with risk factors warrants cardiac evaluation. Early heart failure often hides in plain sight.
```
Seeds: Edema, Heart Failure | Modifiers: Symptoms, Early Detection

**Short punchy:**
```
Lp(a) is 90% genetic. Diet and exercise won't budge it. If you haven't checked yours, consider it. One test, lifelong relevance.
```
Seeds: Lp(a), Genetics | Modifiers: Prevention, Quick Summary

**Question hook:**
```
Why do heart attacks spike on Monday mornings? Cortisol surge, BP rise, and platelet aggregation peak during early AM stress. Your cardiovascular system feels that alarm clock too.
```
Seeds: MI, Circadian | Modifiers: Mechanism, Explainer

## Bad Examples (Avoid These)

**AI-typical phrasing (DO NOT USE):**
```
❌ Let's delve into the fascinating world of cardiovascular biomarkers — understanding these markers is truly a game-changer for heart health!
```
Problems: "delve," em dash, "game-changer," exclamation mark, generic

**Overly generic:**
```
❌ Studies show that exercise is good for your heart. It's important to note that staying active can help prevent heart disease.
```
Problems: "Studies show," "It's important to note," no specifics

**Overconfident claims:**
```
❌ This one supplement will completely reverse your heart disease and eliminate your need for medications!
```
Problems: Overstated benefits, potentially dangerous

**Robotic list format:**
```
❌ Here are 5 ways to improve heart health:
- Exercise more
- Eat better
- Sleep well
- Reduce stress
- Don't smoke
```
Problems: Generic, list format, no insight

**Perfect parallel structure (AI tell):**
```
❌ Exercise improves your heart. Nutrition improves your heart. Sleep improves your heart. Stress reduction improves your heart.
```
Problems: Unnatural repetitive structure

## Writing Patterns to Use

**Varied sentence openings:**
- Direct statement: "Lp(a) levels are 90% genetic."
- Question: "Why do cardiologists care about particle number?"
- Observation: "I see this pattern repeatedly in clinic."
- Counterpoint: "But here's what most people miss."
- Number: "150 minutes per week. That's the exercise threshold."

**Natural transitions:**
- "The reason?" not "Here's the thing:"
- "What this means:" not "Let's break it down:"
- "Turns out," not "Interestingly,"
- "Worth knowing:" not "It's important to note that"

**Credibility markers:**
- Cite study types: "RCT," "meta-analysis," "cohort data"
- Name trials when well-known: SPRINT, FOURIER, REDUCE-IT
- Mention mechanisms: "via endothelial function," "through LDL receptor upregulation"
- Use appropriate hedging: "suggests," "associated with," "may contribute to"
