# Content Modifiers for YouTube

Mix these modifiers with seed topics to create specific, targeted video angles.

**Formula:** Seed Topic + Modifier(s) = Specific Video Concept

---

## 1. Demographic Modifiers
*Who is this for?*

- Women 35-50
- Women 50-65
- Women 65+
- Men 35-50
- Men 50-65
- Men 65+
- Young Adults (20s-30s)
- Teenagers
- Parents/Families
- Athletes / Fitness Enthusiasts
- Sedentary Professionals
- Shift Workers
- Seniors Living Alone
- Caregivers
- Newlyweds / Young Couples

---

## 2. Awareness Level Modifiers 🔥
*How much do they already know?*

- Complete Beginner
- Just Diagnosed
- Managing for Years
- Family Member of Patient
- Health Enthusiast
- Skeptic / Questioning
- Anxious / Overwhelmed
- Ready for Advanced Info
- Research-Oriented
- Action-Ready

---

## 3. Content Angle Modifiers 🔥
*What's the hook?*

- Myth vs. Fact
- What I Wish I Knew
- Things Doctors Don't Tell You
- Beginner's Guide
- Deep Dive / Comprehensive
- Quick Tips
- Common Mistakes
- Controversial Take
- Latest Research
- Personal Story
- Before & After
- Day in the Life
- Q&A / Viewer Questions
- Comparison (X vs Y)
- Ranking / Best to Worst
- Warning Signs
- Step-by-Step
- Cost / Budget Analysis
- Time-Sensitive / Urgent

---

## 4. Temporal Modifiers
*When/timing angle?*

- First 30 Days After Diagnosis
- 1 Year Post-Event
- Long-Term Management
- Prevention Before 40
- Changes in Your 50s
- Preparing for Procedure
- Post-Procedure Recovery
- Morning Routine
- Night Routine
- Weekend vs Weekday
- Holiday Season
- New Year Reset
- Summer/Winter Specific
- Travel Preparation
- During Stressful Periods

---

## 5. Outcome Modifiers 🔥
*What result are they seeking?*

- Lower Risk
- Reduce Medication
- Get Off Medication
- Improve Numbers
- More Energy
- Better Sleep
- Longer Life
- Avoid Surgery
- Reverse Damage
- Stop Progression
- Peace of Mind
- Better Doctor Conversations
- Take Control
- Understand What's Happening
- Make Informed Decisions

---

## 6. Evidence Modifiers
*How to frame the information?*

- According to Latest Research
- What Studies Actually Show
- My Clinical Experience
- Real Patient Cases
- Guidelines vs Reality
- Emerging Evidence
- Long-Term Data
- Conflicting Studies
- What We Don't Know Yet
- Evidence-Based vs Popular

---

## 7. Barrier Modifiers
*What's stopping them?*

- Time Constraints
- Budget / Cost
- Motivation
- Conflicting Information
- Fear / Anxiety
- Side Effects Concern
- Family Resistance
- Work Schedule
- Travel Frequently
- Physical Limitations
- Mental Health Challenges
- Trust Issues (with healthcare)
- Previous Bad Experience
- Information Overload

---

## 8. Comparison Modifiers 🔥
*X vs Y structure*

- Old Approach vs New Approach
- Medication vs Lifestyle
- Generic vs Brand
- Invasive vs Non-Invasive
- Short-Term vs Long-Term
- Traditional vs Alternative
- US vs Other Countries
- Cheap vs Expensive
- Popular Opinion vs Evidence
- What You Hear vs Reality
- Before vs After
- Patient A vs Patient B

---

## 9. Emotional Modifiers
*What feeling to tap into?*

- Fear → Reassurance
- Confusion → Clarity
- Overwhelm → Simplicity
- Hopelessness → Hope
- Anger → Understanding
- Guilt → Self-Compassion
- Anxiety → Calm
- Denial → Acceptance
- Skepticism → Trust
- Isolation → Community

---

## 10. Controversy/Debate Modifiers 🔥
*Hot topics that drive engagement*

- Should Everyone Take This?
- Is This Actually Dangerous?
- Why Doctors Disagree
- The Hidden Truth About
- What Big Pharma Won't Tell You
- Overhyped vs Underrated
- Is This a Scam?
- The Real Reason...
- What Changed My Mind
- I Was Wrong About...

---

## 11. Platform Modifiers
*Content type/length*

- YouTube Long-Form (10-20 min)
- YouTube Standard (5-10 min)
- YouTube Shorts
- Podcast Companion
- Series Episode
- One-Off Deep Dive
- FAQ Compilation
- Reaction Video
- Collaboration

---

## 12. Action Modifiers
*What should they DO?*

- Watch For These Signs
- Ask Your Doctor About
- Start Doing This Today
- Stop Doing This Immediately
- Schedule This Test
- Add This to Your Routine
- Remove This From Your Life
- Track This Number
- Join This Program
- Read This Book/Resource

---

## Combination Examples

| Seed | + Modifiers | = Video Title |
|------|-------------|---------------|
| Statins | + Myth vs Fact + Skeptic | "Statin Side Effects: Myths vs Reality" |
| AFib | + Just Diagnosed + Fear→Reassurance | "Just Diagnosed with AFib? Here's What to Know" |
| Sleep Apnea | + Heart Connection + Warning Signs | "Sleep Apnea: The Hidden Heart Disease Trigger" |
| Apo B | + Why Doctors Disagree + Latest Research | "Apo B: Why Some Cardiologists Think LDL Is Outdated" |
| Exercise | + Athletes + Controversial Take | "Can Too Much Exercise Damage Your Heart?" |
| Cholesterol | + Women 50-65 + What Changes | "Menopause and Cholesterol: What Women Need to Know" |

---

## High-Engagement Modifier Combos

**For Maximum Click-Through:**
- [Controversial Topic] + "The Truth About" + Latest Research
- [Common Fear] + "Should You Worry?" + Evidence-Based
- [Popular Belief] + "Myth vs Fact" + Clinical Experience

**For Maximum Watch Time:**
- [Complex Topic] + "Complete Guide" + Step-by-Step
- [Condition] + "What I Wish I Knew" + Patient Stories
- [Comparison] + "Which Is Better?" + Deep Dive

**For Maximum Shares:**
- [Unexpected Finding] + "This Changed Everything" + Personal Story
- [Common Mistake] + "Stop Doing This" + Warning Signs
- [Underrated Topic] + "Nobody Talks About" + Why It Matters
