# YouTube Script Templates for Cardiology Content

## Table of Contents
1. [The Hook Formula](#the-hook-formula)
2. [Script Structures by Video Type](#script-structures)
3. [Retention Techniques](#retention-techniques)
4. [CTAs That Convert](#ctas)
5. [Cardiology-Specific Elements](#cardiology-specific)

---

## The Hook Formula {#the-hook-formula}

**First 30 seconds determine 70% of video success.** Use these proven hook patterns:

### Pattern 1: Contrarian/Myth-Buster
```
"Everything you've been told about [common belief] is wrong. 
Here's what [X years] as a cardiologist taught me..."
```

### Pattern 2: Story Lead
```
"A 52-year-old marathon runner walked into my office last week. 
His cholesterol was perfect. His blood pressure was ideal. 
And he was having a heart attack..."
```

### Pattern 3: Curiosity Gap
```
"There's one number on your blood test that predicts heart disease 
better than cholesterol—and most doctors never check it."
```

### Pattern 4: Direct Problem-Solution
```
"If you wake up tired even after 8 hours of sleep, 
your heart might be working harder than it should. 
Here are 5 signs to watch for."
```

### Pattern 5: Stakes/Urgency
```
"This silent symptom sends 500,000 people to the ER every year. 
By the end of this video, you'll know exactly what to look for."
```

---

## Script Structures {#script-structures}

### Structure A: Educational Explainer (8-15 min)

```
[0:00-0:30] HOOK
- Pattern interrupt or surprising fact
- Promise of value
- "Stay till the end for..."

[0:30-1:30] CREDIBILITY + CONTEXT
- Brief intro (don't over-explain credentials)
- Why this topic matters NOW
- What you'll learn

[1:30-3:00] SECTION 1: Foundation
- Core concept explained simply
- One relatable analogy
- Quick recap

[3:00-5:00] SECTION 2: Deep Dive
- The "how" or "why"
- Evidence/research (cite simply)
- Real patient story (anonymized)

[5:00-7:00] SECTION 3: Practical Application
- What to actually DO
- Step-by-step if applicable
- Common mistakes to avoid

[7:00-8:30] SECTION 4: Advanced Nuance (optional)
- Edge cases
- When to see a doctor
- Individual variation

[8:30-9:30] RECAP + CTA
- 3 key takeaways (numbered)
- Clear next step
- Engagement prompt
```

### Structure B: Listicle (5-10 min)

```
[0:00-0:30] HOOK
- "X things that [outcome]" with stakes
- Tease the most surprising item

[0:30-1:00] QUICK CONTEXT
- Why this list matters
- Brief credibility

[1:00-X:00] THE LIST
For each item:
- State it clearly (bold statement)
- Explain why (30-60 seconds)
- One actionable tip
- Transition phrase to next

[Last 60 seconds] WRAP-UP
- Quick recap of all items
- "Most important one is..."
- CTA
```

### Structure C: Myth vs. Fact (8-12 min)

```
[0:00-0:30] HOOK
- "This myth has been killing people for 30 years..."

[0:30-1:00] SETUP
- Why myths persist
- Your approach to evidence

[1:00-X:00] MYTHS
For each myth:
- State the myth (what people believe)
- Why it seems true
- The actual evidence
- The truth (clear takeaway)
- Transition

[Last 90 seconds] WRAP-UP
- Pattern of why myths spread
- How to evaluate health info
- CTA
```

### Structure D: Case Study / Story-Driven (10-15 min)

```
[0:00-0:45] HOOK
- Start IN the story (in medias res)
- Create tension/stakes

[0:45-2:00] SETUP
- Patient background (anonymized)
- What seemed normal
- The first sign something was wrong

[2:00-5:00] THE JOURNEY
- Discovery process
- Plot twists / complications
- Teaching moments woven in

[5:00-7:00] RESOLUTION
- What happened
- Treatment/outcome
- Patient perspective (if available)

[7:00-9:00] LESSONS
- What YOU should learn from this
- Warning signs
- When to act

[9:00-10:00] CTA
- Emotional callback to story
- Clear next step
```

### Structure E: Shorts/Reels (30-60 sec)

```
[0:00-0:03] HOOK
- One punchy line
- Text on screen matches audio

[0:03-0:45] CONTENT
- ONE key point only
- Simple language
- Visual demonstration if possible

[0:45-0:60] PAYOFF + CTA
- Clear takeaway
- "Follow for more"
- Loop-friendly ending
```

---

## Retention Techniques {#retention-techniques}

### Pattern Interrupts (use every 2-3 minutes)
- "But here's where it gets interesting..."
- "Now, you might be thinking..."
- "Let me show you what I mean..."
- Change camera angle or location
- Insert B-roll or graphic

### Open Loops
- Tease later content: "I'll show you the #1 mistake in a minute"
- Reference back: "Remember what I said about X? Here's why it matters..."

### Engagement Prompts
- "Comment below if this has happened to you"
- "Drop a 🫀 if you're learning something new"
- "Tell me which one surprised you most"

### Chunking
- Number your sections: "Point number two..."
- Visual chapter markers
- Clear transitions: "Now let's talk about..."

---

## CTAs That Convert {#ctas}

### For Subscribers
- "If this helped you, subscribe—I post [frequency] about [topic]"
- "Hit subscribe so you don't miss [upcoming content]"

### For Engagement
- Specific question: "What's YOUR biggest heart health concern? Comment below"
- Poll: "Which topic should I cover next: A or B?"

### For Action
- "Download my free [resource] in the description"
- "Book a screening if you haven't had one in [timeframe]"

---

## Cardiology-Specific Elements {#cardiology-specific}

### Credibility Markers (use sparingly)
- "In my [X] years treating patients..."
- "I see this in my cath lab every week..."
- "The research shows..." + cite source simply

### Safety Language
- "This is education, not medical advice for your specific situation"
- "If you're experiencing [symptoms], seek immediate care"
- "Talk to YOUR doctor before making changes"

### Simplifying Complex Topics
- Use analogies: "Think of your arteries like pipes..."
- Relate to daily life: "That's like drinking X cups of coffee"
- Visual metaphors: "Imagine your heart as a pump..."

### Emotional Connection
- Anonymized patient stories
- Your own journey/observations
- Family health experiences (if comfortable)

### Trust Builders
- Acknowledge uncertainty: "We don't fully understand yet..."
- Present both sides: "Some doctors believe X, others Y..."
- Admit limitations: "This doesn't apply to everyone..."
