# Cardiology Seed Ideas for YouTube

Quick reference of 300 topic seeds organized by category. Use with modifiers to generate specific video concepts.

---

## High-Performing Categories for YouTube

**🔥 = High engagement potential based on search volume and emotional resonance**

---

## 1. Biomarkers & Lab Tests 🔥
*"What does my blood test mean?"*

- Apo B (apolipoprotein B)
- Lp(a) / Lipoprotein(a)
- LDL Cholesterol
- HDL Cholesterol
- Triglycerides
- CRP (C-reactive protein)
- Homocysteine
- BNP / NT-proBNP
- Troponin
- HbA1c
- Fasting Insulin
- Coronary Artery Calcium Score (CAC)
- Fibrinogen
- Uric Acid
- LDL Particle Number
- VLDL
- ApoA1
- Omega-3 Index
- Vitamin D (cardiac connection)
- Magnesium (RBC)

---

## 2. Diseases & Conditions 🔥
*"Do I have this?"*

- Coronary Artery Disease
- Heart Failure
- Atrial Fibrillation (AFib)
- Hypertension
- Hyperlipidemia
- Atherosclerosis
- Cardiomyopathy
- Heart Valve Disease
- Arrhythmias
- Peripheral Artery Disease
- Aortic Aneurysm
- Deep Vein Thrombosis
- Pulmonary Embolism
- Myocarditis
- Pericarditis
- Endocarditis
- Congenital Heart Disease
- Heart Murmurs
- Long QT Syndrome
- Wolff-Parkinson-White

---

## 3. Risk Factors 🔥
*"Am I at risk?"*

- Family History
- Smoking
- Diabetes / Prediabetes
- Obesity / Visceral Fat
- Sedentary Lifestyle
- High Blood Pressure
- High Cholesterol
- Chronic Stress
- Poor Sleep / Sleep Apnea
- Age
- Gender Differences
- Metabolic Syndrome
- Chronic Kidney Disease
- Autoimmune Conditions
- Depression / Mental Health
- Air Pollution
- Alcohol
- Processed Food
- Chronic Inflammation
- Insulin Resistance

---

## 4. Diagnostic Tests & Imaging
*"What tests should I get?"*

- ECG/EKG
- Echocardiogram
- Stress Test
- CT Angiography
- Cardiac MRI
- Holter Monitor
- Coronary Calcium Score
- Nuclear Stress Test
- Carotid Ultrasound
- Ankle-Brachial Index
- Cardiac Catheterization
- Electrophysiology Study
- Tilt Table Test
- Event Monitors
- Lipid Panels
- Advanced Lipid Testing
- Genetic Testing
- CIMT (Carotid IMT)
- FFR (Fractional Flow Reserve)
- IVUS

---

## 5. Medications 🔥
*"Should I take this?"*

- Statins
- Blood Thinners (Aspirin, Warfarin, DOACs)
- Beta Blockers
- ACE Inhibitors / ARBs
- Calcium Channel Blockers
- Diuretics
- Nitrates
- Anti-arrhythmics
- PCSK9 Inhibitors
- Ezetimibe
- Bempedoic Acid
- GLP-1 Agonists
- SGLT2 Inhibitors
- Icosapent Ethyl (EPA)
- Colchicine
- Ranolazine
- Digoxin
- Entresto
- Inclisiran
- Combination Therapies

---

## 6. Lifestyle Interventions 🔥
*"What can I DO?"*

- Zone 2 Cardio
- HIIT
- Strength Training
- Walking
- Sleep Optimization
- Stress Management
- Meditation / Mindfulness
- Cold Exposure
- Heat Therapy / Sauna
- Breathing Exercises
- Standing vs Sitting
- Step Count Goals
- Morning Routines
- Evening Routines
- Work-Life Balance
- Social Connection
- Nature Exposure
- Hobby Engagement
- Sexual Health
- Recovery / Rest Days

---

## 7. Nutrition & Diet 🔥
*"What should I eat?"*

- Mediterranean Diet
- Low-Carb / Keto
- Carnivore Diet
- Plant-Based / Vegan
- Intermittent Fasting
- Time-Restricted Eating
- DASH Diet
- Omega-3 Fatty Acids
- Saturated Fat
- Seed Oils Debate
- Salt / Sodium
- Potassium
- Fiber
- Ultra-Processed Foods
- Red Meat
- Coffee
- Alcohol
- Dark Chocolate
- Nuts
- Olive Oil

---

## 8. Procedures & Interventions
*"What happens during...?"*

- Stent Placement
- CABG (Bypass Surgery)
- Ablation
- Pacemaker
- ICD (Defibrillator)
- TAVR
- Angioplasty
- Heart Transplant
- LVAD
- Valve Repair/Replacement
- Cardioversion
- Carotid Endarterectomy
- Watchman Device
- CRT (Resynchronization)
- EECP
- Cardiac Rehab
- Stem Cell Therapy
- Gene Therapy
- Robotic Surgery
- Minimally Invasive Options

---

## 9. Symptoms & Warning Signs 🔥
*"Should I be worried about...?"*

- Chest Pain
- Shortness of Breath
- Palpitations
- Fatigue
- Dizziness / Lightheadedness
- Swelling (Edema)
- Jaw/Arm Pain
- Nausea
- Sweating
- Irregular Heartbeat
- Fainting (Syncope)
- Exercise Intolerance
- Neck Pain
- Back Pain
- Cough
- Wheezing
- Anxiety / Panic
- Leg Pain / Claudication
- Cold Extremities
- Rapid Heart Rate

---

## 10. Prevention Strategies
*"How do I prevent...?"*

- Primary Prevention
- Secondary Prevention
- Screening Schedules
- Risk Calculators
- Lifestyle Medicine
- Preventive Cardiology
- Genetic Risk Mitigation
- Early Detection
- Risk Factor Modification
- Family Screening
- Workplace Wellness
- Community Health
- Health Coaching
- Wearable Monitoring
- Telemedicine
- Annual Checkups
- Know Your Numbers
- Health Literacy
- Shared Decision Making
- Personalized Prevention

---

## 11. Special Populations
*"What about [specific group]?"*

- Women
- Young Adults (<40)
- Elderly (75+)
- Athletes / Active People
- Pregnant Women
- Post-Menopausal Women
- Diabetics
- Cancer Survivors
- Post-COVID
- Kidney Disease Patients
- Thyroid Patients
- Transplant Recipients
- Shift Workers
- Frequent Travelers
- High-Stress Professionals
- Caregivers
- LGBTQ+ Considerations
- Ethnic Variations
- Genetic Conditions
- Mental Health Comorbidity

---

## 12. Heart Anatomy & Physiology
*"How does the heart work?"*

- Heart Chambers
- Valves
- Electrical System
- Coronary Arteries
- Blood Flow
- Cardiac Cycle
- Heart Rate
- Blood Pressure Mechanics
- Vascular System
- Endothelium
- Plaque Formation
- Collateral Circulation
- Heart Rate Variability
- Autonomic Nervous System
- Cardiac Output
- Ejection Fraction
- Preload / Afterload
- Remodeling
- Inflammation Pathways
- Clotting Cascade

---

## 13. Technology & Devices
*"Should I use/trust...?"*

- Smartwatches (Apple, Garmin, etc.)
- CGMs for Non-Diabetics
- Blood Pressure Cuffs
- Pulse Oximeters
- AliveCor / Kardia
- Smart Rings (Oura)
- WHOOP
- Heart Rate Straps
- Smart Scales
- Sleep Trackers
- Stress Monitors
- AI Health Apps
- Telemedicine Platforms
- Remote Patient Monitoring
- Digital Therapeutics
- Wearable ECG
- Home Testing Kits
- VR for Cardiac Rehab
- Robotic Rehab
- Future Tech

---

## 14. Psychosocial & Mental Health 🔥
*"Heart and mind connection"*

- Stress and Heart Disease
- Anxiety and Palpitations
- Depression Post-Event
- Cardiac Psychology
- Type A Personality
- Broken Heart Syndrome
- Health Anxiety
- PTSD (Post-Cardiac Event)
- Support Systems
- Caregiver Burnout
- Return to Work
- Intimacy After Heart Event
- Life Purpose
- Grief and Loss
- Anger Management
- Mindset Shifts
- Cognitive Behavioral Approaches
- Acceptance
- Resilience Building
- Quality of Life

---

## 15. Comorbidities & Connections
*"How is X connected to heart?"*

- Diabetes ↔ Heart
- Kidney ↔ Heart
- Gut ↔ Heart (Microbiome)
- Thyroid ↔ Heart
- Sleep Apnea ↔ Heart
- Autoimmune ↔ Heart
- Cancer Treatment ↔ Heart
- Obesity ↔ Heart
- Liver ↔ Heart
- Inflammation ↔ Heart
- Infections ↔ Heart
- Dental Health ↔ Heart
- Lung Disease ↔ Heart
- Brain ↔ Heart
- Skin Conditions ↔ Heart
- Hormones ↔ Heart
- Allergies ↔ Heart
- Arthritis ↔ Heart
- HIV ↔ Heart
- COVID ↔ Heart

---

## Quick Selection Guide

**For Myth-Busting Videos:** Medications, Nutrition, Risk Factors
**For Educational Explainers:** Diseases, Anatomy, Biomarkers
**For Actionable Content:** Lifestyle, Prevention, Symptoms
**For Trending Topics:** Technology, Special Populations, Psychosocial
**For Case Studies:** Procedures, Diagnostics, Comorbidities
