# Social Listening Guide for Cardiology Content

## Purpose
Find what real people are asking, worried about, and discussing about heart health. Use these insights to create content that resonates and answers actual questions.

---

## Research Workflow

### Step 1: Reddit Deep Dive
Search these subreddits for recent discussions:

**Primary:**
- r/heart - patient experiences, symptoms
- r/cardiology - clinical discussions
- r/AskDocs - health questions with cardio tags
- r/medical - broader health concerns

**Secondary:**
- r/fitness - exercise and heart health intersection
- r/loseit - weight loss + cardiovascular
- r/diabetes - comorbidity discussions
- r/Supplements - heart health supplements queries
- r/over40, r/over50 - age-related heart concerns

**Search queries to use:**
- "[topic] heart"
- "cardiologist said"
- "heart anxiety"
- "worried about heart"
- "is [symptom] normal"
- "heart test results"

**What to capture:**
- Exact phrases people use (not medical jargon)
- Common misconceptions
- Emotional language (fear, confusion, relief)
- Questions that get lots of upvotes/engagement

### Step 2: YouTube Comment Mining
Search YouTube for popular cardiology videos and read comments:

**Search terms:**
- "cardiologist explains"
- "heart disease prevention"
- "[specific condition] explained"
- "heart health tips"

**What to look for:**
- Questions in comments (content gaps)
- "I wish you'd cover..." requests
- Debates/disagreements (controversy = engagement)
- Personal stories shared

### Step 3: Google Trends & Searches
Check trending health topics:

**Use:**
- Google Trends for topic trajectories
- "People also ask" boxes
- Related searches
- Autocomplete suggestions

**Search patterns:**
- "is [X] bad for your heart"
- "can [X] cause heart problems"
- "heart [symptom] meaning"
- "[condition] vs [condition]"

### Step 4: News & Current Events
Check recent health news that could spark interest:

**Sources:**
- Major health news (new studies, guidelines)
- Celebrity health events (non-exploitative angles)
- Seasonal relevance (Heart Month, holidays, etc.)
- New research publications

---

## Insight Categories to Extract

### 1. Pain Points
What problems/fears do people have?
- "I'm terrified of..."
- "My doctor won't listen about..."
- "I don't understand why..."

### 2. Questions
What do they want to know?
- Direct questions
- Confusion about conflicting information
- "Is X true?"

### 3. Misconceptions
What do they believe that's wrong?
- Folk wisdom that's outdated
- Misunderstood research
- Confusing correlation with causation

### 4. Desires
What outcomes do they want?
- Prevention goals
- Symptom relief
- Peace of mind
- Better conversations with doctors

### 5. Language
How do they describe things?
- Colloquial terms vs medical terms
- Emotional descriptors
- Analogies they use

---

## Combining Insights with Seed Ideas

After research, match findings to seed categories:

| Social Insight | Seed Category | Potential Video |
|---------------|---------------|-----------------|
| "Confused about Apo B" | Biomarkers | "Apo B Explained Simply" |
| "Scared of statins" | Medications | "Statin Myths vs Facts" |
| "Can keto hurt heart?" | Nutrition | "Keto and Heart Health Truth" |
| "Young people having attacks" | Risk Factors | "Heart Disease Under 40" |

---

## Red Flags to Avoid

### Don't Create Content About:
- Anything that could delay emergency care
- Unproven treatments presented as fact
- Fear-mongering without actionable advice
- Topics you can't address responsibly in video format

### Handle Carefully:
- Controversial topics (present evidence fairly)
- Anxiety-inducing content (balance with reassurance)
- Alternative medicine (acknowledge without endorsing)

---

## Output Format for Ideation

After social listening, present findings as:

```
## Social Listening Summary

**Hot Topics Right Now:**
1. [Topic] - [Why it's trending]
2. [Topic] - [Why it's trending]

**Questions People Are Asking:**
- "[Exact question from forums]"
- "[Exact question from forums]"

**Misconceptions to Address:**
- [Myth]: What people believe
- [Reality]: What the evidence shows

**Content Opportunities:**
Based on this research + seed ideas, here are video concepts...
```
