# AI Fluency Assessment Workflow

Evidence-based evaluation of AI collaboration skills with scoring rubrics and improvement roadmap.

## Input Required

Use Ask tool to gather:

- 25-35 minutes of focused time from user
- Honest, specific responses (not aspirational)

## Assessment Structure

Evaluate across 5 weighted competencies:

| Competency              | Weight | What It Measures                           |
| ----------------------- | ------ | ------------------------------------------ |
| Prompt Mastery          | 40%    | Constructing effective, structured prompts |
| Technical Understanding | 15%    | Knowledge of AI systems and limitations    |
| Practical Application   | 20%    | Systematic integration into real workflows |
| Critical Evaluation     | 15%    | Validation and verification practices      |
| Workflow Design         | 10%    | Creating repeatable, documented processes  |

Plus: Learning Velocity (informs roadmap, not scored)

## Part 1: Core Skill Tests

### Test 1: Specificity Challenge

Present this generic prompt:

> "Help me write a proposal for a potential client."

Ask user to transform it into their actual working version.

**Evaluate against checklist:**

- Client characteristics (industry, size, decision-making style)
- Proposal type (service agreement, partnership, project bid)
- Desired outcome (meeting, signature, pilot, next steps)
- Constraints (length, tone, timeline, approvals)
- Success criteria (what makes it effective)
- Output format (structure, sections, detail level)

### Test 2: Iteration Test

Present scenario: AI output is 70% right, needs improvement via prompting only.

Ask:

1. Number of revision attempts typically used
2. What first iteration focuses on (exact follow-up prompt)
3. What second iteration focuses on
4. Third iteration (or "I stop at 2")
5. Criteria for knowing output is good enough

### Test 3: Workflow Test

Ask user to describe one specific, regular AI task:

1. **Preparation:** What happens before first prompt?
2. **Initial Prompt:** Detail level, structure, frameworks used
3. **Iteration:** How they refine output to usable result
4. **Quality Check:** What they validate, how they know it's ready
5. **Integration:** What happens to output, final modifications
6. **Tools used:** Which AI tool(s), other tools in process

## Part 2: Technical Understanding

Ask these questions:

1. **Tool Selection:** Which AI tools used regularly? Why chosen over alternatives?
2. **Failure Diagnosis:** Can they explain why a prompt might fail? Specific example?
3. **Context Windows:** Complete: "I understand context windows well enough to..."
4. **Task Suitability:** When to use AI vs not? What makes tasks suitable/unsuitable?
5. **Model Differences (optional):** Meaningful differences noticed between models?

## Part 3: Critical Evaluation

Ask these questions:

1. **Verification Checklist:** What do they ALWAYS check before professional use?
2. **Error Detection:** Specific time AI gave wrong info—how caught, what learned?
3. **Factual Validation:** Process for validating factual claims in output
4. **Uncertainty Handling:** Decision process when unsure if output is accurate
5. **Known Failure Modes:** What they're most careful about, errors watched for

## Part 4: Practical Application

Ask for concrete data:

1. **Usage Volume:** Hours per week actively using AI tools
2. **Time Savings:** 3-5 specific tasks with quantified savings
3. **Workflow Documentation:** Documented processes? Where? If not, why?
4. **Knowledge Transfer:** Taught others their processes? Result? If not, why?
5. **Tool Selection Framework:** How they decide which tool for which task
6. **Integration Barriers:** What prevents more extensive use? Failed attempts?

## Part 5: Velocity Assessment

Ask these questions:

1. **Experience Timeline:** How long using AI at current sophistication level?
2. **Recent Learning:** Last new technique learned, when specifically?
3. **Meta-Learning:** Use AI to learn about AI? Example or reason why not
4. **Skill Acquisition Speed:** Days / Weeks / Months / Stable (stick with known)
5. **Evolution Pattern:** How usage changed past 3-6 months—specifics
6. **Learning Approach:** How they learn new capabilities (courses, docs, experimentation, community)

## Part 6: Advanced Techniques (Optional)

Ask about:

- Custom instructions / system prompts
- API usage / programmatic access
- Multi-tool workflows
- RAG / retrieval systems
- Agent frameworks
- Custom GPTs or Claude Projects
- Prompting frameworks used (RICE, COSTAR, Chain-of-Thought, etc.)

## Scoring Rubric

Score each competency 1-10:

| Level | Characteristics                                  |
| ----- | ------------------------------------------------ |
| 1-2   | Basic or inconsistent use                        |
| 3-4   | Regular use with some structure                  |
| 5-6   | Systematic approach with consistent practices    |
| 7-8   | Advanced integration with documented processes   |
| 9-10  | Expert-level with teaching/building capabilities |

## Output Format

```
## AI Fluency Assessment Results

### Component Scores

| Competency | Score | Weight | Weighted |
|------------|-------|--------|----------|
| Prompt Mastery | X/10 | 40% | X.X |
| Technical Understanding | X/10 | 15% | X.X |
| Practical Application | X/10 | 20% | X.X |
| Critical Evaluation | X/10 | 15% | X.X |
| Workflow Design | X/10 | 10% | X.X |
| **TOTAL** | | | **X.X/10** |

### Score Justification

[For each competency: quote evidence, explain score]

### Learning Velocity

[Assessment of how quickly they're improving]

### Competitive Context

[Where this score places them relative to peers]

### 90-Day Improvement Roadmap

**Month 1:** [Focus area + specific actions]
**Month 2:** [Focus area + specific actions]
**Month 3:** [Focus area + specific actions]

### Immediate Actions (This Week)

1. [Specific action]
2. [Specific action]
3. [Specific action]
```

## Rules

- Score based on demonstrated evidence, not claimed capability
- Vague answers → lower scores
- "I don't do this" is better than vague aspiration
- Inflated claims → misaligned improvement plan
- Be honest—accurate assessment enables growth
