# Practice Drill Workflow

Transform messy real-world situations into focused skill-building exercises.

## Input Required

Use Ask tool to gather:

1. **The messy situation:** Slack thread, vague request, half-formed idea, confusing email chain—whatever they're staring at
2. **Optional context:** Deadline, stakeholders involved, why it matters

## Process

### Step 1: Situation Intake

Ask user to describe the mess however makes sense:

- A Slack thread they're staring at
- A vague ask from their manager
- An idea they had that won't crystallize
- A project that feels stuck
- An email chain that's going nowhere

### Step 2: Skill Identification

Map the situation to one of these core professional skills:

| Skill             | Indicators                                   | Artifact Type                |
| ----------------- | -------------------------------------------- | ---------------------------- |
| **Judgment**      | Multiple valid paths, unclear which is right | Decision doc                 |
| **Orchestration** | Many moving parts, dependencies unclear      | Spec / Project brief         |
| **Coordination**  | Multiple stakeholders, alignment needed      | Stakeholder map / RACI       |
| **Taste**         | Quality unclear, standards undefined         | Rubric / Evaluation criteria |
| **Updating**      | New information, need to change course       | Status update / Pivot memo   |
| **Synthesis**     | Too much information, need clarity           | Executive summary / Brief    |
| **Framing**       | Problem definition unclear                   | Problem statement            |

Explain which skill the situation demands and why.

### Step 3: Artifact Definition

Define the specific artifact to produce:

```
## Your Drill

**Skill being practiced:** [From table above]
**Artifact type:** [Decision doc / Spec / Brief / etc.]
**Time limit:** [15-30 minutes]
**Word limit:** [Appropriate constraint]

**Required sections:**
1. [Section 1]
2. [Section 2]
3. [Section 3]

**Constraints:**
- [Constraint 1]
- [Constraint 2]

**Success criteria:**
- [Measurable criterion 1]
- [Measurable criterion 2]
- [Measurable criterion 3]
```

### Step 4: Execution

User completes the drill within time/word limits.

### Step 5: Evaluation

After user submits artifact, evaluate against:

1. **Does it meet the success criteria?** (Y/N for each)
2. **Time efficiency:** Did they finish within limit?
3. **Constraint adherence:** Did they respect limits?
4. **Skill demonstration:** Does it show the target skill?

```
## Drill Evaluation

**Artifact Received:** [Brief description]
**Time Used:** [If known] / [Limit]
**Word Count:** [If known] / [Limit]

### Success Criteria Check

| Criterion | Met? | Evidence |
|-----------|------|----------|
| [Criterion 1] | ✓/✗ | [Quote or note] |
| [Criterion 2] | ✓/✗ | [Quote or note] |
| [Criterion 3] | ✓/✗ | [Quote or note] |

### Skill Assessment

**Target skill ([Skill name]):** X/5

**What worked:**
- [Specific strength]

**What to improve:**
- [Specific weakness with suggested fix]

### Next Drill Suggestion

Based on this performance, try:
- [Related drill that addresses weakness]
- OR [Harder version of same drill]
```

## Example Transformation

**Messy Input:**

> "My manager asked me to 'figure out what we should do about the support queue' but didn't give any constraints. I've got data showing tickets are up 40% but I don't know if they want a quick fix or a long-term solution or both."

**Drill Output:**

```
## Your Drill

**Skill being practiced:** Judgment (multiple valid paths, need to choose)
**Artifact type:** Decision document
**Time limit:** 25 minutes
**Word limit:** 400 words

**Required sections:**
1. Problem framing (what's actually being decided)
2. Three options with trade-offs
3. Recommendation with reasoning
4. What you'd need to validate the recommendation

**Constraints:**
- Must acknowledge the ambiguity in the original ask
- Must include at least one "do nothing" or "wait for more info" option
- Must quantify at least one trade-off

**Success criteria:**
- Reader understands the decision being made within 30 seconds
- Each option has clear pros/cons, not just description
- Recommendation is defensible even if reader disagrees
```

## Rules

- Drills must be completable in 15-30 minutes
- Constraints force focus—don't skip them
- Success criteria must be measurable
- Evaluation should be honest, not encouraging
- Always suggest next drill based on performance
