# Feynman Technique

Explain a concept as if teaching a child. Gaps in explanation reveal gaps in understanding.

---

## When to Use

- Learning new technical concepts
- Interview preparation
- Verifying you truly understand something
- Preparing to teach or present
- Debugging your own knowledge

---

## The Framework

### Four Steps

1. **Choose** a concept you want to understand
2. **Explain** it in simple language, as if to a 12-year-old
3. **Identify gaps** where you got stuck, used jargon, or hand-waved
4. **Return to source** material to fill gaps
5. **Simplify** and repeat until explanation flows

### The Test

If you can't explain it without jargon, you don't understand it.

---

## Example: Explaining Recursion

### First Attempt (Fails the Test)
"Recursion is when a function calls itself with a modified parameter until it reaches a base case."

**Problem**: Uses jargon ("base case", "modified parameter").

### Second Attempt (Passes)
"Imagine you're looking for your keys in a messy room. You pick up one pile, check it, then ask yourself to check the next pile. You keep asking yourself to check piles until there are no piles left. That's recursion—giving yourself the same task with less stuff each time until there's nothing left to check."

---

## Why It Works

- **Breaks illusion of competence**: Recognizing ≠ understanding
- **Exposes hand-waving**: "It just works" isn't understanding
- **Forces active recall**: Passive reading doesn't build knowledge
- **Reveals connected gaps**: One gap often reveals others

---

## Feynman's Approach

> "In preparing for his oral qualifying examination... he chose not to study the outlines of known physics. Instead he went up to MIT, where he could be alone, and opened a fresh notebook. On the title page he wrote: Notebook Of Things I Don't Know About."

He rebuilt his understanding from scratch.

---

## Application to Interviews

1. Identify concepts likely to come up
2. Explain each to an imaginary 12-year-old
3. Note where you stumble
4. Study those areas specifically
5. Re-explain until fluent

---

## Anti-Patterns

- **Stopping at recognition**: "I know this" isn't "I can explain this"
- **Using the technique once**: Repeat until fluent
- **Explaining to actual experts**: They'll fill in gaps for you

---

## Provenance

Richard Feynman, Nobel laureate physicist. Known for making complex physics accessible. The technique is derived from his learning and teaching methods documented in biographies and his own writings.
