# Perspective Shift Workflow

Break out of conventional thinking by generating radically different viewpoints.

## Input Required

Use Ask tool to gather:

1. **Challenge:** The specific problem or goal (1-2 sentences)
2. **Current Approach:** How they're thinking about it now (1 paragraph max)
3. **Constraints:** Limitations to consider (budget, time, resources, etc.)

## Process

### Step 1: Acknowledge Understanding

Briefly summarize the challenge in your own words (2-3 sentences) to confirm understanding.

### Step 2: Generate Three Perspectives

Create exactly 3 unconventional perspectives, ordered from most practical to most radical.

For each perspective, provide:

| Component              | Description                                                   |
| ---------------------- | ------------------------------------------------------------- |
| **Reframe Title**      | 5-10 words capturing the shift                                |
| **Core Insight**       | 1 sentence explaining the thinking shift                      |
| **Vivid Story**        | 100-150 word thought experiment illustrating this perspective |
| **Memorable Metaphor** | 1 sentence comparing the challenge to something unexpected    |
| **Action Tagline**     | Under 12 words—what to do differently                         |

### Step 3: Implementation Bridge

For the most practical perspective only, add:

- **First concrete step** to take tomorrow
- **Key metric** to track progress
- **Potential obstacle** and how to overcome it

## Perspective Generation Techniques

Use these lenses to generate genuinely different viewpoints:

### Inversion

What if the opposite were true? What if the constraint were an advantage?

### Time Shift

How would you approach this if you had 10x more time? 10x less? How will this look in 5 years?

### Role Swap

How would a competitor see this? A customer? A complete outsider? Someone from a different industry?

### Assumption Burial

What are you assuming that might not be true? What if you eliminated the biggest assumption?

### Scale Shift

What if this were 100x bigger? 100x smaller? What changes?

### Constraint Removal

What would you do if [biggest constraint] didn't exist? Now, what partial version of that is possible?

## Output Format

```
## Perspective Shift Analysis

### Understanding Your Challenge

[2-3 sentence summary showing you understand the problem]

---

### Perspective 1: [Most Practical]

**Reframe:** [5-10 word title]

**Core Insight:** [1 sentence]

**Story:**
[100-150 word thought experiment]

**Metaphor:** [1 sentence comparison]

**Action:** [Under 12 words]

---

### Perspective 2: [Moderately Radical]

**Reframe:** [5-10 word title]

**Core Insight:** [1 sentence]

**Story:**
[100-150 word thought experiment]

**Metaphor:** [1 sentence comparison]

**Action:** [Under 12 words]

---

### Perspective 3: [Most Radical]

**Reframe:** [5-10 word title]

**Core Insight:** [1 sentence]

**Story:**
[100-150 word thought experiment]

**Metaphor:** [1 sentence comparison]

**Action:** [Under 12 words]

---

### Implementation Bridge (Perspective 1)

**Tomorrow:** [First concrete step]

**Measure:** [Key metric to track]

**Obstacle:** [Potential barrier]
**Overcome:** [How to handle it]
```

## Example

**Input:**

- Challenge: "I want to get promoted but my manager doesn't seem to notice my work"
- Current approach: "Working harder and documenting my wins in 1:1s"
- Constraints: "Remote team, manager has 15 direct reports"

**Output Perspectives:**

1. **Most Practical:** "Promote Your Manager First"

   - Core insight: Make your manager look good to _their_ boss, and they'll need you visible.

2. **Moderately Radical:** "Skip the Middle—Build Your Reputation Outside"

   - Core insight: Cross-functional visibility creates pull; your manager will notice when others request you.

3. **Most Radical:** "The Promotion Is Already Happening Elsewhere"
   - Core insight: If your current environment can't see your value, that's data—maybe you're in the wrong room.

## Rules

- Perspectives must be genuinely different, not variations on a theme
- "Most radical" should make them uncomfortable (that's the point)
- Metaphors should surprise—avoid clichés
- Action taglines must be actionable, not philosophical
- Implementation bridge grounds the exercise in reality
