# Stakeholder Navigator Workflow

Analyze complex political situations and develop strategic paths forward.

## Input Required

Use Ask tool to gather:

1. **Situation Context:** All relevant emails, meeting notes, background (be thorough)
2. **Your Role:** Position, authority level, reporting structure
3. **Decision Deadline:** Specific date and why
4. **Desired Outcome:** What success looks like
5. **Constraints:** What cannot be changed

## Analysis Process

### Step 1: Situation Distillation

Summarize into:

- **Core issue** (2-3 sentences)
- **Key tension points** (3-5 bullets)
- **Decision urgency level** (Critical / High / Medium / Low)

### Step 2: Landscape Mapping

**Facts Everyone Agrees On:**

- List 3-5 undisputed facts
- Note their implications

**Points of Disagreement:**

- Issue 1: [What] → Sides: [Who believes what]
- Issue 2: [What] → Sides: [Who believes what]
- Continue as needed

### Step 3: Stakeholder Matrix

For each key person involved:

```
**Stakeholder: [Name - Title]**

| Dimension | Assessment |
|-----------|------------|
| Power Level | High / Medium / Low |
| Current Position | What they want |
| Underlying Interests | Why they want it |
| Influence Levers | What motivates them |
| Relationship to You | Ally / Neutral / Opponent |
| Key Pressure Points | What they fear |
| Best Approach | How to engage them |
```

Repeat for all significant stakeholders.

### Step 4: Strategic Options

Develop exactly 3 paths forward:

**Option 1: [The Collaborative Path]**

- **Specific Actions:** 5 concrete steps
- **Timeline:** When to do what
- **Pros:** 3 main benefits
- **Cons:** 3 main risks
- **Success Probability:** X%
- **Second-Order Effects:** What happens next

**Option 2: [The Assertive Path]**
[Same structure]

**Option 3: [The Strategic Delay Path]**
[Same structure]

### Step 5: Recommendation

Select the recommended option and justify:

- Why this option over the others
- What makes it most likely to succeed given the constraints
- What needs to go right

## Output Format

```
## Political Situation Analysis

### Situation Distillation

**Core Issue:**
[2-3 sentences]

**Key Tension Points:**
- [Tension 1]
- [Tension 2]
- [Tension 3]

**Urgency:** [Level] — [Why]

---

### Landscape Analysis

**Agreed Facts:**
1. [Fact] → Implication: [What this means]
2. [Fact] → Implication: [What this means]
3. [Fact] → Implication: [What this means]

**Disagreements:**
| Issue | Side A | Side B |
|-------|--------|--------|
| [Issue 1] | [Who/Position] | [Who/Position] |
| [Issue 2] | [Who/Position] | [Who/Position] |

---

### Stakeholder Matrix

[Matrix for each stakeholder]

---

### Strategic Options

**Option 1: [Name]**
[Full analysis]

**Option 2: [Name]**
[Full analysis]

**Option 3: [Name]**
[Full analysis]

---

### Recommended Approach

**Recommendation:** Option [X] — [Name]

**Rationale:**
[Why this option]

**72-Hour Action Plan:**

| Timeframe | Action | Purpose |
|-----------|--------|---------|
| Hour 1-4 | [Immediate action] | [Why now] |
| Day 1 | [What to accomplish] | [Expected outcome] |
| Day 2 | [Next steps] | [Expected outcome] |
| Day 3 | [Checkpoint] | [What to assess] |

**Risk Mitigation:**
- If [X happens], then [Y response]
- If [resistance from Z], then [fallback]
- Exit strategy if needed: [When and how to cut losses]
```

## Rules

- All stakeholders have interests—surface them
- Options must be genuinely different approaches, not variations
- Success probability must be honest, not optimistic
- 72-hour plan forces immediate action
- Always include an exit strategy
