---
name: Casebook Editing
description: Guidance for developing and editing legal casebooks
version: 1.0.0
---

# Casebook Editing Skill

**Domain:** Legal casebook development and case editing
**Version:** 1.0.0
**Last Updated:** 2025-12-15

## Overview

This skill provides guidance for developing legal casebooks, including case selection, case editing, note writing, and problem design.

## Casebook Structure

### Standard Chapter Organization

```
Chapter X: [Topic]
├── A. Introduction
│   └── Overview of doctrinal area
├── B. Principal Cases
│   ├── Case 1 (edited)
│   │   └── Notes and Questions
│   ├── Case 2 (edited)
│   │   └── Notes and Questions
│   └── Case 3 (edited)
│       └── Notes and Questions
├── C. Problems
│   └── Hypotheticals for discussion
└── D. Supplementary Materials
    ├── Statutory excerpts
    ├── Secondary readings
    └── Comparative perspectives
```

## Case Selection Principles

### Pedagogical Criteria

1. **Doctrinal clarity** - Does case clearly illustrate the rule?
2. **Factual richness** - Are facts interesting and discussable?
3. **Analytical depth** - Does court's reasoning reward close reading?
4. **Historical significance** - Is this a landmark or foundational case?
5. **Contemporary relevance** - Does case connect to current issues?

### Selection Balance

- **Canonical cases** - Students should know the "greatest hits"
- **Recent cases** - Show doctrine in action today
- **Contrasting cases** - Illustrate doctrinal tensions
- **Problem cases** - Hard cases that test the rule
- **Diversity** - Varied courts, parties, fact patterns

### Sequencing Considerations

- **Chronological** - Show doctrinal evolution
- **Simple to complex** - Build analytical skills
- **Rule to exceptions** - Establish baseline, then complicate
- **Majority to minority** - Show spectrum of approaches

## Case Editing Guidelines

### What to Cut

1. **Procedural history** - Keep only what's necessary
2. **Redundant facts** - Streamline to essentials
3. **Lengthy quotations** - From other cases unless critical
4. **Concurrences/dissents** - Unless pedagogically valuable
5. **Boilerplate language** - Standard of review, etc.

### What to Preserve

1. **Key facts** - Those on which outcome turns
2. **Holding** - The rule of the case
3. **Core reasoning** - Why court reached this conclusion
4. **Notable language** - Quotable formulations
5. **Tensions** - Internal or with other cases

### Editing Conventions

**Omissions:**
```
[Material omitted]
...
* * *
```

**Editorial insertions:**
```
[The court here addresses...]
[Eds.: This case was later overruled in...]
```

**Paragraph breaks:**
- Preserve original paragraph structure where possible
- Add breaks for readability if needed

### Length Guidelines

| Case Type | Target Length | Original Length |
|-----------|---------------|-----------------|
| Principal case | 3-8 pages | 20-50 pages |
| Note case | 0.5-2 pages | Any |
| Problem case | 1-3 pages | Any |

## Notes and Questions

### Types of Notes

1. **Explanatory notes** - Clarify doctrine or context
2. **Problem notes** - Pose hypotheticals
3. **Citation notes** - Point to related cases
4. **Policy notes** - Raise broader implications
5. **Historical notes** - Provide background
6. **Comparative notes** - Contrast approaches

### Effective Questions

**Comprehension questions:**
- What was the holding?
- What facts were dispositive?
- What rule did the court apply?

**Analytical questions:**
- How does this case relate to [prior case]?
- Is the court's reasoning persuasive? Why?
- What would change the outcome?

**Application questions:**
- How would this court decide [hypothetical]?
- Does this rule make sense in [context]?

**Policy questions:**
- What values does this rule serve?
- Who wins and loses under this approach?
- Is there a better rule?

### Question Sequencing

1. Start with comprehension (ensure understanding)
2. Move to analysis (develop skills)
3. Build to synthesis (connect to bigger picture)
4. End with application (test mastery)

## Problem Design

### Effective Problems

**Characteristics:**
- Clearly framed facts
- Specific legal question
- Not obviously one-sided
- Connects to assigned reading
- Admits multiple reasonable analyses

**Structure:**
```
[Factual scenario - 1-3 paragraphs]

Questions:
1. [Specific legal question]
2. [Follow-up or complication]
3. [Policy or broader implication]
```

### Problem Types

1. **Straightforward application** - Test basic rule
2. **Close case** - Facts near the line
3. **Novel facts** - Test rule's boundaries
4. **Multi-issue** - Integrate several concepts
5. **Counseling** - What should client do?
6. **Drafting** - Write clause, statute, etc.

## Supplementary Materials

### When to Include

- Statutes governing the area
- Regulations if relevant
- Model codes or Restatements
- Key secondary sources (excerpted)
- Empirical data if illuminating
- Comparative/international perspectives

### Editing Secondary Sources

- More aggressive editing acceptable
- Focus on thesis and key arguments
- Cut methodological details
- Preserve voice and style

## Available Workflows

- `workflows/case-selection.md` - Choose cases for chapter
- `workflows/case-editing.md` - Edit a case for inclusion
- `workflows/notes-questions.md` - Draft notes and questions

## Quality Checklist

### For Case Edits
- [ ] Key facts preserved
- [ ] Holding clear
- [ ] Reasoning follows
- [ ] Appropriate length
- [ ] Omissions marked
- [ ] Readable flow

### For Notes and Questions
- [ ] Build on case reading
- [ ] Progress in difficulty
- [ ] Mix question types
- [ ] Answerable from materials
- [ ] Engage, don't overwhelm

### For Chapter Overall
- [ ] Coherent arc
- [ ] Balanced coverage
- [ ] Appropriate difficulty
- [ ] Sufficient variety
- [ ] Clear learning objectives

---

*Casebooks teach legal reasoning through carefully curated materials.*
