---
name: chess-commentator
description: This skill should be used when analyzing chess positions. Automatically triggers when users provide FEN positions for analysis or ask about specific chess positions. Provides engine-powered analysis with natural language explanations of best moves, key variations, and strategic/tactical themes.
---

# Chess Commentator

## Overview

Analyze chess positions using Stockfish engine analysis combined with natural language explanations. Provide succinct commentary focusing on the best move, why it's best, and key variations with thematic insights.

## When to Use This Skill

This skill automatically triggers when:
- User provides a FEN string to analyze
- User asks to analyze a chess position
- User asks about best moves in a specific position
- User requests position evaluation or commentary


## Core Workflow

### 0. Install Python dependencies (Only once at start up)

** Only relevant for environments with SVG visualisation enabled ** through Artefacts or similar tools.

The SVG visualization feature requires the python-chess library and should be installed as the 1st step.

```bash
pip install chess==1.11.2
```

### 1. Query endpoints (Recommended)

Use the provided script to retrieve position analysis, concept extraction and SVG or SVG representation of the board. Use the output argument in environment with rich UI (ie Claude Artefact viewwe) able to display SVG images.

```bash
# For environments with rich UI capabilities
python3 scripts/query_analysis.py "<FEN>" --output position.svg

# For terminal like environments
python3 scripts/query_analysis.py "<FEN>"
```

Example:
```bash
python3 scripts/query_analysis.py "rnbqkbnr/pppppppp/8/8/4P3/8/PPPP1PPP/RNBQKBNR b KQkq e3 0 1"
```

### 2. Interpreting Script Output

The script outputs:

1. **Position diagram** - Visual representation of the board
2. **FEN** - Position in FEN notation
3. **Turn** - Who is to move
4. **Engine evaluation and principal lines** - Optionally, the position evaluation in pawns (+positive = White better, -negative = Black better) and sequence of moves in SAN notation
5. **Extracted Concepts** - Optionnaly, key concepts extracted 

### 3. Providing Commentary

Start displaying the board:
 * Use the output svg with Claude's artifact viewer if available,
 * Show the ascii representation in terminal like environment (ie Claude Code).

Provide **succinct commentary** that includes:

### 1. Lichess Analysis Link
Provide a clickable link to analyze the position on Lichess:
`https://lichess.org/analysis/<FEN>`

Replace spaces in the FEN with underscores for the URL. Example:
`https://lichess.org/analysis/r4n1k/4b1pp/1P1p1p2/p2Rp3/2P3P1/4B3/1P3P1P/R5K1_b_-_-_2_31`

### 2. Thematic Insights
If relevant, highlight the key tactical or strategic themes present in the position, grounded in the extracted concepts and their scores, when available:
- Tactical motifs (forks, pins, discoveries, etc.)
- Strategic concepts (weak squares, pawn structure, piece activity, etc.)
- Critical evaluation factors (king safety, material imbalance, initiative, etc.)

### 2. Position Assessment
Briefly state the evaluation (White better / Black better / Equal / Winning / Losing)

### 3. Best Move Explanation
- Identify the best move, using the engine lines if available
- Explain **why** it's best in 1-2 sentences
- Focus on the move's purpose, what it accomplishes, grounded in the position's thematic insights highlighted before

### 4. Key Variations
- Present the main line(s) with brief annotations
- Highlight critical moments or decision points, again grounded in the position's thematic insights highlighted before when relevant
- Use chess notation with explanatory comments


**Reference:** Load `references/chess_themes.md` when needed for comprehensive theme identification.

### 6. Detected Concepts (Optional)
When concept extraction is used, present the full extracted concepts after thematic insights:
- List concepts with confidence ≥ 10%
- Sort by confidence (highest first)
- Format: "Concept name (XX.X%)"
- Keep this section concise - typically 3-5 top concepts

## Commentary Style Guidelines

**DO:**
- Be succinct and focused
- Explain the "why" behind moves
- Use proper chess notation
- Identify concrete themes and patterns
- Compare alternatives when relevant

**DON'T:**
- Write verbose or overly long explanations
- State obvious information without insight
- Ignore the engine's top recommendations without good reason
- Provide generic advice without position-specific analysis

## Example Analysis Format

```
[SVG visualization generated with --output flag, displaying board with colored arrows]

Lichess Analysis: https://lichess.org/analysis/rnbqkbnr/pppppppp/8/8/4P3/8/PPPP1PPP/RNBQKBNR_b_KQkq_e3_0_1

Position Assessment: White has a slight advantage (+0.35)

Best Move: Nf3
This develops the knight to its best square, controlling the center (e5, d4) while preparing kingside castling. It's more flexible than Nc3 as it doesn't block the c-pawn.

Key Variation:
1. Nf3 Nc6 2. d4 d5 3. c4 (Attacking the center, transitioning into a Queen's Gambit structure) 3... e6 4. Nc3 Nf6 (Symmetrical development, both sides complete development before committing to pawn breaks)

Themes:
- Central control: Both moves fight for central squares
- Development: Prioritizing piece activity before committing pawns
- Flexibility: Nf3 maintains options for c4 or e4 pawn breaks

Detected Concepts:
- Development advantage (87.3%)
- Central control (72.1%)
- King safety preparation (45.6%)
- Piece activity (23.4%)
```

## Resources

### references/chess_themes.md
Comprehensive reference of tactical and strategic themes. Load this file when detailed theme identification is needed or when encountering unfamiliar patterns.
