# 自然な表現ガイド

教科書的・直訳的な表現を、ネイティブが使う自然な表現に書き換えるための実践ガイド。

---

## 教科書 vs ネイティブ表現（厳選20例）

### 1. 意見を述べる

- ❌ **教科書**: 我认为这个电影很好。
- ✅ **ネイティブ**: 我觉得这部电影挺好的。
- **理由**: 「认为」→「觉得」: より口語的 / 「这个」→「这部」: 正しい量詞 / 「很好」→「挺好的」: 柔らかいトーン、文末の「的」

---

- ❌ **教科書**: 我的意见是应该这样做。
- ✅ **ネイティブ**: 我觉得应该这么做。
- **理由**: 「我的意见是」は冗長 / 「这样」→「这么」: より口語的

### 2. 程度を表す

- ❌ **教科書**: 这个菜非常好吃。
- ✅ **ネイティブ**: 这菜挺好吃的 / 这菜真好吃。
- **理由**: 「非常」は硬い、フォーマル / 「挺」「真」の方が自然 / 文末の「的」で柔らかく

---

- ❌ **教科書**: 今天的天气十分好。
- ✅ **ネイティブ**: 今天天气真好 / 今天天气挺好的。
- **理由**: 「十分」は書き言葉的 / 「真」「挺」が自然

### 3. 同意する

- ❌ **教科書**: 我同意你的看法。
- ✅ **ネイティブ**: 对啊 / 是啊 / 说得对。
- **理由**: 「同意你的看法」は硬すぎる / 簡潔な相槌が自然

### 4. 提案する

- ❌ **教科書**: 我建议我们去看电影。
- ✅ **ネイティブ**: 要不咱们去看电影？/ 不如去看电影吧？
- **理由**: 「我建议」は硬い / 「要不」「不如」が自然

---

- ❌ **教科書**: 我们应该这样做。
- ✅ **ネイティブ**: 咱们这么做吧 / 这么做比较好。
- **理由**: 「应该」は強すぎる場合がある / 柔らかい提案の方が自然

### 5. 依頼する

- ❌ **教科書**: 请你帮助我。
- ✅ **ネイティブ**: 能帮我一下吗？/ 帮我个忙？
- **理由**: 「请你帮助我」は硬い / 疑問形の方が丁寧

### 6. 感謝する

- ❌ **教科書**: 非常感谢你的帮助。
- ✅ **ネイティブ**: 太谢谢你了 / 谢谢你帮忙。
- **理由**: 「非常感谢」はやや硬い / より直接的な表現が自然

### 7. 謝罪する

- ❌ **教科書**: 对于我的错误，我表示歉意。
- ✅ **ネイティブ**: 不好意思，是我的错 / 对不起，我错了。
- **理由**: 「表示歉意」は硬い / 直接的な謝罪が自然

### 8. 質問する

- ❌ **教科書**: 我想问你一个问题。
- ✅ **ネイティブ**: 我问你个事儿 / 问你一下。
- **理由**: 「问题」→「事儿」: より口語的 / より簡潔

### 9. 時間・予定

- ❌ **教科書**: 我们什么时候见面？
- ✅ **ネイティブ**: 咱们什么时候见？/ 几点见？
- **理由**: 「见面」→「见」: 簡潔 / 「我们」→「咱们」: より親しみがある

### 10. 好き・嫌い

- ❌ **教科書**: 我非常喜欢吃中国菜。
- ✅ **ネイティブ**: 我特别喜欢吃中餐 / 我超爱吃中餐。
- **理由**: 「非常」→「特别」「超」 / 「中国菜」→「中餐」: より一般的

### 11. 評価する

- ❌ **教科書**: 这个电影很有意思。
- ✅ **ネイティブ**: 这电影挺有意思的 / 这电影有点儿意思。
- **理由**: 「很」→「挺」「有点儿」 / 文末の「的」

### 12. 比較する

- ❌ **教科書**: A比B更好。
- ✅ **ネイティブ**: A比B好 / A更好一些。
- **理由**: 比較文では「更」は不要な場合が多い / 「一些」で柔らかく

### 13. 理由を述べる

- ❌ **教科書**: 因为下雨，所以我没去。
- ✅ **ネイティブ**: 因为下雨，我没去 / 下雨了，我没去。
- **理由**: 口語では「因为...所以...」の「所以」を省略することが多い

### 14. 買い物

- ❌ **教科書**: 这个东西多少钱？
- ✅ **ネイティブ**: 这个多少钱？/ 多少钱？
- **理由**: 「东西」は不要

### 15. 食事

- ❌ **教科書**: 你想吃什么食物？
- ✅ **ネイティブ**: 你想吃什么？/ 吃点儿什么？
- **理由**: 「食物」は不要

### 16. 能力・可能

- ❌ **教科書**: 我能够说中文。
- ✅ **ネイティブ**: 我会说中文。
- **理由**: 「能够」は硬い / 能力は「会」

### 17. 経験

- ❌ **教科書**: 我从来没有吃过这个菜。
- ✅ **ネイティブ**: 我没吃过这菜 / 这菜我没吃过。
- **理由**: 「从来」は強調、通常は不要 / 「这个菜」→「这菜」

---

## 直訳的→自然な表現への変換パターン

### パターン1: 量詞の正しい使用

- ❌ 这个电影 → ✅ 这部电影
- ❌ 一个衣服 → ✅ 一件衣服
- ❌ 这个歌 → ✅ 这首歌
- ❌ 那个车 → ✅ 那辆车

### パターン2: 文末の「的」

- ❌ 这个很好 → ✅ 这个挺好的
- ❌ 他很聪明 → ✅ 他挺聪明的

**注意**: すべての形容詞文に「的」をつけるわけではない。
- 感嘆: 太好了！（「的」なし）
- 断定: 这个好。（「的」なし）
- 柔らかい: 这个挺好的。（「的」あり）

### パターン3: 口語的な程度副詞

- ❌ 非常好 → ✅ 挺好的 / 真好 / 特别好
- ❌ 十分喜欢 → ✅ 特别喜欢 / 超喜欢

### パターン4: 動詞の簡潔化

- ❌ 帮助 → ✅ 帮
- ❌ 购买 → ✅ 买
- ❌ 观看 → ✅ 看

### パターン5: 主語の省略（文脈が明確な場合）

- ❌ 我知道了 → ✅ 知道了
- ❌ 我明白了 → ✅ 明白了

### パターン6: 「我们」→「咱们」（包括対話相手）

- ❌ 我们一起去吧 → ✅ 咱们一起去吧
- ❌ 我们明天见 → ✅ 咱们明天见

---

## カジュアル⇄フォーマル変換表

### 挨拶

| カジュアル | 中立 | フォーマル |
|---------|------|---------|
| 嗨 / 你好 | 你好 | 您好 |
| 你在吗？ | 有空吗？ | 请问您现在方便吗？ |

### 依頼

| カジュアル | 中立 | フォーマル |
|---------|------|---------|
| 帮我... | 能帮我...吗？ | 能否请您... |
| 给我... | 请给我... | 烦请... |

### 感謝

| カジュアル | 中立 | フォーマル |
|---------|------|---------|
| 谢啦 | 谢谢 | 非常感谢 |
| 多谢 | 谢谢你 | 感谢您的... |

### 謝罪

| カジュアル | 中立 | フォーマル |
|---------|------|---------|
| 不好意思 | 对不起 | 非常抱歉 |
| 我的错 | 是我不对 | 深表歉意 |

### 同意

| カジュアル | 中立 | フォーマル |
|---------|------|---------|
| 嗯 / 好 | 好的 | 好的，没问题 |
| 对啊 | 是的 | 确实如此 |
| 行 | 可以 | 可以的 |